/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dragndrop.filler;

import de.duehl.swing.ui.dragndrop.DragNDropManagerHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressFiller {
    private final String text;
    private boolean onlyInland;
    private boolean foundAddress;
    private String street;
    private String postCode;
    private String town;
    private String country;
    private boolean called;
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(.*?),?\\s+(\\d{5})\\s+(.*)", 32);
    private static final Pattern ADDRESS_PATTERN_COMMA_NO_SPACE = Pattern.compile("(.*?),(\\d{5})\\s+(.*)", 32);
    private static final Pattern ADDRESS_PATTERN_WITH_D = Pattern.compile("(.*?),?\\s+([A-Z])-(\\d{5})\\s+(.*)", 32);
    private static final Pattern ADDRESS_PATTERN_WITH_LETTER_COUNTRX_KOMMA_NO_SPACE = Pattern.compile("(.*?),([A-Z])-(\\d{5})\\s+(.*)", 32);
    private static final Pattern ADDRESS_PATTERN_FULL_COUNTRY = Pattern.compile("(.*?),?\\s+(\\d{5})\\s+(.*),?\\s+(\\S*)", 32);
    private static final Pattern ADDRESS_PATTERN_FULL_COUNTRY_WITH_KOMMA = Pattern.compile("(.*?),\\s*(\\d{5})\\s+(.*),\\s*(\\S*)", 32);
    private static final Pattern ADDRESS_PATTERN_LETTER_AND_FULL_COUNTRY = Pattern.compile("(.*?),?\\s+([A-Z])-(\\d{5})\\s+(.*),?\\s+(\\S*)", 32);
    private static final Pattern ADDRESS_PATTERN_LETTER_AND_FULL_COUNTRY_WITH_KOMMA = Pattern.compile("(.*?),\\s*([A-Z])-(\\d{5})\\s+(.*),\\s*(\\S*)", 32);

    public AddressFiller(String string) {
        this.text = DragNDropManagerHelper.prepareHtmlDraggedString(string);
        this.street = "";
        this.postCode = "";
        this.town = "";
        this.country = "";
        this.foundAddress = false;
        this.onlyInland = false;
        this.called = false;
    }

    public void onlyInland() {
        this.onlyInland = true;
    }

    public void analyze() {
        this.checkIfCalledTwice();
        if (!this.foundAddress && !this.onlyInland) {
            this.fillWithLetterAndFullCountryWithKomma();
        }
        if (!this.foundAddress && !this.onlyInland) {
            this.fillWithLetterAndFullCountry();
        }
        if (!this.foundAddress && !this.onlyInland) {
            this.fillWithFullCountryWithKomma();
        }
        if (!this.foundAddress && !this.onlyInland) {
            this.fillWithFullCountry();
        }
        if (!this.foundAddress) {
            this.fillWithoutCountry();
        }
        if (!this.foundAddress) {
            this.fillWithoutCountryKommaNoSpace();
        }
        if (!this.foundAddress && !this.onlyInland) {
            this.fillWithLetterCountry();
        }
        if (!this.foundAddress && !this.onlyInland) {
            this.fillWithLetterCountryKommaNoSpace();
        }
    }

    private void checkIfCalledTwice() {
        if (this.called) {
            throw new RuntimeException("In der Klasse " + this.getClass().getName() + " darf analyze() nur einmal aufgerufen werden!");
        }
        this.called = true;
    }

    private void fillWithoutCountry() {
        this.fillIfMatchesStreet1Plz2Ort3(ADDRESS_PATTERN);
    }

    private void fillWithoutCountryKommaNoSpace() {
        this.fillIfMatchesStreet1Plz2Ort3(ADDRESS_PATTERN_COMMA_NO_SPACE);
    }

    private void fillWithLetterCountry() {
        this.fillIfMatchesStreet1Country2Plz3Ort4(ADDRESS_PATTERN_WITH_D);
    }

    private void fillWithLetterCountryKommaNoSpace() {
        this.fillIfMatchesStreet1Country2Plz3Ort4(ADDRESS_PATTERN_WITH_LETTER_COUNTRX_KOMMA_NO_SPACE);
    }

    private void fillWithFullCountry() {
        this.fillIfMatchesStreet1Plz2Ort3Country4(ADDRESS_PATTERN_FULL_COUNTRY);
    }

    private void fillWithFullCountryWithKomma() {
        this.fillIfMatchesStreet1Plz2Ort3Country4(ADDRESS_PATTERN_FULL_COUNTRY_WITH_KOMMA);
    }

    private void fillWithLetterAndFullCountry() {
        this.fillIfMatchesStreet1Country2Plz3Ort4Country5(ADDRESS_PATTERN_LETTER_AND_FULL_COUNTRY);
    }

    private void fillWithLetterAndFullCountryWithKomma() {
        this.fillIfMatchesStreet1Country2Plz3Ort4Country5(ADDRESS_PATTERN_LETTER_AND_FULL_COUNTRY_WITH_KOMMA);
    }

    private void fillIfMatchesStreet1Plz2Ort3(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.text);
        if (matcher.matches()) {
            this.street = matcher.group(1);
            this.postCode = matcher.group(2);
            this.town = matcher.group(3);
            this.foundAddress = true;
        }
    }

    private void fillIfMatchesStreet1Country2Plz3Ort4(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.text);
        if (matcher.matches()) {
            this.street = matcher.group(1).trim();
            this.country = matcher.group(2).trim();
            this.postCode = matcher.group(3).trim();
            this.town = matcher.group(4).trim();
            this.foundAddress = true;
        }
    }

    private void fillIfMatchesStreet1Plz2Ort3Country4(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.text);
        if (matcher.matches()) {
            this.street = matcher.group(1).trim();
            this.postCode = matcher.group(2).trim();
            this.town = matcher.group(3).trim();
            this.country = matcher.group(4).trim();
            this.foundAddress = true;
        }
    }

    private void fillIfMatchesStreet1Country2Plz3Ort4Country5(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.text);
        if (matcher.matches()) {
            this.street = matcher.group(1).trim();
            String string = matcher.group(2).trim();
            this.postCode = matcher.group(3).trim();
            this.town = matcher.group(4).trim();
            String string2 = matcher.group(5).trim();
            this.country = string + " " + string2;
            this.foundAddress = true;
        }
    }

    public boolean foundAddress() {
        return this.foundAddress;
    }

    public String getStreet() {
        return this.street;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public String getTown() {
        return this.town;
    }

    public String getCountry() {
        return this.country;
    }
}

