/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class AutoBackgroundTextField
extends JTextField {
    private static final long serialVersionUID = -4329507767646491689L;
    private final Color filledBackgroundColor;
    private final Color emptyBackgroundColor;

    public AutoBackgroundTextField(int n, Color color, Color color2, boolean bl) {
        super(n);
        this.filledBackgroundColor = color;
        this.emptyBackgroundColor = color2;
        this.setBackground(color2);
        if (bl) {
            this.addEditColorCheck();
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.adjustBackgroundColor();
    }

    private void adjustBackgroundColor() {
        if (this.getText().isEmpty()) {
            this.setBackground(this.emptyBackgroundColor);
        } else {
            this.setBackground(this.filledBackgroundColor);
        }
    }

    private void addEditColorCheck() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AutoBackgroundTextField.this.adjustBackgroundColor();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (AutoBackgroundTextField.this.isEditable()) {
                    AutoBackgroundTextField.this.setBackground(AutoBackgroundTextField.this.filledBackgroundColor);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (AutoBackgroundTextField.this.isEditable()) {
                    AutoBackgroundTextField.this.setBackground(AutoBackgroundTextField.this.filledBackgroundColor);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }
}

