/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.arrowselector;

import de.duehl.swing.ui.elements.arrowselector.ArrowButton;
import de.duehl.swing.ui.elements.arrowselector.ArrowSelectorListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class ArrowSelector
extends JPanel {
    private static final long serialVersionUID = -5111966252366706268L;
    static final Color SELECTED_COLOR = Color.YELLOW;
    static final Color NOT_SELECTED_COLOR = Color.BLUE;
    static final int MAXIMAL_NUMBER_OF_ARROWS_PER_SIDE = 9;
    private final Color selectedColor;
    private final Color notSelectedColor;
    private final int leftestArrowPlace;
    private final int rightetsArrowPlace;
    private final List<ArrowSelectorListener> listeners;

    public ArrowSelector() {
        this(SELECTED_COLOR, NOT_SELECTED_COLOR, -9, 9);
    }

    public ArrowSelector(Color color, Color color2) {
        this(color, color2, -9, 9);
    }

    public ArrowSelector(int n, int n2) {
        this(SELECTED_COLOR, NOT_SELECTED_COLOR, n, n2);
    }

    public ArrowSelector(Color color, Color color2, int n, int n2) {
        super(new GridLayout(1, 0));
        this.selectedColor = color;
        this.notSelectedColor = color2;
        this.leftestArrowPlace = n;
        this.rightetsArrowPlace = n2;
        this.listeners = new ArrayList<ArrowSelectorListener>();
        if (-n > 9) {
            throw new IllegalArgumentException("Zu viele Pfeile links gew\u00e4hlt. Maximal sind 9 erlaubt, gew\u00e4hlt wurden " + -n + ".");
        }
        if (n2 > 9) {
            throw new IllegalArgumentException("Zu viele Pfeile rechts gew\u00e4hlt. Maximal sind 9 erlaubt, gew\u00e4hlt wurden " + n2 + ".");
        }
        this.createArrows();
        this.setPreferredSize(new Dimension(760, 40));
    }

    private void createArrows() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = this.leftestArrowPlace; i <= this.rightetsArrowPlace; ++i) {
            this.addButton(buttonGroup, i);
        }
    }

    private void addButton(ButtonGroup buttonGroup, final int n) {
        ArrowButton arrowButton = new ArrowButton(this, n, this.selectedColor, this.notSelectedColor);
        arrowButton.setName(String.format("%s", n));
        arrowButton.setRolloverEnabled(false);
        arrowButton.setPressedIcon(null);
        arrowButton.setSelectedIcon(null);
        arrowButton.setPressedIcon(null);
        this.add(arrowButton);
        buttonGroup.add(arrowButton);
        arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ArrowSelectorListener arrowSelectorListener : ArrowSelector.this.listeners) {
                    arrowSelectorListener.reactOnButtonSelection(n);
                }
            }
        });
    }

    public void addArrowSelectorListener(ArrowSelectorListener arrowSelectorListener) {
        this.listeners.add(arrowSelectorListener);
    }
}

