/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.slider;

import de.duehl.basics.datetime.time.TimeHelper;
import de.duehl.swing.ui.elements.slider.data.TimeSliderUser;
import de.duehl.swing.ui.elements.slider.data.UpdateRunnable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

public class TimeRunningSlider {
    private TimeSliderUser sliderUser;
    private final JSlider slider;
    private long millisStarted;
    private long deltaMillis;
    private long millisToStop;
    private long millisPausedAt;
    private UpdateRunnable updateRunnable;
    private int secondsPlayedBeforeStart;
    private int sliderStartValue;
    private volatile boolean ignoreSliderChanges;
    private boolean showActualTimeAsToolTip;

    public TimeRunningSlider(TimeSliderUser timeSliderUser) {
        this.sliderUser = timeSliderUser;
        this.ignoreSliderChanges = false;
        this.showActualTimeAsToolTip = false;
        this.slider = new JSlider();
        this.initSlider();
    }

    private void initSlider() {
        this.slider.setMinimum(0);
        this.slider.setMaximum(0);
        this.slider.setValue(0);
        this.slider.setPaintTicks(false);
        this.slider.setSnapToTicks(false);
        this.slider.setMajorTickSpacing(1000);
        this.slider.setMinorTickSpacing(15000);
        this.slider.addChangeListener(changeEvent -> this.sliderChangedStarted());
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TimeRunningSlider.this.sliderChanged();
            }
        });
    }

    private void sliderChangedStarted() {
        if (this.ignoreSliderChanges) {
            return;
        }
        if (!this.sliderUser.isPaused()) {
            this.sliderUser.pause();
        }
    }

    private void sliderChanged() {
        this.sliderUser.resume(this.slider.getValue(), this.slider.getMaximum());
    }

    public void showActualTimeAsToolTip() {
        this.showActualTimeAsToolTip = true;
    }

    public void showNoToolTip() {
        this.showActualTimeAsToolTip = false;
    }

    public void start(int n, int n2, int n3) {
        this.stopActualisationRunnable();
        this.secondsPlayedBeforeStart = n;
        this.sliderStartValue = n3;
        this.millisStarted = System.currentTimeMillis();
        this.deltaMillis = 1000L * (long)n2;
        this.millisToStop = this.millisStarted + this.deltaMillis;
        int n4 = (int)this.deltaMillis;
        this.ignoreSliderChanges = true;
        this.slider.setMaximum(n4);
        this.slider.setValue(n3);
        this.ignoreSliderChanges = false;
        String string = TimeHelper.secondsToMinutesSeconds(n2);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(0, new JLabel("0"));
        hashtable.put(n4, new JLabel(string));
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintLabels(true);
        this.createRunnableAndStartActualisationThread();
    }

    private void createRunnableAndStartActualisationThread() {
        long l = 10L;
        this.updateRunnable = new UpdateRunnable(() -> this.updateSlider(), l);
        Thread thread = new Thread(this.updateRunnable);
        thread.start();
    }

    private void updateSlider() {
        SwingUtilities.invokeLater(() -> this.updateSliderInEdt());
    }

    private synchronized void updateSliderInEdt() {
        long l = System.currentTimeMillis();
        if (l >= this.millisToStop) {
            this.ignoreSliderChanges = true;
            this.slider.setValue(this.slider.getMaximum());
            this.ignoreSliderChanges = false;
            this.stop();
        } else {
            long l2 = l - this.millisStarted;
            this.ignoreSliderChanges = true;
            this.slider.setValue((int)l2 + this.sliderStartValue);
            this.ignoreSliderChanges = false;
            if (this.showActualTimeAsToolTip) {
                this.showActualTimeAsToolTip(l2);
            }
        }
    }

    private void showActualTimeAsToolTip(long l) {
        int n = (int)(l / 1000L) + this.secondsPlayedBeforeStart;
        String string = TimeHelper.secondsToMinutesSeconds(n);
        this.slider.setToolTipText(string);
    }

    public void stop() {
        this.stopActualisationRunnable();
    }

    public void pause() {
        this.millisPausedAt = System.currentTimeMillis();
        this.updateRunnable.stop();
    }

    public void resume() {
        long l = System.currentTimeMillis();
        long l2 = l - this.millisPausedAt;
        this.millisStarted += l2;
        this.millisToStop += l2;
        this.createRunnableAndStartActualisationThread();
    }

    private void stopActualisationRunnable() {
        if (null != this.updateRunnable) {
            this.updateRunnable.stop();
        }
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public int getSliderValue() {
        return this.slider.getValue();
    }

    public void setSliderValue(int n) {
        this.slider.setValue(n);
    }

    public int getSecondsPlayed() {
        long l = System.currentTimeMillis();
        long l2 = l - this.millisStarted;
        int n = (int)(l2 / 1000L) + this.secondsPlayedBeforeStart;
        return n;
    }
}

