/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.contextmenu;

import de.duehl.swing.ui.highlightingeditor.contextmenu.EditorForContextMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class EditorPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private final EditorForContextMenu editor;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem insertItem;

    public EditorPopupMenu(EditorForContextMenu editorForContextMenu) {
        this.editor = editorForContextMenu;
        editorForContextMenu.addMouseListener(this.createMouseAdapter());
        this.add(this.createCutSelectionMenuItem());
        this.add(this.createCopySelectionMenuItem());
        this.add(this.createInsertSelectionMenuItem());
        this.addSeparator();
        this.add(this.createSelectAllMenuItem());
    }

    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditorPopupMenu.this.handleContextMenu();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EditorPopupMenu.this.handleContextMenu();
            }
        };
    }

    private void handleContextMenu() {
        String string = this.editor.getSelectedText();
        boolean bl = null == string || string.isEmpty();
        this.cutItem.setEnabled(!bl);
        this.copyItem.setEnabled(!bl);
    }

    private JMenuItem createCutSelectionMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Ausschneiden");
        jMenuItem.addActionListener(actionEvent -> this.editor.cutSelection());
        this.cutItem = jMenuItem;
        return jMenuItem;
    }

    private JMenuItem createCopySelectionMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Kopieren");
        jMenuItem.addActionListener(actionEvent -> this.editor.copySelection());
        this.copyItem = jMenuItem;
        return jMenuItem;
    }

    private JMenuItem createInsertSelectionMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Einf\u00fcgen");
        jMenuItem.addActionListener(actionEvent -> this.editor.insertSelection());
        this.insertItem = jMenuItem;
        return jMenuItem;
    }

    private JMenuItem createSelectAllMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Alles ausw\u00e4hlen");
        jMenuItem.addActionListener(actionEvent -> this.editor.selectAll());
        return jMenuItem;
    }

    public void deactivateInsertMenuItem() {
        this.insertItem.setEnabled(false);
    }
}

