/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.syntax.highlighting;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingTokens;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingType;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;
import de.duehl.swing.ui.highlightingeditor.syntax.highlighting.Highlighting;
import java.awt.Color;
import java.util.List;

class JavaSyntaxHighlighting
implements Highlighting {
    private final SyntaxHighlighting sytaxHighlighting;

    JavaSyntaxHighlighting() {
        HighlightingType highlightingType = JavaSyntaxHighlighting.createKeywordHighlightingType();
        HighlightingType highlightingType2 = JavaSyntaxHighlighting.createSymbolHighlightingType();
        this.sytaxHighlighting = new SyntaxHighlighting(highlightingType, highlightingType2);
        this.addKeywords();
        this.addSymbols();
        this.addOther();
    }

    private static HighlightingType createKeywordHighlightingType() {
        return new HighlightingType(JavaSyntaxHighlighting.createColor("aubergine"), true);
    }

    private static HighlightingType createSymbolHighlightingType() {
        return new HighlightingType(JavaSyntaxHighlighting.createColor("forestgreen"), false, true);
    }

    private static Color createColor(String string) {
        return new NamedColorListFabric().getColorByName(string);
    }

    private void addKeywords() {
        List<String> list = CollectionsHelper.buildListFrom("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "exports", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "module", "native", "new", "open", "opens", "package", "private", "protected", "provides", "public", "requires", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "to", "transient", "transitive", "try", "uses", "void", "volatile", "while", "with");
        for (String string : list) {
            this.sytaxHighlighting.addKeyword(string);
        }
    }

    private void addSymbols() {
        List<String> list = CollectionsHelper.buildListFrom("+", "-", ":", ",", "=", ";", "!", "(", ")", "[", "]", "{", "}", "'", "\"");
        for (String string : list) {
            this.sytaxHighlighting.addSymbol(string);
        }
    }

    private void addOther() {
    }

    private void addOther(String string, String ... stringArray) {
        HighlightingType highlightingType = new HighlightingType(JavaSyntaxHighlighting.createColor(string), true, false);
        HighlightingTokens highlightingTokens = new HighlightingTokens(highlightingType);
        for (String string2 : stringArray) {
            highlightingTokens.addToken(string2);
        }
        this.sytaxHighlighting.addOtherHighlightingTokens(highlightingTokens);
    }

    @Override
    public SyntaxHighlighting create() {
        return this.sytaxHighlighting;
    }
}

