/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.io.lock;

import de.duehl.basics.io.lock.Lock;
import de.duehl.swing.ui.io.lock.ui.NoLockGainedDialog;

public abstract class InteractiveProgramLock<T extends Lock>
implements Lock {
    private final T lock;

    public InteractiveProgramLock(T t) {
        this.lock = t;
    }

    @Override
    public boolean lock() {
        return this.lock.lock();
    }

    @Override
    public boolean unlock() {
        return this.lock.unlock();
    }

    @Override
    public String getFilename() {
        return this.lock.getFilename();
    }

    public void lock(Runnable runnable, Runnable runnable2) {
        boolean bl = this.lock();
        if (bl) {
            runnable.run();
        } else {
            boolean bl2 = this.handleNoLockGained();
            if (bl2) {
                this.lock(runnable, runnable2);
            } else {
                runnable2.run();
            }
        }
    }

    private boolean handleNoLockGained() {
        NoLockGainedDialog noLockGainedDialog = new NoLockGainedDialog(this.createNoLockGainedDialogTitle(), this.createNoLockGainedDialogMessage());
        noLockGainedDialog.setVisible(true);
        switch (noLockGainedDialog.getAnswer()) {
            default: {
                return false;
            }
            case REMOVE_LOCK_AND_RETRY: {
                this.unlock();
                return true;
            }
            case RETRY_WITHOUT_REMOVING_LOCK: 
        }
        return true;
    }

    protected abstract String createNoLockGainedDialogTitle();

    protected abstract String createNoLockGainedDialogMessage();
}

