/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.update;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.update.UpdateGui;
import de.duehl.swing.ui.update.informer.NoUpdateAfterDayChangeInformer;
import de.duehl.swing.ui.update.informer.NoUpdateIntervalInSecondsChangeInformer;
import de.duehl.swing.ui.update.informer.UpdateAfterDayChangeInformer;
import de.duehl.swing.ui.update.informer.UpdateIntervalInSecondsChangeInformer;
import java.util.Timer;
import java.util.TimerTask;

public class UpdateLogic
implements Quitter {
    public static final int MINIMAL_UPDATE_INTERVAL_IN_SECONDS = 5;
    public static final int MAXIMAL_UPDATE_INTERVAL_IN_SECONDS = 1800;
    public static final int UPDATE_INTERVAL_IN_SECONDS = 10;
    private static final boolean DEBUG = false;
    private final Runnable job;
    private final String jobDescritpion;
    private final UpdateGui gui;
    private final int minimalUpdateIntervalInSeconds;
    private final int maximalUpdateIntervalInSeconds;
    private Timer timer;
    private int updateIntervalInSeconds;
    private int updateCount;
    private UpdateAfterDayChangeInformer updateAfterDayChangeInformer;
    private UpdateIntervalInSecondsChangeInformer updateIntervalInSecondsChangeInformer;
    private boolean wasUpdated;
    private DateAndTime lastUpdateDateAndTime;
    private boolean changeUpdateIntervalIfUpdateTookTooLong;

    public UpdateLogic(Runnable runnable, String string, UpdateGui updateGui, int n) {
        this(runnable, string, updateGui, n, 5, 1800);
    }

    public UpdateLogic(Runnable runnable, String string, UpdateGui updateGui, int n, int n2, int n3) {
        this.job = runnable;
        this.jobDescritpion = string;
        this.gui = updateGui;
        this.updateIntervalInSeconds = n;
        this.minimalUpdateIntervalInSeconds = n2;
        this.maximalUpdateIntervalInSeconds = n3;
        this.updateAfterDayChangeInformer = new NoUpdateAfterDayChangeInformer();
        this.updateIntervalInSecondsChangeInformer = new NoUpdateIntervalInSecondsChangeInformer();
        this.changeUpdateIntervalIfUpdateTookTooLong = true;
        updateGui.setlogic(this);
        this.updateCount = 0;
    }

    public void setUpdateAfterDayChangeInformer(UpdateAfterDayChangeInformer updateAfterDayChangeInformer) {
        this.updateAfterDayChangeInformer = updateAfterDayChangeInformer;
    }

    public void setUpdateIntervalInSecondsChangeInformer(UpdateIntervalInSecondsChangeInformer updateIntervalInSecondsChangeInformer) {
        this.updateIntervalInSecondsChangeInformer = updateIntervalInSecondsChangeInformer;
    }

    public void doNotChangeUpdateIntervalIfUpdateTookTooLong() {
        this.changeUpdateIntervalIfUpdateTookTooLong = false;
    }

    String checkUpdateIntervalInSecondsIsInRange(int n) {
        if (n < this.minimalUpdateIntervalInSeconds || n > this.maximalUpdateIntervalInSeconds) {
            int n2 = this.maximalUpdateIntervalInSeconds / 60;
            return "Das Aktualisierungsintervall muss statt " + NumberString.taupu(n) + " zwischen " + NumberString.taupu(this.minimalUpdateIntervalInSeconds) + " Sekunden und " + NumberString.taupu(n2) + " Minuten liegen!";
        }
        return "";
    }

    public void setUpdateIntervalInSecondsWithoutRun(int n) {
        String string = this.checkUpdateIntervalInSecondsIsInRange(n);
        if (string.isEmpty()) {
            this.reallySetUpdateIntervalInSeconds(n);
        }
    }

    int getUpdateIntervalInSeconds() {
        return this.updateIntervalInSeconds;
    }

    void setUpdateIntervalInSeconds(int n) {
        if (this.updateIntervalInSeconds != n) {
            if (n < this.minimalUpdateIntervalInSeconds || n > this.maximalUpdateIntervalInSeconds) {
                throw new RuntimeException("Der \u00fcbergebene Abstand zwischen den Ausf\u00fchrungen des Tasks in Sekunden liegt au\u00dferhalb des Zul\u00e4ssigen Bereichs!\n\t\u00dcbergebener Abstand       : " + n + "\n\tMinimal zul\u00e4ssiger Abstand: " + this.minimalUpdateIntervalInSeconds + "\n\tMaximal zul\u00e4ssiger Abstand: " + this.maximalUpdateIntervalInSeconds);
            }
            UpdateLogic.say("Start");
            this.cancelTimer();
            this.reallySetUpdateIntervalInSeconds(n);
            this.updateNow();
            UpdateLogic.say("Ende");
        }
    }

    private void reallySetUpdateIntervalInSeconds(int n) {
        this.updateIntervalInSeconds = n;
        this.updateIntervalInSecondsChangeInformer.informAboutUpdateIntervalInSecondsChange(n);
    }

    void updateNow() {
        UpdateLogic.say("Start");
        this.cancelTimer();
        this.update();
        UpdateLogic.say("Ende");
    }

    private void update() {
        UpdateLogic.say("Start");
        this.runJob();
        UpdateLogic.say("nach checkDatabase()");
        this.scheduleNextTask();
        UpdateLogic.say("Ende");
    }

    private void runJob() {
        UpdateLogic.say("Start");
        this.checkForUpdateAfterDayChange();
        this.gui.startLongTimeProcess(this.jobDescritpion + " l\u00e4uft");
        new Thread(() -> this.runJobInOwnThread()).start();
        UpdateLogic.say("Ende");
    }

    private void checkForUpdateAfterDayChange() {
        if (this.wasUpdated) {
            DateAndTime dateAndTime = new DateAndTime();
            if (!dateAndTime.getDate().equals(this.lastUpdateDateAndTime.getDate())) {
                this.updateAfterDayChangeInformer.informAboutUpdateAfterDayChange();
            }
        } else {
            this.wasUpdated = true;
        }
        this.lastUpdateDateAndTime = new DateAndTime();
    }

    private void runJobInOwnThread() {
        UpdateLogic.say("Start");
        DateAndTime dateAndTime = new DateAndTime();
        StopWatch stopWatch = new StopWatch();
        this.job.run();
        this.gui.jobDone(stopWatch.getTime(), ++this.updateCount, dateAndTime);
        UpdateLogic.say("Ende");
    }

    private void scheduleNextTask() {
        UpdateLogic.say("Start");
        this.cancelTimer();
        this.gui.showIntervalTimeInSeconds(this.updateIntervalInSeconds);
        UpdateLogic.say("new Timer");
        UpdateLogic.say("Starte task in " + this.updateIntervalInSeconds + " Sekunden...");
        this.timer = new Timer();
        this.timer.schedule(this.defineTask(), 1000 * this.updateIntervalInSeconds);
        this.gui.restartCountDownWatch(this.updateIntervalInSeconds);
        UpdateLogic.say("Ende");
    }

    private TimerTask defineTask() {
        return new TimerTask(){

            @Override
            public void run() {
                UpdateLogic.this.update();
            }
        };
    }

    public synchronized void changeUpdateIntervalIfUpdateTookTooLong(long l) {
        if (this.changeUpdateIntervalIfUpdateTookTooLong) {
            UpdateLogic.say("Start");
            UpdateLogic.say("seconds = " + l);
            UpdateLogic.say("updateIntervalInSeconds / 2 = " + this.updateIntervalInSeconds / 2);
            if (l > (long)(this.updateIntervalInSeconds / 2)) {
                long l2 = l * 10L;
                if (l2 > (long)this.maximalUpdateIntervalInSeconds) {
                    this.updateIntervalInSeconds = this.maximalUpdateIntervalInSeconds;
                    UpdateLogic.say("Zu gro\u00df! Setze auf " + this.updateIntervalInSeconds);
                } else {
                    this.updateIntervalInSeconds = (int)l2;
                    UpdateLogic.say("Setze auf " + this.updateIntervalInSeconds);
                }
                this.scheduleNextTask();
            }
            UpdateLogic.say("Ende");
        }
    }

    @Override
    public void quit() {
        UpdateLogic.say("Start");
        this.cancelTimer();
        this.gui.quit();
        UpdateLogic.say("Ende");
    }

    private void cancelTimer() {
        UpdateLogic.say("Start");
        if (null != this.timer) {
            UpdateLogic.say("timer.cancel()");
            this.timer.cancel();
            this.timer = null;
        }
        UpdateLogic.say("Ende");
    }

    static void say(String string) {
    }
}

