/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.data;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InternalAdditionalKanjiData {
    private String filename = "";
    private String key = "";
    private ImmutualDate firstSeenDate = InternalAdditionalVocableData.NOT_SEEN_DATE;
    private int testCount = 0;
    private int correctTestCount = 0;
    private ImmutualDate lastTestDate = InternalAdditionalVocableData.NOT_SEEN_DATE;
    private ImmutualDate lastCorrectTestDate = InternalAdditionalVocableData.NOT_SEEN_DATE;
    private List<Boolean> lastTenTestResults = new ArrayList<Boolean>();
    private static final int NUMBER_OF_LINES = 7;

    public String getFilename() {
        return this.filename;
    }

    public InternalAdditionalKanjiData setFilename(String string) {
        this.filename = string;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public InternalAdditionalKanjiData setKey(String string) {
        this.key = string;
        return this;
    }

    public ImmutualDate getFirstSeenDate() {
        return this.firstSeenDate;
    }

    public InternalAdditionalKanjiData setFirstSeenDate(ImmutualDate immutualDate) {
        this.firstSeenDate = immutualDate;
        return this;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public InternalAdditionalKanjiData setTestCount(int n) {
        this.testCount = n;
        return this;
    }

    public int getCorrectTestCount() {
        return this.correctTestCount;
    }

    public InternalAdditionalKanjiData setCorrectTestCount(int n) {
        this.correctTestCount = n;
        return this;
    }

    public ImmutualDate getLastTestDate() {
        return this.lastTestDate;
    }

    public InternalAdditionalKanjiData setLastTestDate(ImmutualDate immutualDate) {
        this.lastTestDate = immutualDate;
        return this;
    }

    public ImmutualDate getLastCorrectTestDate() {
        return this.lastCorrectTestDate;
    }

    public InternalAdditionalKanjiData setLastCorrectTestDate(ImmutualDate immutualDate) {
        this.lastCorrectTestDate = immutualDate;
        return this;
    }

    public String getLastTenTestResultsAsStorageString() {
        return InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenTestResults);
    }

    public List<Boolean> getLastTenTestResults() {
        return this.lastTenTestResults;
    }

    public int getLastTenTestsCount() {
        return this.lastTenTestResults.size();
    }

    public int getLastCorrectTestsCount() {
        return InternalAdditionalVocableData.getLastCorrectTestsCount(this.lastTenTestResults);
    }

    public InternalAdditionalKanjiData initLastTenTestResultsFromStorageString(String string) {
        InternalAdditionalVocableData.initLastTenTestResultsFromStorageString(this.lastTenTestResults, string);
        return this;
    }

    public void tested(boolean bl) {
        this.testedWithoutSave(bl);
        this.save();
    }

    private void testedWithoutSave(boolean bl) {
        ImmutualDate immutualDate = new ImmutualDate();
        this.increaseTestCount();
        this.setLastTestDate(immutualDate);
        if (bl) {
            this.increaseCorrectTestCount();
            this.setLastCorrectTestDate(immutualDate);
        }
        this.lastTenTestResults.add(bl);
        while (this.lastTenTestResults.size() > 10) {
            this.lastTenTestResults.remove(0);
        }
    }

    private void increaseTestCount() {
        ++this.testCount;
    }

    private void increaseCorrectTestCount() {
        ++this.correctTestCount;
    }

    public static InternalAdditionalKanjiData load(String string) {
        List<String> list = FileHelper.readFileToList(string, Charset.UTF_8);
        if (list.size() == 7) {
            return InternalAdditionalKanjiData.loadFromNormalFormat(string, list);
        }
        throw new RuntimeException("Die Datei " + string + " enth\u00e4lt nicht wie erwartet 7 Zeilen.");
    }

    private static InternalAdditionalKanjiData loadFromNormalFormat(String string, List<String> list) {
        int n = 0;
        String string2 = list.get(n++);
        String string3 = list.get(n++);
        String string4 = list.get(n++);
        String string5 = list.get(n++);
        String string6 = list.get(n++);
        String string7 = list.get(n++);
        String string8 = list.get(n++);
        int n2 = NumberString.parseInt(string4);
        int n3 = NumberString.parseInt(string5);
        ImmutualDate immutualDate = new ImmutualDate(string3);
        ImmutualDate immutualDate2 = new ImmutualDate(string6);
        ImmutualDate immutualDate3 = new ImmutualDate(string7);
        InternalAdditionalKanjiData internalAdditionalKanjiData = new InternalAdditionalKanjiData();
        internalAdditionalKanjiData.setFilename(string);
        internalAdditionalKanjiData.setKey(string2);
        internalAdditionalKanjiData.setFirstSeenDate(immutualDate);
        internalAdditionalKanjiData.setTestCount(n2);
        internalAdditionalKanjiData.setCorrectTestCount(n3);
        internalAdditionalKanjiData.setLastTestDate(immutualDate2);
        internalAdditionalKanjiData.setLastCorrectTestDate(immutualDate3);
        internalAdditionalKanjiData.initLastTenTestResultsFromStorageString(string8);
        return internalAdditionalKanjiData;
    }

    public void save() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.key);
        arrayList.add(this.firstSeenDate.toString());
        arrayList.add(Integer.toString(this.testCount));
        arrayList.add(Integer.toString(this.correctTestCount));
        arrayList.add(this.lastTestDate.toString());
        arrayList.add(this.lastCorrectTestDate.toString());
        arrayList.add(InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenTestResults));
        FileHelper.writeLinesToFile(arrayList, this.filename, Charset.UTF_8);
    }

    public String toString() {
        return "InternalAdditionalKanjiData [filename=" + this.filename + ", key=" + this.key + ", firstSeenDate=" + this.firstSeenDate + ", testCount=" + this.testCount + ", correctTestCount=" + this.correctTestCount + ", lastTestDate=" + this.lastTestDate + ", lastCorrectTestDate=" + this.lastCorrectTestDate + ", lastTenTestResults=" + this.lastTenTestResults + "]";
    }

    public String toNiceString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Text.multipleString(" ", n);
        stringBuilder.append(string + "InternalAdditionalKanjiData:\n");
        stringBuilder.append(string + "filename           : " + this.filename + "\n");
        stringBuilder.append(string + "key                : " + this.key + "\n");
        stringBuilder.append(string + "firstSeenDate      : " + this.firstSeenDate + "\n");
        stringBuilder.append(string + "getestet          : " + this.testCount + "\n");
        stringBuilder.append(string + "correctTestCount   : " + this.correctTestCount + "\n");
        stringBuilder.append(string + "lastTestDate       : " + this.lastTestDate + "\n");
        stringBuilder.append(string + "lastCorrectTestDate: " + this.lastCorrectTestDate + "\n");
        stringBuilder.append(string + "lastTenTestResults : " + InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenTestResults) + "\n");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.correctTestCount, this.filename, this.firstSeenDate, this.key, this.lastCorrectTestDate, this.lastTenTestResults, this.lastTestDate, this.testCount);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InternalAdditionalKanjiData internalAdditionalKanjiData = (InternalAdditionalKanjiData)object;
        return this.correctTestCount == internalAdditionalKanjiData.correctTestCount && Objects.equals(this.filename, internalAdditionalKanjiData.filename) && Objects.equals(this.firstSeenDate, internalAdditionalKanjiData.firstSeenDate) && Objects.equals(this.key, internalAdditionalKanjiData.key) && Objects.equals(this.lastCorrectTestDate, internalAdditionalKanjiData.lastCorrectTestDate) && Objects.equals(this.lastTenTestResults, internalAdditionalKanjiData.lastTenTestResults) && Objects.equals(this.lastTestDate, internalAdditionalKanjiData.lastTestDate) && this.testCount == internalAdditionalKanjiData.testCount;
    }
}

