/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.persistence.data;

import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;
import java.util.ArrayList;
import java.util.List;

public class HistoricalOwnListPersistanceDataList {
    private static final int DEFAULT_NUMBER_OF_REMEBERED_OWN_LISTS = 10;
    private int numberOfRememberedOwnLists;
    private final List<OwnListPersistanceData> historicalOwnLists;
    private static final String LIST_PERISTANCE_SEPARATOR = "###;###";

    public HistoricalOwnListPersistanceDataList() {
        this(10);
    }

    public HistoricalOwnListPersistanceDataList(int n) {
        this.numberOfRememberedOwnLists = n;
        this.historicalOwnLists = new ArrayList<OwnListPersistanceData>();
    }

    public void addOwnListData(OwnListPersistanceData ownListPersistanceData) {
        this.historicalOwnLists.remove(ownListPersistanceData);
        this.historicalOwnLists.add(ownListPersistanceData);
        this.deleteOldEntriesIfListIsTooLong();
    }

    private void deleteOldEntriesIfListIsTooLong() {
        int n = this.historicalOwnLists.size() - this.numberOfRememberedOwnLists;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.historicalOwnLists.remove(0);
            }
        }
    }

    public void setNumberOfRememberedOwnLists(int n) {
        this.numberOfRememberedOwnLists = n;
        this.deleteOldEntriesIfListIsTooLong();
    }

    public List<OwnListPersistanceData> getHistoricalOwnLists() {
        return this.historicalOwnLists;
    }

    public boolean isEmpty() {
        return this.historicalOwnLists.isEmpty();
    }

    public String toPersistanceString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (OwnListPersistanceData ownListPersistanceData : this.historicalOwnLists) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(LIST_PERISTANCE_SEPARATOR);
            }
            stringBuilder.append(ownListPersistanceData.toPersistanceString());
        }
        return stringBuilder.toString();
    }

    public static HistoricalOwnListPersistanceDataList createFromPersistanceString(String string, int n) {
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = new HistoricalOwnListPersistanceDataList(n);
        List<String> list = Text.splitBy(string, LIST_PERISTANCE_SEPARATOR);
        for (String string2 : list) {
            OwnListPersistanceData ownListPersistanceData = OwnListPersistanceData.createFromPersistanceString(string2);
            historicalOwnListPersistanceDataList.addOwnListData(ownListPersistanceData);
        }
        historicalOwnListPersistanceDataList.deleteOldEntriesIfListIsTooLong();
        return historicalOwnListPersistanceDataList;
    }
}

