/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.ownlists;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyToVocableMapCreator {
    private final List<Vocabulary> vocabularies;
    private final InternalDataRequester requester;
    private Map<String, Vocable> keyToVocable;

    public KeyToVocableMapCreator(List<Vocabulary> list, InternalDataRequester internalDataRequester) {
        this.vocabularies = list;
        this.requester = internalDataRequester;
    }

    public void create() {
        this.keyToVocable = this.buildKeyToVocableMap(this.vocabularies);
    }

    private Map<String, Vocable> buildKeyToVocableMap(List<Vocabulary> list) {
        HashMap<String, Vocable> hashMap = new HashMap<String, Vocable>();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
                String string = internalAdditionalVocableData.getKey();
                if (hashMap.containsKey(string)) {
                    throw new RuntimeException("Der Schl\u00fcssel '" + string + "' kommt mehrfach vor!");
                }
                hashMap.put(string, vocable);
            }
        }
        return hashMap;
    }

    public Map<String, Vocable> getKeyToVocable() {
        return this.keyToVocable;
    }
}

