/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.wrongtested;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.io.OwnListReader;
import de.duehl.vocabulary.japanese.io.OwnListWriter;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WrongTestedVocables {
    public static final String WRONG_TESTED_VOCABLE_LISTS_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "wrong_tested_vocable_lists");
    private static final String WRONG_TESTED_VOCABLE_GROUP_LIST_NAME = "Falsch \u00fcbersetzt - Gruppen";
    private static final String WRONG_TESTED_VOCABLE_OTHER_LIST_NAME = "Falsch \u00fcbersetzt - Andere";
    private final List<Vocabulary> vocabularies;
    private final Map<String, Vocable> keyToVocable;
    private final InternalDataRequester requester;
    private OwnList wrongTestedGroupVocables;
    private OwnList wrongTestedOtherVocables;

    public WrongTestedVocables(List<Vocabulary> list, Map<String, Vocable> map, InternalDataRequester internalDataRequester) {
        this.vocabularies = list;
        this.keyToVocable = map;
        this.requester = internalDataRequester;
        this.load();
    }

    private void load() {
        FileHelper.createDirectoryIfNotExists(WRONG_TESTED_VOCABLE_LISTS_DIRECTORY);
        this.wrongTestedGroupVocables = this.loadViaName(WRONG_TESTED_VOCABLE_GROUP_LIST_NAME);
        this.wrongTestedOtherVocables = this.loadViaName(WRONG_TESTED_VOCABLE_OTHER_LIST_NAME);
    }

    private OwnList loadViaName(String string) {
        String string2 = this.createFilenameFromName(string);
        if (FileHelper.exists(string2)) {
            return this.readExistingList(string, string2);
        }
        return this.createAndStoreNewList(string, string2);
    }

    private String createFilenameFromName(String string) {
        String string2 = Text.createJavaVariableName(string) + ".owl";
        String string3 = FileHelper.concatPathes(WRONG_TESTED_VOCABLE_LISTS_DIRECTORY, string2);
        return string3;
    }

    private OwnList readExistingList(String string, String string2) {
        OwnListReader ownListReader = new OwnListReader(string, this.keyToVocable);
        ownListReader.useSpecialFilenameForWrongTestedVocables(string2);
        ownListReader.read();
        return ownListReader.getOwnList();
    }

    private OwnList createAndStoreNewList(String string, String string2) {
        OwnList ownList = new OwnList(string, "Default", "Default", new ArrayList<Vocable>());
        this.storeList(ownList, string2);
        return ownList;
    }

    private void storeList(OwnList ownList, String string) {
        OwnListWriter ownListWriter = new OwnListWriter(ownList, this.requester);
        ownListWriter.useSpecialFilenameForWrongTestedVocables(string);
        ownListWriter.write();
    }

    public void addVocableToWrongTestedVocablesList(Vocable vocable) {
        OwnList ownList;
        String string;
        if (this.isFromGroup(vocable)) {
            string = WRONG_TESTED_VOCABLE_GROUP_LIST_NAME;
            ownList = this.wrongTestedGroupVocables;
        } else {
            string = WRONG_TESTED_VOCABLE_OTHER_LIST_NAME;
            ownList = this.wrongTestedOtherVocables;
        }
        List<Vocable> list = ownList.getVocables();
        if (!list.contains(vocable)) {
            list.add(vocable);
        }
        String string2 = this.createFilenameFromName(string);
        this.storeList(ownList, string2);
    }

    public void removeVocableFromWrongTestedVocablesList(Vocable vocable) {
        OwnList ownList;
        String string;
        if (this.isFromGroup(vocable)) {
            string = WRONG_TESTED_VOCABLE_GROUP_LIST_NAME;
            ownList = this.wrongTestedGroupVocables;
        } else {
            string = WRONG_TESTED_VOCABLE_OTHER_LIST_NAME;
            ownList = this.wrongTestedOtherVocables;
        }
        List<Vocable> list = ownList.getVocables();
        list.remove(vocable);
        String string2 = this.createFilenameFromName(string);
        this.storeList(ownList, string2);
    }

    private boolean isFromGroup(Vocable vocable) {
        Vocabulary vocabulary = this.determineVocabularyWithVocable(vocable);
        String string = vocabulary.getSubCategory();
        return string.contains(" Groups");
    }

    private Vocabulary determineVocabularyWithVocable(Vocable vocable) {
        for (Vocabulary vocabulary : this.vocabularies) {
            if (!vocabulary.getVocables().contains(vocable)) continue;
            return vocabulary;
        }
        throw new RuntimeException("Die Vokabel " + vocable + " wurde in keinem Vokabular gefunden.");
    }

    public OwnList getWrongTestedGroupVocables() {
        return this.wrongTestedGroupVocables;
    }

    public OwnList getWrongTestedOtherVocables() {
        return this.wrongTestedOtherVocables;
    }
}

