/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.statistics;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.html.generation.SwingHtmlBuilder;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.success.VocabularyTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.statistics.data.KanjiKriterium;
import de.duehl.vocabulary.japanese.statistics.data.KanjiWithCounter;
import de.duehl.vocabulary.japanese.statistics.data.VocableCounterPicker;
import de.duehl.vocabulary.japanese.statistics.data.VocableListPicker;
import de.duehl.vocabulary.japanese.statistics.data.VocableWithCounter;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.text.KanjiAndKanaTextCreator;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VocabularyTrainerStatisticCreator {
    private final FumikoDataStructures dataStructures;
    private List<String> categories;
    private List<String> subCategories;
    private Map<String, List<Vocabulary>> vocabulariesByCategory;
    private SwingHtmlBuilder html;
    private final List<Vocable> allVocables;
    private static final int NUMBER_OF_OFTEN_TESTED_VOCABLES = 20;

    public VocabularyTrainerStatisticCreator(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.dataStructures = fumikoDataStructures;
        this.allVocables = this.getAllVocablesOfAllVocabularies();
    }

    private List<Vocable> getAllVocablesOfAllVocabularies() {
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        return this.getAllVocablesOfAllVocabularies(list);
    }

    private List<Vocable> getAllVocablesOfAllVocabularies(List<Vocabulary> list) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : list) {
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    public String createStatisticReport() {
        this.createStatisticsInternal();
        return this.html.toString();
    }

    private void createStatisticsInternal() {
        this.initHtml();
        this.determineCategories();
        this.determineSubCategories();
        this.separateVocabulariesByCategory();
        this.createStatisticForAllVocables();
        this.createStatisticForAllCategories();
        this.createStatisticForAllCategoriesAndSubCategories();
        this.createStatisticForSearchWords();
        this.createStatisticForPartsOfSpeach();
        this.createStatisticForMostTestedEtc();
        this.createKanjiStatistic();
        this.finalizeHtml();
    }

    private void initHtml() {
        this.html = new SwingHtmlBuilder().appendHtml5HeadWithOwnExtendedCssUtf8("Statstik", "h2, h3 {\n    margin-bottom:12;\n    margin-top:25;\n}".indent(4)).appendTopLinksToH2();
        this.html.appendP("&nbsp;");
        this.html.appendH1("Statistik");
    }

    private void determineCategories() {
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        this.categories = VocabularyTools.determineCategories(list);
    }

    private void determineSubCategories() {
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        this.subCategories = VocabularyTools.determineSubCategories(list);
    }

    private void separateVocabulariesByCategory() {
        this.vocabulariesByCategory = new HashMap<String, List<Vocabulary>>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            String string = vocabulary.getCategory();
            if (!this.vocabulariesByCategory.containsKey(string)) {
                this.vocabulariesByCategory.put(string, new ArrayList());
            }
            List<Vocabulary> list2 = this.vocabulariesByCategory.get(string);
            list2.add(vocabulary);
        }
    }

    private void createStatisticForAllVocables() {
        this.html.appendH2("Alle Vokabeln");
        String string = NumberString.taupu(this.categories.size());
        String string2 = NumberString.taupu(this.subCategories.size());
        String string3 = NumberString.taupu(this.allVocables.size());
        String string4 = this.calculatePercent(this.allVocables);
        String string5 = this.calculateNumberOfTenTimesCorrectVocables(TranslationDirection.JAPANESE_TO_GERMAN);
        String string6 = this.calculateNumberOfTenTimesCorrectVocables(TranslationDirection.GERMAN_TO_JAPANESE);
        String string7 = this.calculateNumberOfPhrases();
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Kategorien");
        this.html.appendRightAlignedTd(string);
        this.html.appendClosingTr();
        this.html.appendLeftAlignedTh("Anzahl Unterkategorien");
        this.html.appendRightAlignedTd(string2);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTd(string3);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Davon Phrasen");
        this.html.appendRightAlignedTd(string7);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Prozent Erfolg der letzten Abfragen aller Vokabeln");
        this.html.appendRightAlignedTd(string4);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl mindestens 10 Mal richtig \u00fcbersetzter Vokabeln (Japanisch - Deutsch)");
        this.html.appendRightAlignedTd(string5);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl mindestens 10 Mal richtig \u00fcbersetzter Vokabeln (Deutsch - Japanisch)");
        this.html.appendRightAlignedTd(string6);
        this.html.appendClosingTr();
        this.html.appendClosingTable();
        this.html.appendH3("\u00dcbersicht \u00fcber die Kategorien");
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Kategorie");
        this.html.appendRightAlignedTh("Anzahl Vokabulare");
        this.html.appendRightAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
        this.html.appendClosingTr();
        for (String string8 : this.categories) {
            this.createStatisticRowForCategory(string8);
        }
        this.html.appendClosingTable();
    }

    private String calculateNumberOfTenTimesCorrectVocables(TranslationDirection translationDirection) {
        int n = 0;
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        for (Vocable vocable : this.allVocables) {
            int n2;
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
                n2 = internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
            } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
                n2 = internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
            } else {
                throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection + ".");
            }
            if (n2 < 10) continue;
            ++n;
        }
        return NumberString.taupu(n);
    }

    private String calculateNumberOfPhrases() {
        int n = 0;
        for (Vocable vocable : this.allVocables) {
            if (!vocable.getPartsOfSpeech().contains("Phrase")) continue;
            ++n;
        }
        return NumberString.taupu(n);
    }

    private void createStatisticRowForCategory(String string) {
        List<Vocabulary> list = this.vocabulariesByCategory.get(string);
        List<Vocable> list2 = this.getAllVocablesOfAllVocabularies(list);
        String string2 = NumberString.taupu(list.size());
        String string3 = NumberString.taupu(list2.size());
        String string4 = this.calculatePercent(list2);
        this.html.appendOpeningTr();
        this.html.appendTd(string);
        this.html.appendRightAlignedTd(string2);
        this.html.appendRightAlignedTd(string3);
        this.html.appendRightAlignedTd(string4);
        this.html.appendClosingTr();
    }

    private String calculatePercent(List<Vocable> list) {
        VocabularyTestSuccesssCalculator vocabularyTestSuccesssCalculator = new VocabularyTestSuccesssCalculator(list, this.dataStructures);
        vocabularyTestSuccesssCalculator.calculate();
        return vocabularyTestSuccesssCalculator.getPercentTextWithTwoDigitsAfterComma();
    }

    private void createStatisticForAllCategories() {
        for (String string : this.categories) {
            this.createStatisticForCategory(string);
        }
    }

    private void createStatisticForCategory(String string) {
        this.html.appendH2("Kategorie " + string);
        List<Vocabulary> list = this.vocabulariesByCategory.get(string);
        List<Vocable> list2 = this.getAllVocablesOfAllVocabularies(list);
        String string2 = NumberString.taupu(list.size());
        String string3 = NumberString.taupu(list2.size());
        String string4 = this.calculatePercent(list2);
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Vokabulare");
        this.html.appendRightAlignedTd(string2);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTd(string3);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
        this.html.appendRightAlignedTd(string4);
        this.html.appendClosingTr();
        this.html.appendClosingTable();
        this.html.appendH3("Vokabulare");
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Vokabular");
        this.html.appendRightAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
        this.html.appendClosingTr();
        for (Vocabulary vocabulary : list) {
            this.createStatisticRowForVocabulary(vocabulary);
        }
        this.html.appendClosingTable();
    }

    private void createStatisticRowForVocabulary(Vocabulary vocabulary) {
        List<Vocable> list = vocabulary.getVocables();
        String string = NumberString.taupu(list.size());
        String string2 = this.calculatePercent(list);
        this.html.appendOpeningTr();
        this.html.appendTd(vocabulary.getDescription());
        this.html.appendRightAlignedTd(string);
        this.html.appendRightAlignedTd(string2);
        this.html.appendClosingTr();
    }

    private void createStatisticForAllCategoriesAndSubCategories() {
        for (String string : this.categories) {
            this.createStatisticForCategoryAndAllSubCategories(string);
        }
    }

    private void createStatisticForCategoryAndAllSubCategories(String string) {
        this.html.appendH2("Kategorie " + string + " mit Betrachtung der Unterkategorien");
        List<Vocabulary> list = this.vocabulariesByCategory.get(string);
        List<String> list2 = VocabularyTools.determineSubCategoriesOfCategory(list, string);
        for (String string2 : list2) {
            this.html.appendH3("Unterkategorie " + string2);
            List<Vocabulary> list3 = this.determineVocabulariesOfCategoryAndSubCategory(string, string2);
            List<Vocable> list4 = this.getAllVocablesOfAllVocabularies(list3);
            String string3 = NumberString.taupu(list.size());
            String string4 = NumberString.taupu(list4.size());
            String string5 = this.calculatePercent(list4);
            this.html.appendOpeningTableWithBorderWidth(2);
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Anzahl Vokabulare");
            this.html.appendRightAlignedTd(string3);
            this.html.appendClosingTr();
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Anzahl Vokabeln");
            this.html.appendRightAlignedTd(string4);
            this.html.appendClosingTr();
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
            this.html.appendRightAlignedTd(string5);
            this.html.appendClosingTr();
            this.html.appendClosingTable();
            this.html.appendH4("Vokabulare");
            this.html.appendOpeningTableWithBorderWidth(2);
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Vokabular");
            this.html.appendRightAlignedTh("Anzahl Vokabeln");
            this.html.appendRightAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
            this.html.appendClosingTr();
            for (Vocabulary vocabulary : list) {
                this.createStatisticRowForVocabulary(vocabulary);
            }
            this.html.appendClosingTable();
        }
    }

    private List<Vocabulary> determineVocabulariesOfCategoryAndSubCategory(String string, String string2) {
        ArrayList<Vocabulary> arrayList = new ArrayList<Vocabulary>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            String string3 = vocabulary.getCategory();
            String string4 = vocabulary.getSubCategory();
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            arrayList.add(vocabulary);
        }
        return arrayList;
    }

    private void createStatisticForSearchWords() {
        this.html.appendH2("Suchbegriffe");
        Map<String, Integer> map = this.createCountByWordMap(vocable -> vocable.getSearchWords());
        int n = this.countMissing(vocable -> vocable.getSearchWords());
        this.createCountByWordHtml("Suchbegriff", map, n);
    }

    private void createStatisticForPartsOfSpeach() {
        this.html.appendH2("Wortarten");
        Map<String, Integer> map = this.createCountByWordMap(vocable -> vocable.getPartsOfSpeech());
        int n = this.countMissing(vocable -> vocable.getPartsOfSpeech());
        this.createCountByWordHtml("Wortart", map, n);
    }

    private Map<String, Integer> createCountByWordMap(VocableListPicker vocableListPicker) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Vocable vocable : this.allVocables) {
            List<String> list = vocableListPicker.pickWordList(vocable);
            for (String string : list) {
                if (string.isBlank()) continue;
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, 0);
                }
                int n = (Integer)hashMap.get(string);
                hashMap.put(string, ++n);
            }
        }
        return hashMap;
    }

    private int countMissing(VocableListPicker vocableListPicker) {
        int n = 0;
        for (Vocable vocable : this.allVocables) {
            List<String> list = vocableListPicker.pickWordList(vocable);
            if (!list.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    private void createCountByWordHtml(String string, Map<String, Integer> map, int n) {
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh(string);
        this.html.appendRightAlignedTd("Anzahl");
        this.html.appendClosingTr();
        for (String string2 : CollectionsHelper.getSortedMapStringIndices(map)) {
            this.html.appendOpeningTr();
            this.html.appendTd(string2);
            this.html.appendRightAlignedTd(NumberString.taupu(map.get(string2)));
            this.html.appendClosingTr();
        }
        this.html.appendClosingTable();
        this.html.appendP("Vokabeln ohne " + string + ": " + NumberString.taupu(n) + " (" + NumberString.percent(n, this.allVocables.size()) + "%)");
    }

    private void createStatisticForMostTestedEtc() {
        this.html.appendH2("H\u00e4ufig abgefragte Vokabeln");
        this.createCountTestSum();
        this.createStatisticForOftenUsedVocables(this.determineOftenJapaneseToGermanTestedVocables(), "Am h\u00e4ufigsten abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyJapaneseToGermanTestedVocables(), "Am seltesten abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineOftenCorrectJapaneseToGermanTestedVocables(), "Am h\u00e4ufigsten richtig abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyCorrectJapaneseToGermanTestedVocables(), "Am seltensten richtig abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineOftenWrongJapaneseToGermanTestedVocables(), "Am h\u00e4ufigsten falsch abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyWrongJapaneseToGermanTestedVocables(), "Am seltensten falsch abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineOftenGermanToJapaneseTestedVocables(), "Am h\u00e4ufigsten abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyGermanToJapaneseTestedVocables(), "Am seltesten abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineOftenCorrectGermanToJapaneseTestedVocables(), "Am h\u00e4ufigsten richtig abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyCorrectGermanToJapaneseTestedVocables(), "Am seltensten richtig abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineOftenWrongGermanToJapaneseTestedVocables(), "Am h\u00e4ufigsten falsch abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyWrongGermanToJapaneseTestedVocables(), "Am seltensten falsch abgefragte Vokabeln Deutsch-Japanisch");
    }

    private void createCountTestSum() {
        int n = 0;
        int n2 = 0;
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        for (Vocable vocable : this.allVocables) {
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            n += internalAdditionalVocableData.getJapaneseToGermanTestCount();
            n2 += internalAdditionalVocableData.getGermanToJapaneseTestCount();
        }
        this.html.appendH3("Wie oft wurden Vokabeln abgefragt");
        this.html.appendP("Es wurde " + NumberString.taupu(n) + " mal eine einzelne Vokabel von Japanisch nach Deutsch abgefragt.");
        this.html.appendP("Es wurde " + NumberString.taupu(n2) + " mal eine einzelne Vokabel von Deutsch nach Japanisch abgefragt.");
        this.html.appendP("Summe: Es wurde " + NumberString.taupu(n + n2) + " mal eine einzelne Vokabel abgefragt.");
    }

    private List<VocableWithCounter> determineOftenJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenJapaneseToGermanTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenJapaneseToGermanTested(vocable));
    }

    private int howOftenJapaneseToGermanTested(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getJapaneseToGermanTestCount();
    }

    private List<VocableWithCounter> determineOftenCorrectJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenCorrectJapaneseToGermanTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyCorrectJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenCorrectJapaneseToGermanTested(vocable));
    }

    private int howOftenCorrectJapaneseToGermanTested(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
    }

    private List<VocableWithCounter> determineOftenWrongJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenWrongJapaneseToGermanTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyWrongJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenWrongJapaneseToGermanTested(vocable));
    }

    private int howOftenWrongJapaneseToGermanTested(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getJapaneseToGermanTestCount() - internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
    }

    private List<VocableWithCounter> determineOftenGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenGermanToJapaneseTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenGermanToJapaneseTested(vocable));
    }

    private int howOftenGermanToJapaneseTested(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getGermanToJapaneseTestCount();
    }

    private List<VocableWithCounter> determineOftenCorrectGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenCorrectGermanToJapaneseTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyCorrectGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenCorrectGermanToJapaneseTested(vocable));
    }

    private int howOftenCorrectGermanToJapaneseTested(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
    }

    private List<VocableWithCounter> determineOftenWrongGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenWrongGermanToJapaneseTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyWrongGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenWrongGermanToJapaneseTested(vocable));
    }

    private int howOftenWrongGermanToJapaneseTested(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getGermanToJapaneseTestCount() - internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
    }

    private List<VocableWithCounter> determineOftenTestedVocablesHighest(VocableCounterPicker vocableCounterPicker) {
        return this.determineOftenTestedVocables(vocableCounterPicker, true);
    }

    private List<VocableWithCounter> determineOftenTestedVocablesLowest(VocableCounterPicker vocableCounterPicker) {
        return this.determineOftenTestedVocables(vocableCounterPicker, false);
    }

    private List<VocableWithCounter> determineOftenTestedVocables(VocableCounterPicker vocableCounterPicker, final boolean bl) {
        ArrayList<VocableWithCounter> arrayList = new ArrayList<VocableWithCounter>();
        for (Vocable vocable : this.allVocables) {
            int n = vocableCounterPicker.pickCounter(vocable);
            VocableWithCounter vocableWithCounter = new VocableWithCounter(vocable, n);
            arrayList.add(vocableWithCounter);
        }
        Collections.sort(arrayList, new Comparator<VocableWithCounter>(){

            @Override
            public int compare(VocableWithCounter vocableWithCounter, VocableWithCounter vocableWithCounter2) {
                int n = vocableWithCounter.getCount();
                int n2 = vocableWithCounter2.getCount();
                if (bl) {
                    return n2 - n;
                }
                return n - n2;
            }
        });
        int n = Math.min(20, arrayList.size());
        arrayList = CollectionsHelper.sublist(arrayList, 0, n);
        return arrayList;
    }

    private void createStatisticForOftenUsedVocables(List<VocableWithCounter> list, String string) {
        this.html.appendH3(string);
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Vokabel");
        this.html.appendRightAlignedTh("Anzahl");
        this.html.appendClosingTr();
        for (VocableWithCounter vocableWithCounter : list) {
            Vocable vocable = vocableWithCounter.getVocable();
            int n = vocableWithCounter.getCount();
            String string2 = this.createVocableText(vocable);
            this.html.appendOpeningTr();
            this.html.appendTd(string2);
            this.html.appendRightAlignedTd(NumberString.taupu(n));
            this.html.appendClosingTr();
        }
        this.html.appendClosingTable();
    }

    private String createVocableText(Vocable vocable) {
        String string = vocable.getRomaji();
        String string2 = vocable.getTranslations().get(0);
        boolean bl = true;
        boolean bl2 = true;
        KanjiAndKanaTextCreator kanjiAndKanaTextCreator = new KanjiAndKanaTextCreator(vocable, bl, bl2);
        kanjiAndKanaTextCreator.create();
        String string3 = kanjiAndKanaTextCreator.getFirstTextPart();
        String string4 = kanjiAndKanaTextCreator.getTextPartInBrace();
        boolean bl3 = kanjiAndKanaTextCreator.isBraceInOwnLine();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        if (bl3) {
            stringBuilder.append("<br>");
        }
        if (!string4.isBlank()) {
            stringBuilder.append(" (");
            stringBuilder.append(string4);
            stringBuilder.append(")");
        }
        if (bl3) {
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append(" - ");
        }
        stringBuilder.append(string);
        if (bl3) {
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append(" - ");
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void createKanjiStatistic() {
        List<Kanji> list = Kanji.getAllKanjiAsList();
        this.html.appendH2("Kanji");
        this.createKanjiTestsOverview(list);
        this.createLastTenKanjiTestsStatistic(list);
        this.createStatisticForKanji(this.determineKanjiWithKriteriumHighestValue(list, 10, kanji -> this.getTestCount(kanji)), "Die am h\u00e4ufigsten abgefragten Kanji");
        this.createStatisticForKanji(this.determineKanjiWithKriteriumHighestValue(list, 10, kanji -> this.getCorrectTestCount(kanji)), "Die am h\u00e4ufigsten richtig abgefragten Kanji");
        this.createStatisticForKanji(this.determineKanjiWithKriteriumLowestValue(list, 10, kanji -> this.lastTenCorrectTestedCount(kanji)), "Die die letzten zehn Male am schlechtesten abgefragten Kanji");
        this.createStatisticForKanji(this.determineKanjiWithKriteriumHighestValue(list, 10, kanji -> this.getRatioCorrectAgainstTestCount(kanji), true), "Kanji mit dem besten Verh\u00e4ltnis von Anzahl richtig zu Anzahl abgefragt");
        this.createStatisticForKanji(this.determineKanjiWithKriteriumLowestValue(list, 10, kanji -> this.getRatioCorrectAgainstTestCount(kanji), true), "Kanji mit dem schlechtesten Verh\u00e4ltnis von Anzahl richtig zu Anzahl abgefragt");
    }

    private void createKanjiTestsOverview(List<Kanji> list) {
        this.html.appendP("Es gibt im Vokabeltrainer " + NumberString.taupu(list.size()) + " Kanji.");
        int n = 0;
        int n2 = 0;
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        for (Kanji kanji : list) {
            InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
            n += internalAdditionalKanjiData.getTestCount();
            n2 += internalAdditionalKanjiData.getCorrectTestCount();
        }
        this.html.appendP("Insgesamt waren es " + NumberString.taupu(n) + " Abfragen von Kanji.");
        this.html.appendP("Dabei gab es " + NumberString.taupu(n2) + " richtig beantwortete Abfragen von Kanji (" + NumberString.percent(n2, n) + " Prozent aller Abfragen war richtig).");
    }

    private void createLastTenKanjiTestsStatistic(List<Kanji> list) {
        this.html.appendH3("Erfolg in den letzten zehn Abfragen");
        int n = 0;
        int n2 = 0;
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        for (Kanji kanji : list) {
            InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
            n += internalAdditionalKanjiData.getLastTenTestsCount();
            n2 += internalAdditionalKanjiData.getLastCorrectTestsCount();
        }
        this.html.appendP(NumberString.percent(n2, n) + " Prozent aller letzten zehn Abfragen war richtig.");
    }

    private int getTestCount(Kanji kanji) {
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
        return internalAdditionalKanjiData.getTestCount();
    }

    private int getCorrectTestCount(Kanji kanji) {
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
        return internalAdditionalKanjiData.getCorrectTestCount();
    }

    private int lastTenCorrectTestedCount(Kanji kanji) {
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
        return internalAdditionalKanjiData.getLastCorrectTestsCount();
    }

    private double getRatioCorrectAgainstTestCount(Kanji kanji) {
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
        double d = internalAdditionalKanjiData.getCorrectTestCount();
        double d2 = internalAdditionalKanjiData.getTestCount();
        return d / d2;
    }

    private List<KanjiWithCounter> determineKanjiWithKriteriumHighestValue(List<Kanji> list, int n, KanjiKriterium kanjiKriterium) {
        boolean bl = true;
        boolean bl2 = false;
        return this.determineKanjiWithKriteriumHighestValue(list, n, kanjiKriterium, bl, bl2);
    }

    private List<KanjiWithCounter> determineKanjiWithKriteriumLowestValue(List<Kanji> list, int n, KanjiKriterium kanjiKriterium) {
        boolean bl = false;
        boolean bl2 = false;
        return this.determineKanjiWithKriteriumHighestValue(list, n, kanjiKriterium, bl, bl2);
    }

    private List<KanjiWithCounter> determineKanjiWithKriteriumHighestValue(List<Kanji> list, int n, KanjiKriterium kanjiKriterium, boolean bl) {
        boolean bl2 = true;
        return this.determineKanjiWithKriteriumHighestValue(list, n, kanjiKriterium, bl2, bl);
    }

    private List<KanjiWithCounter> determineKanjiWithKriteriumLowestValue(List<Kanji> list, int n, KanjiKriterium kanjiKriterium, boolean bl) {
        boolean bl2 = false;
        return this.determineKanjiWithKriteriumHighestValue(list, n, kanjiKriterium, bl2, bl);
    }

    private List<KanjiWithCounter> determineKanjiWithKriteriumHighestValue(List<Kanji> list, int n, final KanjiKriterium kanjiKriterium, final boolean bl, boolean bl2) {
        List<Kanji> list2 = CollectionsHelper.copyList(list);
        Collections.sort(list2, new Comparator<Kanji>(){

            @Override
            public int compare(Kanji kanji, Kanji kanji2) {
                double d = kanjiKriterium.createKanjiKriterium(kanji);
                double d2 = kanjiKriterium.createKanjiKriterium(kanji2);
                if (d2 > d) {
                    if (bl) {
                        return 1;
                    }
                    return -1;
                }
                if (d > d2) {
                    if (bl) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
        int n2 = Math.min(list2.size(), n);
        ArrayList<KanjiWithCounter> arrayList = new ArrayList<KanjiWithCounter>();
        for (int i = 0; i < n2; ++i) {
            Kanji kanji = list2.get(i);
            double d = kanjiKriterium.createKanjiKriterium(kanji);
            KanjiWithCounter kanjiWithCounter = new KanjiWithCounter(kanji, d, bl2);
            arrayList.add(kanjiWithCounter);
        }
        return arrayList;
    }

    private void createStatisticForKanji(List<KanjiWithCounter> list, String string) {
        this.html.appendH3(string);
        this.html.appendOpeningTableWithBorderWidth(2);
        String string2 = list.get(0).isWantsDouble() ? "Prozent" : "Anzahl";
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Kanji");
        this.html.appendRightAlignedTh(string2);
        this.html.appendClosingTr();
        for (KanjiWithCounter kanjiWithCounter : list) {
            String string3;
            Kanji kanji = kanjiWithCounter.getKanji();
            double d = kanjiWithCounter.getCount();
            if (kanjiWithCounter.isWantsDouble()) {
                string3 = NumberString.twoDecimalPlaces(100.0 * d);
            } else {
                int n = (int)d;
                string3 = NumberString.taupu(n);
            }
            String string4 = "<span style=\"font-size: 2.5em;\">" + kanji.getCharacter() + "</span>";
            this.html.appendOpeningTr();
            this.html.appendTd(string4);
            this.html.appendRightAlignedTd(string3);
            this.html.appendClosingTr();
        }
        this.html.appendClosingTable();
    }

    private void finalizeHtml() {
        this.html.appendFoot();
        this.html.insertContentWithTopLinkAnker();
    }
}

