/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.tools;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.data.VocablesSubsetSelectionType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import java.util.Collections;
import java.util.List;

public class VocableSubsetCreator {
    private final FumikoDataStructures dataStructures;
    private final List<Vocable> allVocables;
    private final VocablesSubsetSelectionType type;
    private final int numberOfWantedVocables;
    private final int numberOfWantedVocablesTwice;
    private List<Vocable> subset;

    public VocableSubsetCreator(List<Vocable> list, int n, FumikoDataStructures fumikoDataStructures) {
        this.allVocables = CollectionsHelper.copyList(list);
        Options options = fumikoDataStructures.getOptions();
        this.type = options.getVocablesSubsetSelectionType();
        this.numberOfWantedVocables = Math.min(n, list.size());
        this.numberOfWantedVocablesTwice = Math.min(n * 2, list.size());
        this.dataStructures = fumikoDataStructures;
    }

    public void create() {
        switch (this.type) {
            case PURE_RANDOM: {
                this.createPureRandomSubset();
                break;
            }
            case RANDOM_AND_LAST_ANSWER_SUCCESS: {
                this.createRandomAndLastAnswerSuccessSubset();
                break;
            }
            case RANDOM_AND_FIRST_SEEN_DATE: {
                this.createRandomAndFirstSeenSubset();
                break;
            }
            case RANDOM_AND_LAST_CORRECT_TEST_DATE: {
                this.createRandomAndLastCorrectTestDateSubset();
                break;
            }
            case RANDOM_AND_MIX: {
                this.createRandomAndMixSubset();
                break;
            }
            default: {
                this.createUnknown();
            }
        }
    }

    private void createPureRandomSubset() {
        Collections.shuffle(this.allVocables);
        this.subset = CollectionsHelper.sublist(this.allVocables, 0, this.numberOfWantedVocables);
    }

    private void createRandomAndLastAnswerSuccessSubset() {
        this.create(VocablesShuffleType.LAST_ANSWERS_SUCCESS);
    }

    private void createRandomAndFirstSeenSubset() {
        this.create(VocablesShuffleType.FIRST_SEEN_DATE);
    }

    private void createRandomAndLastCorrectTestDateSubset() {
        this.create(VocablesShuffleType.LAST_CORRECT_TEST_DATE);
    }

    private void createRandomAndMixSubset() {
        this.create(VocablesShuffleType.MIX);
    }

    private void create(VocablesShuffleType vocablesShuffleType) {
        this.presortAllVocables(vocablesShuffleType);
        this.createSubsetFromPresortedAllVocables();
    }

    private void presortAllVocables(VocablesShuffleType vocablesShuffleType) {
        VocableListShuffler vocableListShuffler = new VocableListShuffler(this.allVocables, vocablesShuffleType, this.dataStructures);
        vocableListShuffler.shuffle();
        this.allVocables.clear();
        this.allVocables.addAll(vocableListShuffler.getVocables());
    }

    private void createSubsetFromPresortedAllVocables() {
        this.subset = CollectionsHelper.sublist(this.allVocables, 0, this.numberOfWantedVocablesTwice);
        Collections.shuffle(this.subset);
        this.subset = CollectionsHelper.sublist(this.subset, 0, this.numberOfWantedVocables);
    }

    private void createUnknown() {
        GuiTools.informUser("Unbekannte Art eine Teilmenge zu erezugen", "Die Art '" + this.type + "' die Teilmenge zu erezugen ist unbekannt.\n\nDaher wird die Teilmenge rein zuf\u00e4llig ermittelt.");
        this.createPureRandomSubset();
    }

    public List<Vocable> getSubset() {
        return this.subset;
    }
}

