/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.tools;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.mp3.player.MP3Player;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.ownlists.groups.OwnListGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VocabularyTools {
    private static final String NAME_START_REGEX = VocabularyTools.createNameStartRegex();
    private static final Pattern DESCRIPTIONS_START_PATTERN = Pattern.compile("^(?:[A-Z]+\\d+[_ ][A-Z]\\d+[_ ]\\d+|VHS[_ ][A-Z]\\d\\.\\d[_ ]\\d+[_ ]\\d+|" + NAME_START_REGEX + ")[_ ]");
    private static final Pattern DESCRIPTIONS_START_PATTERN_VHS = Pattern.compile("^(?:VHS[_ ][A-Z]\\d\\.\\d)[_ ]");

    public static String vocabularyFilenameToDescription(String string) {
        String string2 = FileHelper.getBareName(string);
        String string3 = FileHelper.removeExtension(string2);
        String string4 = string3.replace("_", " ");
        if (string4.startsWith("Vokabeln ")) {
            string4 = string4.substring("Vokabeln ".length());
        }
        return string4;
    }

    public static void printVocabularies(List<Vocabulary> list) {
        System.out.println("Liste der Vokabulare:");
        System.out.println();
        for (Vocabulary vocabulary : list) {
            System.out.println(vocabulary.toNiceString());
            System.out.println();
        }
    }

    public static String createVocableKey(Vocable vocable) {
        String string = vocable.getKana();
        String string2 = vocable.getTranslations().get(0);
        Object object = string + string2;
        object = ((String)object).replace(" ", "_");
        object = ((String)object).replace("?", "_");
        object = ((String)object).replace(":", "#DOPPELPUNKT#");
        object = ((String)object).replace("/", "_");
        object = ((String)object).replace("\\", "_");
        object = ((String)object).replace("\"", "_");
        object = ((String)object).replace("'", "_");
        return object;
    }

    public static void playMp3(String string) {
        if (!string.isBlank() && FileHelper.isFile(string)) {
            MP3Player mP3Player = new MP3Player();
            mP3Player.playMP3InOwnThread(string);
        }
    }

    public static String createCompareTranslation(String string) {
        String string2 = string;
        string2 = Text.toLowerCase(string2);
        string2 = VocabularyTools.removePuncuationMarks(string2);
        return string2;
    }

    public static String removePuncuationMarks(String string) {
        String string2 = string;
        string2 = string2.replace("?", "");
        string2 = string2.replace("!", "");
        string2 = string2.replace(" ", "");
        string2 = string2.replace(",", "");
        string2 = string2.replace(".", "");
        string2 = string2.replace("'", "");
        string2 = string2.replace("\"", "");
        string2 = string2.replace("\\", "");
        string2 = string2.replace("/", "");
        string2 = string2.replace("#", "");
        string2 = string2.replace("+", "");
        string2 = string2.replace("-", "");
        string2 = string2.replace(";", "");
        return string2;
    }

    public static String hideStartOfVocabularyDescription(String string, boolean bl) {
        if (bl && string.contains("VHS")) {
            return VocabularyTools.hideLessStartOfVocabularyDescriptionForVhs(string);
        }
        return VocabularyTools.hideStartOfVocabularyDescriptionStandard(string);
    }

    static String createNameStartRegex() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OwnListGroup ownListGroup : OwnListGroup.values()) {
            String string = ownListGroup.getNameStart();
            string = string.strip();
            string = string.replace(" ", "[_ ]");
            arrayList.add(string);
        }
        return Text.joinWithPipe(arrayList);
    }

    static String hideStartOfVocabularyDescriptionStandard(String string) {
        Matcher matcher = DESCRIPTIONS_START_PATTERN.matcher(string);
        if (matcher.find()) {
            return string.substring(matcher.group().length());
        }
        return string;
    }

    static String hideLessStartOfVocabularyDescriptionForVhs(String string) {
        Matcher matcher = DESCRIPTIONS_START_PATTERN_VHS.matcher(string);
        if (matcher.find()) {
            return string.substring(matcher.group().length());
        }
        return string;
    }

    public static List<String> determineCategories(List<? extends Vocabulary> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : list) {
            String string = vocabulary.getCategory();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<String> determineSubCategories(List<? extends Vocabulary> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : list) {
            String string = vocabulary.getSubCategory();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<String> determineSubCategoriesOfCategory(List<? extends Vocabulary> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : list) {
            String string2;
            String string3 = vocabulary.getCategory();
            if (!string3.equals(string) || arrayList.contains(string2 = vocabulary.getSubCategory())) continue;
            arrayList.add(string2);
        }
        Collections.sort(arrayList);
        return arrayList;
    }
}

