/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.bars;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.additional.LocationGetter;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.KanjiSetBarsRefresher;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.KanjiSetEditor;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.table.KanjiTableDialog;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KanjiSetBar {
    private final KanjiSet kanjiSet;
    private final KanjiSetBarsRefresher kanjiSetBarsRefresher;
    private final VocabularyTrainerLogic logic;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final LocationGetter locationGetter;
    private final List<String> notAllowedNames;
    private final JPanel panel;

    public KanjiSetBar(KanjiSet kanjiSet, List<String> list, KanjiSetBarsRefresher kanjiSetBarsRefresher, VocabularyTrainerLogic vocabularyTrainerLogic, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, LocationGetter locationGetter) {
        this.kanjiSet = kanjiSet;
        this.kanjiSetBarsRefresher = kanjiSetBarsRefresher;
        this.logic = vocabularyTrainerLogic;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.locationGetter = locationGetter;
        this.notAllowedNames = new ArrayList<String>();
        for (String string : list) {
            if (string.equals(kanjiSet.getName())) continue;
            this.notAllowedNames.add(string);
        }
        this.panel = new JPanel();
        this.createBarUi();
    }

    private void createBarUi() {
        this.panel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.panel);
        this.panel.add(this.createNameAndGroupPart(), "Center");
        this.panel.add(this.createButtonsPart(), "East");
    }

    private Component createNameAndGroupPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createNameLabel(), "Center");
        jPanel.add(this.createGroupLabel(), "South");
        return jPanel;
    }

    private Component createNameLabel() {
        JLabel jLabel = new JLabel(this.kanjiSet.getName());
        GuiTools.biggerFont(jLabel, 10);
        return jLabel;
    }

    private Component createGroupLabel() {
        JLabel jLabel = new JLabel("Gruppe '" + this.kanjiSet.getGroup() + "'");
        GuiTools.biggerFont(jLabel, -1);
        GuiTools.italicFont(jLabel);
        jLabel.setForeground(Color.BLUE);
        return jLabel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createViewAsListButon());
        jPanel.add(this.createEditButon());
        jPanel.add(this.createDeleteButon());
        return jPanel;
    }

    private Component createViewAsListButon() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("SHOW_VOCABULARY_LIST", actionEvent -> this.viewKanjiSetAsKanjiList(), "Vokabeln anzeigen");
        if (this.kanjiSet.getSet().isEmpty()) {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void viewKanjiSetAsKanjiList() {
        String string = "Alle Kanji aus der Menge '" + this.kanjiSet.getName() + "'";
        KanjiTableDialog kanjiTableDialog = new KanjiTableDialog(this.kanjiSet.getSet(), this.dataStructures, this.uiObjects, this.uiObjects.getInformer(), string, this.locationGetter.getLocation());
        kanjiTableDialog.setVisible(true);
    }

    private Component createEditButon() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("EDIT_OWN_LIST", actionEvent -> this.edit(), "Kanji-Menge bearbeiten");
        return jButton;
    }

    private void edit() {
        KanjiSetEditor kanjiSetEditor = new KanjiSetEditor(this.kanjiSet, this.notAllowedNames, this.logic, this.dataStructures, this.uiObjects, this.locationGetter.getLocation());
        kanjiSetEditor.setVisible(true);
        this.kanjiSetBarsRefresher.refreshKanjiSetBars();
    }

    private Component createDeleteButon() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("DELETE_OWN_LIST", actionEvent -> this.delete(), "Kanji-Menge l\u00f6schen");
        jButton.setForeground(Color.RED);
        return jButton;
    }

    private void delete() {
        String string = "Wirklich l\u00f6schen?";
        String string2 = this.kanjiSet.getName();
        String string3 = "Soll die Kanji-Menge '" + string2 + "' wirklich gel\u00f6scht werden?";
        boolean bl = GuiTools.askUser(this.panel, string, string3);
        if (bl) {
            this.kanjiSetBarsRefresher.deleteKanjiSetFromListAndFileFromDisk(this.kanjiSet);
            this.kanjiSetBarsRefresher.refreshKanjiSetBars();
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

