/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.text;

import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.Vocable;

public class KanjiAndKanaTextCreator {
    private static final int CHARACTERS_PER_LINE = 15;
    private final Vocable vocable;
    private final boolean showKana;
    private final boolean showKanji;
    private String firstTextPart;
    private String textPartInBrace;
    private boolean braceInOwnLine;

    public KanjiAndKanaTextCreator(Vocable vocable, boolean bl, boolean bl2) {
        this.vocable = vocable;
        this.showKana = bl;
        this.showKanji = bl2;
    }

    public void create() {
        this.initializeTexts();
        this.breakLongTexts();
    }

    private void initializeTexts() {
        this.firstTextPart = this.vocable.getKanji();
        this.textPartInBrace = this.vocable.getKana();
        if (!this.showKana) {
            this.textPartInBrace = "";
        }
        if (this.firstTextPart.isBlank() || !this.showKanji) {
            this.firstTextPart = this.textPartInBrace;
            this.textPartInBrace = "";
        } else if (this.firstTextPart.equals(this.textPartInBrace)) {
            this.textPartInBrace = "";
        }
        this.braceInOwnLine = !this.textPartInBrace.isEmpty() && this.firstTextPart.length() + this.textPartInBrace.length() + 3 > 15;
    }

    private void breakLongTexts() {
        this.firstTextPart = this.breakLongText(this.firstTextPart);
        this.textPartInBrace = this.breakLongText(this.textPartInBrace);
    }

    private String breakLongText(String string) {
        if (string.length() > 15) {
            return Text.addLineBreaks(string, 15);
        }
        return string;
    }

    public String getFirstTextPart() {
        return this.firstTextPart;
    }

    public String getTextPartInBrace() {
        return this.textPartInBrace;
    }

    public boolean isBraceInOwnLine() {
        return this.braceInOwnLine;
    }
}

