/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HelpMenuCreation
implements SingleMenuCreation {
    private final VocabularyTrainerGui gui;

    public HelpMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Hilfe");
        jMenu.setMnemonic('h');
        jMenu.add(this.createAboutMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createHelpMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createTodoMenuItem());
        jMenu.add(this.createChangesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createKeyboardCommandsDescriptionMenuItem());
        jMenu.add(this.createKeyboardCommandsDescriptionSortMenuItem());
        return jMenu;
    }

    private JMenuItem createAboutMenuItem() {
        return new MyMenuItem("\u00dcber das Programm ...").mnemonic('\u00fc').actionListener(actionEvent -> this.gui.about());
    }

    private JMenuItem createHelpMenuItem() {
        return new MyMenuItem("Hilfe").mnemonic('h').accelerator(112, 0).actionListener(actionEvent -> this.gui.help());
    }

    private JMenuItem createTodoMenuItem() {
        return new MyMenuItem("Weiterentwicklung (todo)").mnemonic('w').actionListener(actionEvent -> this.gui.todo());
    }

    private JMenuItem createChangesMenuItem() {
        return new MyMenuItem("Neuigkeiten / \u00c4nderungen").mnemonic('n').actionListener(actionEvent -> this.gui.changes());
    }

    private JMenuItem createKeyboardCommandsDescriptionMenuItem() {
        return new MyMenuItem("Tastaturbelegung in Men\u00fcreihenfolge").mnemonic('b').actionListener(actionEvent -> this.gui.keyboardDescription());
    }

    private JMenuItem createKeyboardCommandsDescriptionSortMenuItem() {
        return new MyMenuItem("Tastaturbelegung in der Reihenfolge der Tasten").mnemonic('r').actionListener(actionEvent -> this.gui.keyboardDescriptionSortByKeys());
    }
}

