/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.creation.menu.ExtraMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.FileMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.GrammarMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.HelpMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.KanaAndKanjiMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.OwnListMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.UpdateMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.VocableMenuCreation;
import de.duehl.vocabulary.japanese.ui.creation.menu.VocabularyMenuCreation;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class MenuCreation {
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private final JMenuBar menuBar;

    public MenuCreation(VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui) {
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
        this.menuBar = new JMenuBar();
        this.createTheMenu();
    }

    private void createTheMenu() {
        ArrayList<SingleMenuCreation> arrayList = new ArrayList<SingleMenuCreation>();
        arrayList.add(new FileMenuCreation(this.logic));
        arrayList.add(new VocabularyMenuCreation(this.gui));
        arrayList.add(new VocableMenuCreation(this.gui));
        arrayList.add(new OwnListMenuCreation(this.gui));
        arrayList.add(new KanaAndKanjiMenuCreation(this.gui));
        arrayList.add(new GrammarMenuCreation(this.gui));
        arrayList.add(new ExtraMenuCreation(this.gui));
        arrayList.add(new UpdateMenuCreation(this.logic));
        arrayList.add(new HelpMenuCreation(this.gui));
        this.menuBar.removeAll();
        for (SingleMenuCreation singleMenuCreation : arrayList) {
            this.menuBar.add(singleMenuCreation.createTheMenu());
        }
    }

    public void addTo(JFrame jFrame) {
        jFrame.setJMenuBar(this.menuBar);
        jFrame.validate();
    }
}

