/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs.data.BaseFormAndCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GrammarTableBaseFormUserSelectionDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 600);
    private static final int VERTICAL_SPACE_BETWEEN_FORMS = 3;
    private final List<Vocable> baseFormVocables;
    private final List<BaseFormAndCheckBox> baseFormsAndCheckBoxes;
    private boolean applied;

    public GrammarTableBaseFormUserSelectionDialog(List<Vocable> list, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), "Auswahl der Grundformen f\u00fcr die Tabelle", DIALOG_DIMENSION);
        this.baseFormVocables = list;
        this.baseFormsAndCheckBoxes = new ArrayList<BaseFormAndCheckBox>();
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.fillBaseFormsAndCheckBoxes();
        this.initValues();
    }

    private void fillBaseFormsAndCheckBoxes() {
        for (Vocable vocable : this.baseFormVocables) {
            this.fillBaseFormAndCheckBox(vocable);
        }
    }

    private void fillBaseFormAndCheckBox(Vocable vocable) {
        String string = vocable.getKanjiKanaRomajiWithJapaneseBraces();
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setSelected(true);
        GuiTools.biggerFont(jCheckBox, 10);
        jCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        BaseFormAndCheckBox baseFormAndCheckBox = new BaseFormAndCheckBox(vocable, jCheckBox);
        this.baseFormsAndCheckBoxes.add(baseFormAndCheckBox);
    }

    private void initValues() {
        this.applied = false;
    }

    @Override
    protected void populateDialog() {
        this.add(GuiTools.createScrollPane(this.createMainPart()), "Center");
        this.add(this.createButtonPart(), "South");
        this.pack();
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        for (BaseFormAndCheckBox baseFormAndCheckBox : this.baseFormsAndCheckBoxes) {
            jPanel.add(this.createPanelForCheckBox(baseFormAndCheckBox.getCheckBox()));
        }
        return jPanel;
    }

    private Component createPanelForCheckBox(JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)jCheckBox, "Center");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.createSelectionsButtonsPart()), "Center");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createSelectionsButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 1, 1));
        jPanel.add(this.createSelectAllButton());
        jPanel.add(this.createDeselectAllButton());
        return jPanel;
    }

    private Component createSelectAllButton() {
        JButton jButton = new JButton("Alle ausw\u00e4hlen");
        jButton.addActionListener(actionEvent -> this.selectAll(true));
        return jButton;
    }

    private Component createDeselectAllButton() {
        JButton jButton = new JButton("Alle entfernen");
        jButton.addActionListener(actionEvent -> this.selectAll(false));
        return jButton;
    }

    private void selectAll(boolean bl) {
        for (BaseFormAndCheckBox baseFormAndCheckBox : this.baseFormsAndCheckBoxes) {
            JCheckBox jCheckBox = baseFormAndCheckBox.getCheckBox();
            jCheckBox.setSelected(bl);
        }
    }

    private Component createOkButton() {
        JButton jButton = new JButton("Auswahl best\u00e4tigen");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        this.baseFormVocables.clear();
        for (BaseFormAndCheckBox baseFormAndCheckBox : this.baseFormsAndCheckBoxes) {
            JCheckBox jCheckBox = baseFormAndCheckBox.getCheckBox();
            if (!jCheckBox.isSelected()) continue;
            Vocable vocable = baseFormAndCheckBox.getBaseFormVocable();
            this.baseFormVocables.add(vocable);
        }
        this.applied = true;
        this.closeDialog();
    }

    public boolean isApplied() {
        return this.applied;
    }
}

