/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.table;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.tables.ButtonColumn;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.detail.KanjiDetailFrame;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.table.components.AllVocablesWithKanjiShower;
import de.duehl.vocabulary.japanese.ui.dialog.table.kanji.KanjiTableColumnModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.kanji.KanjiTableModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.kanji.KanjiTableRenderer;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.lister.VocabularyListerDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

public class KanjiTableDialog
extends NonModalFrameDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 1000);
    private static final Color TABLE_FOREGROUND = new Color(0, 0, 255);
    private static final Color TABLE_BACKGROUND = new Color(240, 240, 255);
    private static final float DEFAULT_FONT_SIZE = 15.0f;
    private final List<Kanji> kanjiList;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final LongTimeProcessInformer informer;
    private final JTable table;
    private final KanjiTableModel tableModel;
    private final KanjiTableRenderer tableRenderer;
    private JScrollPane scrollPane;
    private final JButton increaseFontSizeButton;
    private final JButton standardFontSizeButton;
    private final JButton decreaseFontSizeButton;

    public KanjiTableDialog(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, LongTimeProcessInformer longTimeProcessInformer, Point point) {
        this(Kanji.getAllKanjiAsList(), fumikoDataStructures, fumikoUiObjects, longTimeProcessInformer, KanjiTableDialog.createDialogTitle(Kanji.getNumberOfKnownKanji()), point);
    }

    public KanjiTableDialog(List<Kanji> list, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, LongTimeProcessInformer longTimeProcessInformer, String string, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), string, DIALOG_DIMENSION);
        this.addEscapeBehaviour();
        this.kanjiList = list;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.informer = longTimeProcessInformer;
        this.table = new JTable();
        this.tableModel = new KanjiTableModel(list, fumikoDataStructures);
        this.tableRenderer = new KanjiTableRenderer(TABLE_FOREGROUND, TABLE_BACKGROUND);
        this.increaseFontSizeButton = new JButton();
        this.standardFontSizeButton = new JButton();
        this.decreaseFontSizeButton = new JButton();
        this.init();
        this.fillDialog();
    }

    private static String createDialogTitle(int n) {
        return "Liste mit den " + NumberString.taupu(n) + " bislang erfassten Kanji.";
    }

    private void init() {
        this.initTable();
        this.initScrollPane();
    }

    private void initTable() {
        this.initTableModel();
        this.initTableColumnModel();
        this.initTableRenderer();
        this.setTableSelectionMode();
        this.setTableRowHight();
        this.switchReorderingOfTableColumnsOff();
        this.initTableButtonEditorAndRenderer();
        this.initTableSorter();
    }

    private void initTableModel() {
        this.table.setModel(this.tableModel);
    }

    private void initTableColumnModel() {
        this.table.setColumnModel(new KanjiTableColumnModel(this.dataStructures.getOptions()));
    }

    private void initTableRenderer() {
        this.tableRenderer.setFontSize(15.0f);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
    }

    private void setTableSelectionMode() {
        this.table.setSelectionMode(0);
    }

    private void setTableRowHight() {
        this.tableRenderer.initRowHeightOfTable(this.table);
    }

    private void switchReorderingOfTableColumnsOff() {
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private void initTableButtonEditorAndRenderer() {
        int n2 = 9;
        Options options = this.dataStructures.getOptions();
        if (options.isShowKanjiNumberInMyHandwrittenKanjiNotebooks()) {
            ++n2;
        }
        new ButtonColumn(this.table, n -> this.reactOnShowKanjiVocablesButtonClick(n), n2);
        int n3 = 16;
        if (options.isShowKanjiNumberInMyHandwrittenKanjiNotebooks()) {
            ++n3;
        }
        new ButtonColumn(this.table, n -> this.reactOnShowKanjiDetailsButtonClick(n), n3);
    }

    private void reactOnShowKanjiVocablesButtonClick(int n) {
        Kanji kanji = this.kanjiList.get(n);
        AllVocablesWithKanjiShower allVocablesWithKanjiShower = new AllVocablesWithKanjiShower(this.dataStructures, this.uiObjects, this.getLocation(), this.informer);
        allVocablesWithKanjiShower.showKanji(kanji);
    }

    private void reactOnShowKanjiDetailsButtonClick(int n) {
        Kanji kanji = this.kanjiList.get(n);
        KanjiDetailFrame kanjiDetailFrame = new KanjiDetailFrame(kanji, this.dataStructures, this.uiObjects, this.informer, this.getParentLocation());
        kanjiDetailFrame.setVisible(true);
    }

    private void initTableSorter() {
        TableRowSorter<KanjiTableModel> tableRowSorter = new TableRowSorter<KanjiTableModel>(this.tableModel);
        Comparator<String> comparator = VocabularyListerDialog.createLastTenTestResultsSorter();
        int n = 15;
        Options options = this.dataStructures.getOptions();
        if (options.isShowKanjiNumberInMyHandwrittenKanjiNotebooks()) {
            ++n;
        }
        tableRowSorter.setComparator(n, comparator);
        this.table.setRowSorter(tableRowSorter);
    }

    private void initScrollPane() {
        this.scrollPane = GuiTools.createScrollPane(this.table);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        GuiTools.scrollScrollbarToMinimumLater(this.scrollPane);
    }

    private void initElements() {
        this.initIncreaseFontSizeButton();
        this.initStandardFontSizeButton();
        this.initDecreaseFontSizeButton();
    }

    private void initIncreaseFontSizeButton() {
        this.increaseFontSizeButton.setText("+");
        this.increaseFontSizeButton.addActionListener(actionEvent -> this.increaseFontSize());
    }

    private void increaseFontSize() {
        this.tableRenderer.increaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initStandardFontSizeButton() {
        String string = "default size (" + NumberString.twoDecimalPlaces(15.0) + ")";
        this.standardFontSizeButton.setText(string);
        this.standardFontSizeButton.addActionListener(actionEvent -> this.standardFontSize());
    }

    private void standardFontSize() {
        this.tableRenderer.setFontSize(15.0f);
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initDecreaseFontSizeButton() {
        this.decreaseFontSizeButton.setText("-");
        this.decreaseFontSizeButton.addActionListener(actionEvent -> this.decreaseFontSize());
    }

    private void decreaseFontSize() {
        this.tableRenderer.decreaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createFontSizeAndColorButtonsPart(), "West");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createFontSizeAndColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createFontSizeButtonsPart());
        jPanel.add(this.createColorButtonsPart());
        return jPanel;
    }

    private Component createFontSizeButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.decreaseFontSizeButton);
        jPanel.add(this.standardFontSizeButton);
        jPanel.add(this.increaseFontSizeButton);
        return jPanel;
    }

    private Component createColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createSwitchForegroundColorButton());
        jPanel.add(this.createSwitchBackgroundColorButton());
        return jPanel;
    }

    private Component createSwitchForegroundColorButton() {
        JButton jButton = new JButton("toggle Vordergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorForegroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorForegroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorForegroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createSwitchBackgroundColorButton() {
        JButton jButton = new JButton("toggle Hintergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorBackgroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorBackgroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorBackgroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }
}

