/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.lister;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.tables.ButtonColumn;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.button.OtherViewButtonPanel;
import de.duehl.vocabulary.japanese.ui.components.button.ViewButtonPressedReactor;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.KanjiTester;
import de.duehl.vocabulary.japanese.ui.dialog.table.vocable.VocableTableColumnModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.vocable.VocableTableModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.vocable.VocableTableRenderer;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.VocableWithInternaViewer;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

public class VocabularyListerDialog
extends NonModalFrameDialogBase
implements ViewButtonPressedReactor {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 1000);
    private static final Color TABLE_FOREGROUND = new Color(0, 0, 255);
    private static final Color TABLE_BACKGROUND = new Color(240, 240, 255);
    private static final float DEFAULT_FONT_SIZE = 15.0f;
    private final List<Vocable> vocables;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final JTable table;
    private final VocableTableModel tableModel;
    private final VocableTableRenderer tableRenderer;
    private JScrollPane scrollPane;
    private final JButton increaseFontSizeButton;
    private final JButton standardFontSizeButton;
    private final JButton decreaseFontSizeButton;
    private final OtherViewButtonPanel otherViewPanel;

    public VocabularyListerDialog(List<Vocable> list, String string, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point, LongTimeProcessInformer longTimeProcessInformer) {
        super(point, fumikoUiObjects.getProgramImage(), VocabularyListerDialog.createDialogTitle(list, string, fumikoDataStructures), DIALOG_DIMENSION);
        this.addEscapeBehaviour();
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        Options options = fumikoDataStructures.getOptions();
        if (options.isUseVocablesShuffleTypeForShowingListsAndSheetsToo()) {
            VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
            VocableListShuffler vocableListShuffler = new VocableListShuffler(list, vocablesShuffleType, fumikoDataStructures);
            vocableListShuffler.shuffle();
            this.vocables = vocableListShuffler.getVocables();
        } else {
            this.vocables = list;
        }
        this.table = new JTable();
        this.tableModel = new VocableTableModel(this.vocables, fumikoDataStructures);
        this.tableRenderer = new VocableTableRenderer(TABLE_FOREGROUND, TABLE_BACKGROUND);
        this.increaseFontSizeButton = new JButton();
        this.standardFontSizeButton = new JButton();
        this.decreaseFontSizeButton = new JButton();
        this.otherViewPanel = new OtherViewButtonPanel(list, this, string, fumikoDataStructures, fumikoUiObjects, longTimeProcessInformer);
        this.otherViewPanel.disableListenDarstellungButton();
        this.init();
        this.fillDialog();
    }

    private static String createDialogTitle(List<Vocable> list, String string, FumikoDataStructures fumikoDataStructures) {
        String string2 = "Liste mit den " + NumberString.taupu(list.size()) + " Vokabeln aus " + string;
        return VocabularyTrainerUiTools.generateTitleWithVocabularyTestSuccesss(list, string2, fumikoDataStructures);
    }

    private void init() {
        this.initTable();
        this.initScrollPane();
    }

    private void initTable() {
        this.initTableModel();
        this.initTableColumnModel();
        this.initTableRenderer();
        this.setTableSelectionMode();
        this.setTableRowHight();
        this.switchReorderingOfTableColumnsOff();
        this.initTableButtonEditorAndRenderer();
        this.initTableSorter();
    }

    private void initTableModel() {
        this.table.setModel(this.tableModel);
    }

    private void initTableColumnModel() {
        Options options = this.dataStructures.getOptions();
        this.table.setColumnModel(new VocableTableColumnModel(options));
    }

    private void initTableRenderer() {
        this.tableRenderer.setFontSize(15.0f);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
    }

    private void setTableSelectionMode() {
        this.table.setSelectionMode(0);
    }

    private void setTableRowHight() {
        this.tableRenderer.initRowHeightOfTable(this.table);
    }

    private void switchReorderingOfTableColumnsOff() {
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private void initTableButtonEditorAndRenderer() {
        new ButtonColumn(this.table, n -> this.reactOnPlayMp3ButtonClick(n), 6);
        new ButtonColumn(this.table, n -> this.reactOnShowInterna(n), 17);
    }

    private void reactOnPlayMp3ButtonClick(int n) {
        Vocable vocable = this.vocables.get(n);
        String string = vocable.getMp3();
        VocabularyTools.playMp3(string);
    }

    private void reactOnShowInterna(int n) {
        Vocable vocable = this.vocables.get(n);
        VocableWithInternaViewer vocableWithInternaViewer = new VocableWithInternaViewer(vocable, this.dataStructures, this.uiObjects, this.getLocation());
        vocableWithInternaViewer.setVisible(true);
    }

    private void initTableSorter() {
        TableRowSorter<VocableTableModel> tableRowSorter = new TableRowSorter<VocableTableModel>(this.tableModel);
        Comparator<String> comparator = VocabularyListerDialog.createLastTenTestResultsSorter();
        tableRowSorter.setComparator(16, comparator);
        this.table.setRowSorter(tableRowSorter);
    }

    public static Comparator<String> createLastTenTestResultsSorter() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n;
                int n2;
                int n3 = Text.countPartInString(string, "+");
                if (n3 != (n2 = Text.countPartInString(string2, "+"))) {
                    return n2 - n3;
                }
                int n4 = Text.countPartInString(string, "-");
                if (n4 != (n = Text.countPartInString(string2, "-"))) {
                    return n4 - n;
                }
                int n5 = string.lastIndexOf("-");
                int n6 = string2.lastIndexOf("-");
                return n5 - n6;
            }
        };
    }

    private Comparator<Object> createDateSorter() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                String string = object.toString();
                String string2 = object2.toString();
                ImmutualDate immutualDate = new ImmutualDate(string);
                ImmutualDate immutualDate2 = new ImmutualDate(string2);
                return immutualDate.compareTo(immutualDate2);
            }
        };
    }

    private void initScrollPane() {
        this.scrollPane = GuiTools.createScrollPane(this.table);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        GuiTools.scrollScrollbarToMinimumLater(this.scrollPane);
    }

    private void initElements() {
        this.initIncreaseFontSizeButton();
        this.initStandardFontSizeButton();
        this.initDecreaseFontSizeButton();
    }

    private void initIncreaseFontSizeButton() {
        this.increaseFontSizeButton.setText("+");
        this.increaseFontSizeButton.addActionListener(actionEvent -> this.increaseFontSize());
    }

    private void increaseFontSize() {
        this.tableRenderer.increaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initStandardFontSizeButton() {
        String string = "default size (" + NumberString.twoDecimalPlaces(15.0) + ")";
        this.standardFontSizeButton.setText(string);
        this.standardFontSizeButton.addActionListener(actionEvent -> this.standardFontSize());
    }

    private void standardFontSize() {
        this.tableRenderer.setFontSize(15.0f);
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initDecreaseFontSizeButton() {
        this.decreaseFontSizeButton.setText("-");
        this.decreaseFontSizeButton.addActionListener(actionEvent -> this.decreaseFontSize());
    }

    private void decreaseFontSize() {
        this.tableRenderer.decreaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createFontSizeColorButtonsAndKanjiTestPart(), "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.otherViewPanel.getPanel()), "Center");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createFontSizeColorButtonsAndKanjiTestPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createFontSizeButtonsPart());
        jPanel.add(this.createColorButtonsPart());
        jPanel.add(GuiTools.addLeftSpace(this.createKanjiTestButton(), 50));
        return jPanel;
    }

    private Component createFontSizeButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.decreaseFontSizeButton);
        jPanel.add(this.standardFontSizeButton);
        jPanel.add(this.increaseFontSizeButton);
        return jPanel;
    }

    private Component createColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createSwitchForegroundColorButton());
        jPanel.add(this.createSwitchBackgroundColorButton());
        return jPanel;
    }

    private Component createSwitchForegroundColorButton() {
        JButton jButton = new JButton("toggle Vordergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorForegroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorForegroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorForegroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createSwitchBackgroundColorButton() {
        JButton jButton = new JButton("toggle Hintergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorBackgroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorBackgroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorBackgroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createKanjiTestButton() {
        JButton jButton = new JButton("Bekannte Kanji abfragen");
        jButton.addActionListener(actionEvent -> this.testKnownKanji());
        return jButton;
    }

    private void testKnownKanji() {
        List<Kanji> list = this.extractKnownKanjiFromVocables();
        if (list.isEmpty()) {
            String string = "Keine bekannten Kanji gefunden";
            String string2 = "In den Vokabeln dieser Liste wurden keine bekannten Kanji gefunden.";
            GuiTools.informUser(this.getWindowAsComponent(), string, string2);
        } else {
            this.startKanjiTest(list);
        }
    }

    private List<Kanji> extractKnownKanjiFromVocables() {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Vocable vocable : this.vocables) {
            List<Kanji> list = this.extractKnownKanjiFromVocable(vocable);
            for (Kanji kanji : list) {
                if (arrayList.contains((Object)kanji)) continue;
                arrayList.add(kanji);
            }
        }
        return arrayList;
    }

    private List<Kanji> extractKnownKanjiFromVocable(Vocable vocable) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        String string = vocable.getKanji();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            String string2 = kanji.getCharacter();
            if (!string.contains(string2) || arrayList.contains((Object)kanji)) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    private void startKanjiTest(List<Kanji> list) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        KanjiTester kanjiTester = new KanjiTester(list, "Kanji die in einer Vokabelliste vorkommen", bl, bl2, bl3, this.dataStructures, this.uiObjects, this.getLocation());
        kanjiTester.setVisible(true);
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    @Override
    public void otherViewOpened() {
        this.closeDialog();
    }
}

