/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.listcommander.list;

import de.duehl.twosidecommander.ui.list.ListDisplayer;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.listcommander.OwnListCommander;
import de.duehl.vocabulary.japanese.ui.listcommander.list.element.OwnListElementDisplayer;
import java.util.ArrayList;
import java.util.List;

public class OwnListDisplayer
extends ListDisplayer {
    private OwnList ownList;
    private final OwnListCommander commander;

    public OwnListDisplayer(OwnListCommander ownListCommander) {
        this.commander = ownListCommander;
    }

    public void setOwnList(OwnList ownList) {
        this.ownList = ownList;
    }

    @Override
    public List<ListElementDisplayer> createElementDisplyersToShow() {
        ArrayList<ListElementDisplayer> arrayList = new ArrayList<ListElementDisplayer>();
        for (Vocable vocable : this.ownList.getVocables()) {
            OwnListElementDisplayer ownListElementDisplayer = new OwnListElementDisplayer(this, this.commander, vocable);
            arrayList.add(ownListElementDisplayer);
        }
        return arrayList;
    }

    @Override
    public boolean canAppend(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        return !this.ownList.getVocables().contains(vocable);
    }

    @Override
    protected void appendImplmentation(List<ListElementDisplayer> list) {
        for (ListElementDisplayer listElementDisplayer : list) {
            this.appendImplmentation(listElementDisplayer);
        }
        this.commander.storeOwnLists();
    }

    private void appendImplmentation(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        List<Vocable> list = this.ownList.getVocables();
        if (list.contains(vocable)) {
            throw new RuntimeException("Kann die Vokabel nicht anh\u00e4ngen!\n\tVokabel: " + vocable + "\n\tListe  : " + this.ownList.getName() + "\n");
        }
        list.add(vocable);
    }

    @Override
    protected void removeImplmentation(List<ListElementDisplayer> list) {
        for (ListElementDisplayer listElementDisplayer : list) {
            this.removeImplmentation(listElementDisplayer);
        }
        this.commander.storeOwnLists();
    }

    private void removeImplmentation(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        List<Vocable> list = this.ownList.getVocables();
        list.remove(vocable);
    }

    public static final OwnListDisplayer castListDisplayer(ListDisplayer listDisplayer) {
        return (OwnListDisplayer)listDisplayer;
    }

    @Override
    public String getListDescription() {
        return this.ownList.getName();
    }

    public OwnList getOwnList() {
        return this.ownList;
    }

    @Override
    protected void moveListElementToFirstInImplementation(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        List<Vocable> list = this.ownList.getVocables();
        int n = list.indexOf(vocable);
        list.remove(n);
        list.add(0, vocable);
        this.commander.storeOwnLists();
    }

    @Override
    protected void moveListElementUpInImplementation(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        List<Vocable> list = this.ownList.getVocables();
        int n = list.indexOf(vocable);
        list.remove(n);
        list.add(n - 1, vocable);
        this.commander.storeOwnLists();
    }

    @Override
    protected void moveListElementDownInImplementation(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        List<Vocable> list = this.ownList.getVocables();
        int n = list.indexOf(vocable);
        list.remove(n);
        list.add(n + 1, vocable);
        this.commander.storeOwnLists();
    }

    @Override
    protected void moveListElementToLastInImplementation(ListElementDisplayer listElementDisplayer) {
        OwnListElementDisplayer ownListElementDisplayer = OwnListElementDisplayer.castListElementDisplayer(listElementDisplayer);
        Vocable vocable = ownListElementDisplayer.getVocable();
        List<Vocable> list = this.ownList.getVocables();
        int n = list.indexOf(vocable);
        list.remove(n);
        list.add(vocable);
        this.commander.storeOwnLists();
    }
}

