/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.tabs;

import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.tabs.VocabularyPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;

public class SubCategoryTabs {
    private final List<String> subCategoriesOfCategory;
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final Map<String, List<Vocabulary>> vocabularyBySubCategoryList;
    private final JTabbedPane subCategoryTabs;
    private final List<VocabularyPanel> vocabularyPanels;

    public SubCategoryTabs(List<String> list, List<Vocabulary> list2, VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.subCategoriesOfCategory = list;
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.vocabularyBySubCategoryList = this.createVocabulariesBySubCategoryMap(list2);
        this.subCategoryTabs = new JTabbedPane();
        this.vocabularyPanels = new ArrayList<VocabularyPanel>();
        this.populateSubCategoryTabs();
    }

    private Map<String, List<Vocabulary>> createVocabulariesBySubCategoryMap(List<Vocabulary> list) {
        HashMap<String, List<Vocabulary>> hashMap = new HashMap<String, List<Vocabulary>>();
        for (Vocabulary vocabulary : list) {
            String string = vocabulary.getSubCategory();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            List list2 = (List)hashMap.get(string);
            list2.add(vocabulary);
        }
        return hashMap;
    }

    private void populateSubCategoryTabs() {
        for (String string : this.subCategoriesOfCategory) {
            this.populateForSubCategory(string);
        }
    }

    private void populateForSubCategory(String string) {
        if (!this.vocabularyBySubCategoryList.containsKey(string)) {
            throw new RuntimeException("Zur Unterkategorie '" + string + "' wurde keine Liste an Vokabularien gefunden.");
        }
        List<Vocabulary> list = this.vocabularyBySubCategoryList.get(string);
        VocabularyPanel vocabularyPanel = new VocabularyPanel(list, this.logic, this.gui, this.dataStructures, this.uiObjects);
        this.subCategoryTabs.add(string, vocabularyPanel.getVocabularyPanel());
        this.vocabularyPanels.add(vocabularyPanel);
    }

    public void showTabsWeViewedLastTime(String string) {
        int n;
        Options options = this.dataStructures.getOptions();
        if (string.equals("Vocabulary")) {
            n = options.getLastShownVocabularySubCategoryTabIndex();
        } else if (string.equals("OwnList")) {
            n = options.getLastShownOwnListSubCategoryTabIndex();
        } else {
            throw new RuntimeException("Unbekannter lastShownTabIndexType '" + string + "'.");
        }
        if (n >= 0 && n < this.subCategoryTabs.getTabCount()) {
            this.subCategoryTabs.setSelectedIndex(n);
        }
    }

    public void storeShownTabIndices(Options options, String string) {
        int n = this.subCategoryTabs.getSelectedIndex();
        if (string.equals("Vocabulary")) {
            options.setLastShownVocabularySubCategoryTabIndex(n);
        } else if (string.equals("OwnList")) {
            options.setLastShownOwnListSubCategoryTabIndex(n);
        } else {
            throw new RuntimeException("Unbekannter lastShownTabIndexType '" + string + "'.");
        }
    }

    public List<Vocable> collectVocablesOfSelectedVocabularies() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            arrayList.addAll(vocabularyPanel.collectVocablesOfSelectedVocabularies());
        }
        return arrayList;
    }

    public void showVocabularyBarsInWantedOrder() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.showVocabularyBarsInWantedOrder();
        }
    }

    public void showOrHideIndividualVocabularySortModeMoveButtons() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.showOrHideIndividualVocabularySortModeMoveButtons();
        }
    }

    public List<Vocabulary> getVocabularyBarsInIndividualOrder() {
        ArrayList<Vocabulary> arrayList = new ArrayList<Vocabulary>();
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            arrayList.addAll(vocabularyPanel.getVocabularyBarsInIndividualOrder());
        }
        return arrayList;
    }

    public List<OwnList> getOwnListsInIndividualOrder() {
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            arrayList.addAll(vocabularyPanel.getOwnListsInIndividualOrder());
        }
        return arrayList;
    }

    public List<VocabularyBar> determineBarsOfSelectedTab() {
        int n = this.subCategoryTabs.getSelectedIndex();
        VocabularyPanel vocabularyPanel = this.vocabularyPanels.get(n);
        return vocabularyPanel.getBars();
    }

    public void setCorrectForegroundColorOfVocabularyBars() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.setCorrectForegroundColorOfVocabularyBars();
        }
    }

    public void setCorrectTextOfVocabularyBars() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.setCorrectTextOfVocabularyBars();
        }
    }

    public void showOrHidePercentInVocabularyBarsLater() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.showOrHidePercentInVocabularyBars();
        }
    }

    public JTabbedPane getSubCategoryTabs() {
        return this.subCategoryTabs;
    }

    public void showTranslationDirectionOnBarButtons() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.showTranslationDirectionOnBarButtons();
        }
    }

    public void toggleShowOwnListButtons() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.toggleShowOwnListButtons();
        }
    }

    public void showTestViewListSheetButtons() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.showTestViewListSheetButtons();
        }
    }

    public void showOwnListExtraButtons() {
        for (VocabularyPanel vocabularyPanel : this.vocabularyPanels) {
            vocabularyPanel.showOwnListExtraButtons();
        }
    }
}

