/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime;

import de.duehl.basics.datetime.DateAndTimeHelper;
import de.duehl.basics.datetime.date.DateHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.datetime.time.TimeHelper;
import java.util.Calendar;

public class DateAndTime {
    static final long SECONDS_OF_ONE_DAY = 86400L;
    private final ImmutualDate date;
    private final ImmutualTime time;

    public DateAndTime(ImmutualDate immutualDate, ImmutualTime immutualTime) {
        this.date = immutualDate;
        this.time = immutualTime;
    }

    public DateAndTime() {
        Calendar calendar = Calendar.getInstance();
        this.date = DateHelper.calendarToDate(calendar);
        this.time = TimeHelper.calendarToTime(calendar);
    }

    public DateAndTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.date = DateHelper.calendarToDate(calendar);
        this.time = TimeHelper.calendarToTime(calendar);
    }

    public ImmutualDate getDate() {
        return this.date;
    }

    public ImmutualTime getTime() {
        return this.time;
    }

    public DateAndTime addSeconds(int n) {
        this.time.checkNoDayCarryOver();
        ImmutualTime immutualTime = this.time.addSeconds(n);
        int n2 = immutualTime.getDayCarryOver();
        immutualTime = immutualTime.forgetDayCarryOver();
        ImmutualDate immutualDate = this.date.addDays(n2);
        return new DateAndTime(immutualDate, immutualTime);
    }

    public DateAndTime addMinutes(int n) {
        ImmutualTime immutualTime = this.time.addMinutes(n);
        int n2 = immutualTime.getDayCarryOver();
        immutualTime = immutualTime.forgetDayCarryOver();
        ImmutualDate immutualDate = this.date.addDays(n2);
        return new DateAndTime(immutualDate, immutualTime);
    }

    public DateAndTime addHours(int n) {
        ImmutualTime immutualTime = this.time.addHours(n);
        int n2 = immutualTime.getDayCarryOver();
        immutualTime = immutualTime.forgetDayCarryOver();
        ImmutualDate immutualDate = this.date.addDays(n2);
        return new DateAndTime(immutualDate, immutualTime);
    }

    public DateAndTime addDays(int n) {
        ImmutualDate immutualDate = this.date.addDays(n);
        return new DateAndTime(immutualDate, this.time);
    }

    public DateAndTime addMonths(int n) {
        ImmutualDate immutualDate = this.date.addMonths(n);
        return new DateAndTime(immutualDate, this.time);
    }

    public DateAndTime addYears(int n) {
        ImmutualDate immutualDate = this.date.addYears(n);
        return new DateAndTime(immutualDate, this.time);
    }

    public boolean before(DateAndTime dateAndTime) {
        if (this.date.before(dateAndTime.date)) {
            return true;
        }
        if (dateAndTime.date.before(this.date)) {
            return false;
        }
        return this.time.before(dateAndTime.time);
    }

    public boolean after(DateAndTime dateAndTime) {
        return dateAndTime.before(this);
    }

    public boolean liesBetween(DateAndTime dateAndTime, DateAndTime dateAndTime2) {
        return dateAndTime.equals(this) || dateAndTime2.equals(this) || dateAndTime.before(this) && this.before(dateAndTime2);
    }

    public long difference(DateAndTime dateAndTime) {
        int n = this.date.difference(dateAndTime.date);
        int n2 = this.time.difference(dateAndTime.time);
        long l = 86400L * (long)n + (long)n2;
        return l;
    }

    public DateAndTime setSecondsToZero() {
        return new DateAndTime(this.date, this.time.setSecondsToZero());
    }

    public long toEpoch() {
        String string = this.date.toString();
        String string2 = this.time.toString();
        return DateAndTimeHelper.toEpoch(string, string2);
    }

    public String asYyyyMmDdDelimiterHhMmSs(String string) {
        return this.date.asYyyyMmDd() + string + this.time.asHhMmSs();
    }

    public String toString(String string) {
        return this.date.toString() + string + this.time.toString();
    }

    public String toString() {
        return this.toString(", ");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.date == null ? 0 : this.date.hashCode());
        n = 31 * n + (this.time == null ? 0 : this.time.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateAndTime dateAndTime = (DateAndTime)object;
        if (this.date == null ? dateAndTime.date != null : !this.date.equals(dateAndTime.date)) {
            return false;
        }
        return !(this.time == null ? dateAndTime.time != null : !this.time.equals(dateAndTime.time));
    }
}

