/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.date.DateHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.datetime.time.TimeHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateAndTimeHelper {
    public static String now() {
        DateAndTime dateAndTime = new DateAndTime();
        return dateAndTime.toString();
    }

    public static DateAndTime millisToDateAndTime(long l) {
        DateAndTime dateAndTime = new DateAndTime(l);
        return dateAndTime;
    }

    public static String millisToDateAndTimeString(long l) {
        DateAndTime dateAndTime = DateAndTimeHelper.millisToDateAndTime(l);
        return dateAndTime.toString();
    }

    public static String timeWithoutSecondsWithoutDateIfFromToday(DateAndTime dateAndTime) {
        ImmutualDate immutualDate = dateAndTime.getDate();
        ImmutualTime immutualTime = dateAndTime.getTime();
        DateAndTime dateAndTime2 = new DateAndTime();
        ImmutualDate immutualDate2 = dateAndTime2.getDate();
        if (immutualDate2.equals(immutualDate)) {
            return immutualTime.toStringWithoutSeconds();
        }
        return immutualTime.toStringWithoutSeconds() + " am " + immutualDate.toString();
    }

    public static String timePeriodWithoutSecondsWithoutDateIfFromToday(DateAndTime dateAndTime, DateAndTime dateAndTime2) {
        ImmutualDate immutualDate = dateAndTime.getDate();
        ImmutualTime immutualTime = dateAndTime.getTime();
        ImmutualDate immutualDate2 = dateAndTime2.getDate();
        ImmutualTime immutualTime2 = dateAndTime2.getTime();
        DateAndTime dateAndTime3 = new DateAndTime();
        ImmutualDate immutualDate3 = dateAndTime3.getDate();
        if (immutualDate3.equals(immutualDate) && immutualDate3.equals(immutualDate2)) {
            return immutualTime.toStringWithoutSeconds() + " - " + immutualTime2.toStringWithoutSeconds();
        }
        return immutualTime.toStringWithoutSeconds() + " am " + immutualDate.toString() + " - " + immutualTime2.toStringWithoutSeconds() + " am " + immutualDate2.toString();
    }

    public static DateAndTime calendarToDateAndTime(Calendar calendar) {
        ImmutualDate immutualDate = DateHelper.calendarToDate(calendar);
        ImmutualTime immutualTime = TimeHelper.calendarToTime(calendar);
        return new DateAndTime(immutualDate, immutualTime);
    }

    public static long toEpoch(String string, String string2) {
        if (!string.matches("\\d{2}\\.\\d{2}\\.\\d{4}")) {
            throw new RuntimeException("Das Datum '" + string + "' hat das falsche Format.");
        }
        if (!string2.matches("\\d{2}:\\d{2}:\\d{2}")) {
            throw new RuntimeException("Die Zeit '" + string2 + "' hat das falsche Format.");
        }
        return DateAndTimeHelper.reallyToEpoch(string, string2);
    }

    private static long reallyToEpoch(String string, String string2) {
        try {
            return DateAndTimeHelper.tryToToEpoch(string, string2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Fehler beim Ermitteln von Epoch.\n\tdate = " + string + "\n\ttime = " + string2 + "\n", exception);
        }
    }

    private static long tryToToEpoch(String string, String string2) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Date date = simpleDateFormat.parse(string + " " + string2);
        long l = date.getTime();
        return l;
    }
}

