/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.io.FilePatternSearchResult;
import de.duehl.basics.io.FileSearchResult;
import de.duehl.basics.io.FineFileReader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FindInSpecialFiles {
    private final FilenameFilter filter;
    private final FilenameFilter directoryFilter;

    public FindInSpecialFiles(final String string) {
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.endsWith(string);
            }
        };
        this.directoryFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file.getPath() + File.separator + string);
                return file2.isDirectory();
            }
        };
    }

    public List<FileSearchResult> find(String string, String string2) {
        String string3;
        ArrayList<FileSearchResult> arrayList = new ArrayList<FileSearchResult>();
        File file = new File(string);
        for (String string4 : file.list(this.filter)) {
            string3 = file.getPath() + File.separator + string4;
            arrayList.addAll(this.findInOneFile(string3, string2));
        }
        for (String string4 : file.list(this.directoryFilter)) {
            string3 = file.getPath() + File.separator + string4;
            arrayList.addAll(this.find(string3, string2));
        }
        return arrayList;
    }

    private List<FileSearchResult> findInOneFile(String string, String string2) {
        ArrayList<FileSearchResult> arrayList = new ArrayList<FileSearchResult>();
        FineFileReader fineFileReader = new FineFileReader(string);
        String string3 = fineFileReader.readNextLine();
        while (string3 != null) {
            if (string3.contains(string2)) {
                FileSearchResult fileSearchResult = new FileSearchResult(string, fineFileReader.getLineNumber(), string3);
                arrayList.add(fileSearchResult);
            }
            string3 = fineFileReader.readNextLine();
        }
        fineFileReader.close();
        return arrayList;
    }

    public List<FilePatternSearchResult> findWithPattern(String string, Pattern pattern) {
        String string2;
        ArrayList<FilePatternSearchResult> arrayList = new ArrayList<FilePatternSearchResult>();
        File file = new File(string);
        for (String string3 : file.list(this.filter)) {
            string2 = file.getPath() + File.separator + string3;
            arrayList.addAll(this.findWithPatternInOneFile(string2, pattern));
        }
        for (String string3 : file.list(this.directoryFilter)) {
            string2 = file.getPath() + File.separator + string3;
            arrayList.addAll(this.findWithPattern(string2, pattern));
        }
        return arrayList;
    }

    private List<FilePatternSearchResult> findWithPatternInOneFile(String string, Pattern pattern) {
        ArrayList<FilePatternSearchResult> arrayList = new ArrayList<FilePatternSearchResult>();
        FineFileReader fineFileReader = new FineFileReader(string);
        String string2 = fineFileReader.readNextLine();
        while (string2 != null) {
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                FilePatternSearchResult filePatternSearchResult = new FilePatternSearchResult(string, fineFileReader.getLineNumber(), string2, matcher.group(1));
                arrayList.add(filePatternSearchResult);
            }
            string2 = fineFileReader.readNextLine();
        }
        fineFileReader.close();
        return arrayList;
    }
}

