/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.Writer;
import de.duehl.basics.io.exceptions.IORuntimeException;
import de.duehl.basics.text.Lines;
import de.duehl.basics.text.Text;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FineFileWriter
implements Writer {
    private final OutputStreamWriter writer;
    private final String fileName;
    private final boolean append;
    private final Charset charset;

    public FineFileWriter(File file) {
        this(file.getAbsolutePath(), false);
    }

    public FineFileWriter(String string) {
        this(string, false);
    }

    public FineFileWriter(String string, boolean bl) {
        this(string, Charset.ISO_8859_1, bl);
    }

    public FineFileWriter(String string, Charset charset) {
        this(string, charset, false);
    }

    public FineFileWriter(String string, Charset charset, boolean bl) {
        this.fileName = string;
        this.append = bl;
        this.charset = charset;
        this.writer = this.openWriter();
    }

    private OutputStreamWriter openWriter() {
        try {
            return this.tryToOpenWriter();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IORuntimeException("Der Pfad zur Ausgabedatei '" + this.fileName + "' wurde nicht gefunden. (" + fileNotFoundException.getMessage() + ")");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IORuntimeException("Bei der Erzeugung des OutputStreamWriters f\u00fcr die Eingabedatei '" + this.fileName + "' wurde eine nicht unterst\u00fctzte Kodierung verwendet. (" + unsupportedEncodingException.getMessage() + ")");
        }
    }

    private OutputStreamWriter tryToOpenWriter() throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName, this.append);
        return new OutputStreamWriter((OutputStream)fileOutputStream, this.charset.getCharsetAsString());
    }

    @Override
    public void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            throw new IORuntimeException("Beim Schreiben in die Datei '" + this.fileName + "' trat ein Fehler auf. (" + iOException.getMessage() + ")");
        }
    }

    @Override
    public void write(int n) {
        this.write(Integer.toString(n));
    }

    @Override
    public void writeln() {
        this.write(Text.LINE_BREAK);
    }

    @Override
    public void writeln(String string) {
        this.write(string + Text.LINE_BREAK);
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new IORuntimeException("Beim Schlie\u00dfen der Datei '" + this.fileName + "' trat ein Fehler auf. (" + iOException.getMessage() + ")");
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new IORuntimeException("Beim Flushen der Datei '" + this.fileName + "' trat ein Fehler auf. (" + iOException.getMessage() + ")");
        }
    }

    @Override
    public void writeAllLines(List<String> list) {
        for (String string : list) {
            this.write(string + Text.LINE_BREAK);
        }
    }

    @Override
    public void writeAllLines(Lines lines) {
        this.writeAllLines(lines.getLines());
    }

    @Override
    public void writeFieldsLine(List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                this.write("\t");
            }
            this.write(string);
        }
        this.writeln();
    }

    @Override
    public void writeFieldsLine(String ... stringArray) {
        this.writeFieldsLine(Arrays.asList(stringArray));
    }

    @Override
    public void writeFieldsLine(List<String> list, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        arrayList.addAll(Arrays.asList(stringArray));
        this.writeFieldsLine(arrayList);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

