/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.dictionary.io.reader;

import de.duehl.basics.io.textfile.StringsFromTextFileReader;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;

public class DictionaryFromTextFileReader {
    private final StringsFromTextFileReader reader;
    private boolean multipleEqualValuesAreError;
    private Dictionary dictionary;
    private boolean dictionaryEntryIsOpened;
    private DictionaryEntry dictionaryEntry;

    public DictionaryFromTextFileReader(StringsFromTextFileReader stringsFromTextFileReader) {
        this.reader = stringsFromTextFileReader;
        stringsFromTextFileReader.doNotTrimLines();
        this.multipleEqualValuesAreError = false;
    }

    public void beQuiet() {
        this.reader.beQuiet();
    }

    public void multipleEqualValuesAreError() {
        this.multipleEqualValuesAreError = true;
    }

    public void changeToLowerCase() {
        this.reader.changeToLowerCase();
    }

    public void read() {
        this.init();
        this.readAllLines();
        this.addLastDictionaryEntry();
    }

    private void init() {
        this.dictionary = new Dictionary();
        this.dictionaryEntryIsOpened = false;
        this.dictionaryEntry = null;
    }

    private void readAllLines() {
        for (String string : this.reader.read()) {
            this.workWithLine(string);
        }
    }

    private void workWithLine(String string) {
        if (!this.isLineIndentedComment(string)) {
            this.workWithNotEmptyLine(string);
        }
    }

    private boolean isLineIndentedComment(String string) {
        if (string.isBlank()) {
            return true;
        }
        String string2 = string.trim();
        return string2.startsWith(this.reader.getCommentChar());
    }

    private void workWithNotEmptyLine(String string) {
        if (this.isIndented(string)) {
            this.workWithAlternativesLine(string);
        } else {
            this.workWithMainWordLine(string);
        }
        this.checkIfPhraseIsKnownInAlreadyCollectedDictionaryEntries(string);
    }

    private void checkIfPhraseIsKnownInAlreadyCollectedDictionaryEntries(String string) {
        String string2;
        if (this.multipleEqualValuesAreError && this.dictionary.containsEntryWithMainWordOrAlternative(string2 = string.strip())) {
            throw new RuntimeException("Hauptwort oder Alternative '" + string2 + "' ist in verschiedenen Bl\u00f6cken vorhanden, u.a. zu diesem Hauptwort: '" + this.dictionaryEntry.getMainWord() + "'.");
        }
    }

    private boolean isIndented(String string) {
        if (string.startsWith("    ")) {
            String string2 = string.substring(4);
            if (string2.startsWith(" ")) {
                throw new IllegalArgumentException("Zeile '" + string + "' startet mit mehr als vier Leerzeichen.\n\tDateiname   : " + this.reader.getFilename() + "\n\tZeilennummer: " + this.reader.getLineNumber() + "\n");
            }
            if (string2.startsWith("\t")) {
                throw new IllegalArgumentException("Zeile '" + string + "' startet mit vier Leerzeichen und einem Tabulator.\n\tDateiname   : " + this.reader.getFilename() + "\n\tZeilennummer: " + this.reader.getLineNumber() + "\n");
            }
            return true;
        }
        if (string.startsWith(" ")) {
            throw new IllegalArgumentException("Zeile '" + string + "' startet mit weniger als vier Leerzeichen.\n\tDateiname   : " + this.reader.getFilename() + "\n\tZeilennummer: " + this.reader.getLineNumber() + "\n");
        }
        if (string.startsWith("\t")) {
            throw new IllegalArgumentException("Zeile '" + string + "' startet mit einem Tabulator.\n\tDateiname   : " + this.reader.getFilename() + "\n\tZeilennummer: " + this.reader.getLineNumber() + "\n");
        }
        return false;
    }

    private void workWithMainWordLine(String string) {
        if (this.dictionaryEntryIsOpened) {
            this.addDictionaryEntry();
        }
        String string2 = string.trim();
        this.dictionaryEntryIsOpened = true;
        this.dictionaryEntry = new DictionaryEntry(string2);
    }

    private void workWithAlternativesLine(String string) {
        if (!this.dictionaryEntryIsOpened) {
            throw new IllegalArgumentException("Zeile '" + string + "' startet mit vier Leerzeichen, aber es fehlt das Hauptwort davor!.");
        }
        String string2 = string.trim();
        if (!this.dictionaryEntry.contains(string2)) {
            this.dictionaryEntry.addAlternative(string2);
        } else if (this.multipleEqualValuesAreError) {
            throw new RuntimeException("Die Alternative '" + string2 + "' ist im Block mit dfem Hauptwort '" + this.dictionaryEntry.getMainWord() + "'doppelt vorhanden: .");
        }
    }

    private void addLastDictionaryEntry() {
        if (this.dictionaryEntryIsOpened) {
            this.addDictionaryEntry();
        }
    }

    private void addDictionaryEntry() {
        this.dictionary.addDictionaryEntry(this.dictionaryEntry);
        this.dictionaryEntryIsOpened = false;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }
}

