/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.html.generation;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.generation.HtmlHeader;
import de.duehl.basics.text.html.generation.HtmlHeaderType;
import de.duehl.basics.text.xml.NamedXmlParameter;
import de.duehl.basics.text.xml.generation.XmlBuilder;
import java.util.ArrayList;
import java.util.List;

public class HtmlBuilder
extends XmlBuilder {
    static final String n = Text.LINE_BREAK;
    private static final String TOP_LINK_NAME = "top";
    static final String CSS = "<style>" + n + "    body {" + n + "        background-color:#E6E6FF;" + n + "        color:#000096;" + n + "        font-family:Verdana, sans-serif;" + n + "        font-size:14pt;" + n + "        margin-left:3%;" + n + "        margin-right:3%;" + n + "        color:#000096;" + n + "    }" + n + "    p {" + n + "        font-size:1em;" + n + "        font-family:Verdana, sans-serif;" + n + "        color:#000096;" + n + "    }" + n + "    h1 {" + n + "        text-align: left;" + n + "        font-size: 36pt;" + n + "        font-weight: bold;" + n + "        color:#000096;" + n + "        margin-top:25;" + n + "    }" + n + "    h1#id1 {" + n + "        margin-top:0;" + n + "    }" + n + "    h2 {" + n + "        text-align: left;" + n + "        font-size: 24pt;" + n + "        font-weight: bold;" + n + "        color:#000096;" + n + "        margin-bottom:8;" + n + "        margin-top:15;" + n + "    }" + n + "    h3 {" + n + "        font-size: 20pt;" + n + "        color:#000096;" + n + "        margin-bottom:0;" + n + "    }" + n + "    h4 {" + n + "        font-size: 18pt;" + n + "        color:#000096;" + n + "        margin-bottom:0;" + n + "    }" + n + "    h5 {" + n + "        font-size: 16pt;" + n + "        color:#000096;" + n + "        margin-bottom:0;" + n + "    }" + n + "    h6 {" + n + "        font-size: 15pt;" + n + "        color:#000096;" + n + "        margin-bottom:0;" + n + "    }" + n + "    .monospace {" + n + "        font-family: monospace;" + n + "    }" + n + "</style>";
    protected int numberOfH1 = 0;
    protected int numberOfH2 = 0;
    protected int numberOfH3 = 0;
    protected int numberOfH4 = 0;
    protected int numberOfH5 = 0;
    protected int numberOfH6 = 0;
    protected List<HtmlHeader> headers = new ArrayList<HtmlHeader>();
    private boolean hasContents = false;
    private boolean showTopLink = true;
    private boolean createContentWithNames = false;
    private boolean appendTopLinksToH2 = false;

    public HtmlBuilder createContentWithNames() {
        this.createContentWithNames = true;
        return this;
    }

    public HtmlBuilder hideTopLinks() {
        this.showTopLink = false;
        return this;
    }

    @Override
    public HtmlBuilder increaseIndentationLevel() {
        super.increaseIndentationLevel();
        return this;
    }

    @Override
    public HtmlBuilder decreaseIndentationLevel() {
        super.decreaseIndentationLevel();
        return this;
    }

    @Override
    public HtmlBuilder setIndentationLevelToZero() {
        super.setIndentationLevelToZero();
        return this;
    }

    public HtmlBuilder createHtmlPartInBody() {
        this.setIndentationLevel(2);
        return this;
    }

    @Override
    public HtmlBuilder clear() {
        super.clear();
        return this;
    }

    @Override
    public HtmlBuilder append(String string) {
        super.append(string);
        return this;
    }

    @Override
    public HtmlBuilder appendIndented(String string) {
        super.appendIndented(string);
        return this;
    }

    @Override
    public HtmlBuilder appendLn(String string) {
        super.appendLn(string);
        return this;
    }

    public HtmlBuilder appendMultipleLines(String string) {
        String string2 = Text.removeLineBreakAtEndIfEndsWith(string);
        List<String> list = Text.splitByLineBreaks(string2);
        return this.appendMultipleLines((List)list);
    }

    @Override
    public HtmlBuilder appendMultipleLines(String ... stringArray) {
        super.appendMultipleLines(stringArray);
        return this;
    }

    @Override
    public HtmlBuilder appendMultipleLines(List<String> list) {
        super.appendMultipleLines(list);
        return this;
    }

    @Override
    public HtmlBuilder append(int n) {
        super.append(n);
        return this;
    }

    @Override
    public HtmlBuilder appendIndented(int n) {
        super.appendIndented(n);
        return this;
    }

    @Override
    public HtmlBuilder appendLineBreak() {
        super.appendLineBreak();
        return this;
    }

    public HtmlBuilder appendHtmlLineBreak() {
        this.append("<br />");
        this.appendLineBreak();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitle(String string) {
        this.appendUpperHeadPartHtml5(string);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleUtf8(String string) {
        this.appendUpperHeadPartHtml5(string);
        this.appendMetaUtf8();
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleAndCssFilename(String string, String string2) {
        this.appendUpperHeadPartHtml5(string);
        this.appendMetaCssFilename(string2);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleCssFilenameAndJavaScript(String string, String string2, String string3) {
        this.appendUpperHeadPartHtml5(string);
        this.appendMetaCssFilename(string2);
        this.appendMultipleLines(string3);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleMultipleCssFilenameAndJavaScript(String string, List<String> list, String string2) {
        this.appendUpperHeadPartHtml5(string);
        for (String string3 : list) {
            this.appendMetaCssFilename(string3);
        }
        this.appendMultipleLines(string2);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleMultipleCssFilenameAndAdditionalLines(String string, List<String> list, List<String> list2) {
        this.appendUpperHeadPartHtml5(string);
        for (String string2 : list) {
            this.appendMetaCssFilename(string2);
        }
        this.appendMultipleLines((List)list2);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleMultipleCssFilenameAndAdditionalLinesUtf8(String string, List<String> list, List<String> list2) {
        this.appendUpperHeadPartHtml5(string);
        this.appendMetaUtf8();
        for (String string2 : list) {
            this.appendMetaCssFilename(string2);
        }
        this.appendMultipleLines((List)list2);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithTitleJavaScriptAndMultipleCssFilenames(String string, String string2, String ... stringArray) {
        this.appendUpperHeadPartHtml5(string);
        for (String string3 : stringArray) {
            this.appendMetaCssFilename(string3);
        }
        this.appendMultipleLines(string2);
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithOwnCss(String string) {
        return this.appendHtml5HeadWithOwnCss(string, CSS);
    }

    public HtmlBuilder appendHtml5HeadWithOwnCssUtf8(String string) {
        return this.appendHtml5HeadWithOwnCssUtf8(string, CSS);
    }

    public HtmlBuilder appendHtml5HeadWithOwnExtendedCss(String string, String string2) {
        String string3 = HtmlBuilder.extendStandardCss(string2);
        return this.appendHtml5HeadWithOwnCss(string, string3);
    }

    public HtmlBuilder appendHtml5HeadWithOwnExtendedCssUtf8(String string, String string2) {
        String string3 = HtmlBuilder.extendStandardCss(string2);
        return this.appendHtml5HeadWithOwnCssUtf8(string, string3);
    }

    static String extendStandardCss(String string) {
        int n = CSS.indexOf("</style>");
        if (-1 == n) {
            throw new RuntimeException("Es wurde kein </style> im Standard-CSS gefunden!");
        }
        return CSS.substring(0, n) + string + HtmlBuilder.n + CSS.substring(n);
    }

    public static String createBodyFontSizeInPointCssExtension(int n) {
        return "    body {" + HtmlBuilder.n + "        font-size:" + n + "pt;" + HtmlBuilder.n + "    }";
    }

    public HtmlBuilder appendHtml5HeadWithOwnCss(String string, String string2) {
        boolean bl = false;
        return this.appendHtml5HeadWithOwnCssInternal(string, bl, string2);
    }

    public HtmlBuilder appendHtml5HeadWithOwnCssUtf8(String string, String string2) {
        boolean bl = true;
        return this.appendHtml5HeadWithOwnCssInternal(string, bl, string2);
    }

    private HtmlBuilder appendHtml5HeadWithOwnCssInternal(String string, boolean bl, String string2) {
        this.appendUpperHeadPartHtml5(string);
        if (bl) {
            this.appendMetaUtf8();
        }
        this.appendMultipleLines(string2);
        this.appendLowerHeadPart();
        return this;
    }

    protected final HtmlBuilder appendUpperHeadPartHtml5(String string) {
        this.appendLn("<!DOCTYPE html>");
        NamedXmlParameter namedXmlParameter = new NamedXmlParameter("lang", "de");
        this.appendOpeningTagWithParameters("html", namedXmlParameter);
        this.appendOpeningTag("head");
        this.appendInTag("title", string);
        return this;
    }

    protected HtmlBuilder appendMetaUtf8() {
        this.appendLn("<meta charset=\"utf-8\">");
        return this;
    }

    private HtmlBuilder appendMetaCssFilename(String string) {
        this.appendLn("<link href=\"" + string + "\" rel=\"stylesheet\" type=\"text/css\" />");
        return this;
    }

    protected final HtmlBuilder appendLowerHeadPart() {
        this.appendClosingTag("head");
        this.appendLineBreak();
        this.appendLineBreak();
        this.appendOpeningTag("body");
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithFormatCssInSameDirectory(String string) {
        boolean bl = false;
        this.appendHtml5HeadWithFormatCssInSameDirectoryInternal(string, bl);
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithFormatCssInSameDirectoryUtf8(String string) {
        boolean bl = true;
        this.appendHtml5HeadWithFormatCssInSameDirectoryInternal(string, bl);
        return this;
    }

    private HtmlBuilder appendHtml5HeadWithFormatCssInSameDirectoryInternal(String string, boolean bl) {
        this.appendUpperHeadPartHtml5(string);
        if (bl) {
            this.appendMetaUtf8();
        }
        this.appendFormatInSameDirectoryCssToHead();
        this.appendLowerHeadPart();
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithFormatCssInUpperDirectory(String string) {
        boolean bl = false;
        this.appendHtml5HeadWithFormatCssInUpperDirectoryInternal(string, bl);
        return this;
    }

    public HtmlBuilder appendHtml5HeadWithFormatCssInUpperDirectoryUtf8(String string) {
        boolean bl = true;
        this.appendHtml5HeadWithFormatCssInUpperDirectoryInternal(string, bl);
        return this;
    }

    private HtmlBuilder appendHtml5HeadWithFormatCssInUpperDirectoryInternal(String string, boolean bl) {
        this.appendUpperHeadPartHtml5(string);
        if (bl) {
            this.appendMetaUtf8();
        }
        this.appendFormatInUpperDirectoryCssToHead();
        this.appendLowerHeadPart();
        return this;
    }

    private HtmlBuilder appendFormatInSameDirectoryCssToHead() {
        this.appendLn("<link href=\"format.css\" rel=\"stylesheet\" type=\"text/css\" />");
        return this;
    }

    private HtmlBuilder appendFormatInUpperDirectoryCssToHead() {
        this.appendLn("<link href=\"../format.css\" rel=\"stylesheet\" type=\"text/css\" />");
        return this;
    }

    public HtmlBuilder appendOpeningDiv() {
        this.appendOpeningTag("div");
        return this;
    }

    public HtmlBuilder appendOpeningDivWithClass(String string) {
        this.appendOpeningTagWithClass("div", string);
        return this;
    }

    public HtmlBuilder appendOpeningDivWithId(String string) {
        this.appendOpeningTagWithId("div", string);
        return this;
    }

    public HtmlBuilder appendOpeningDivWithIdAndClass(String string, String string2) {
        this.appendOpeningTagWithIdAndClass("div", string, string2);
        return this;
    }

    public HtmlBuilder appendClosingDiv() {
        this.appendClosingTag("div");
        return this;
    }

    public HtmlBuilder appendOpeningOl() {
        this.appendOpeningTag("ol");
        return this;
    }

    public HtmlBuilder appendOpeningOlStart(int n) {
        this.appendOpeningTagWithParameters("ol", "start=\"" + n + "\"");
        return this;
    }

    public HtmlBuilder appendClosingOl() {
        this.appendClosingTag("ol");
        return this;
    }

    public HtmlBuilder appendOpeningUl() {
        this.appendOpeningTag("ul");
        return this;
    }

    public HtmlBuilder appendClosingUl() {
        this.appendClosingTag("ul");
        return this;
    }

    public HtmlBuilder appendOpeningLi() {
        this.appendOpeningTag("li");
        return this;
    }

    public HtmlBuilder appendClosingLi() {
        this.appendClosingTag("li");
        return this;
    }

    public HtmlBuilder appendLi(String string) {
        this.appendInTag("li", string);
        return this;
    }

    public HtmlBuilder appendLi(int n) {
        this.appendLi(Integer.toString(n));
        return this;
    }

    public HtmlBuilder appendOpeningTable() {
        this.appendOpeningTag("table");
        return this;
    }

    public HtmlBuilder appendOpeningTableWithBorderWidth(int n) {
        this.appendOpeningTagWithParameters("table", "border=\"" + n + "\"");
        return this;
    }

    public HtmlBuilder appendOpeningTableWithClass(String string) {
        this.appendOpeningTagWithClass("table", string);
        return this;
    }

    public HtmlBuilder appendOpeningTableWithId(String string) {
        this.appendOpeningTagWithId("table", string);
        return this;
    }

    public HtmlBuilder appendClosingTable() {
        this.appendClosingTag("table");
        return this;
    }

    public HtmlBuilder appendOpeningThead() {
        this.appendOpeningTag("thead");
        return this;
    }

    public HtmlBuilder appendClosingThead() {
        this.appendClosingTag("thead");
        return this;
    }

    public HtmlBuilder appendOpeningTbody() {
        this.appendOpeningTag("tbody");
        return this;
    }

    public HtmlBuilder appendClosingTbody() {
        this.appendClosingTag("tbody");
        return this;
    }

    public HtmlBuilder appendOpeningTfoot() {
        this.appendOpeningTag("tfoot");
        return this;
    }

    public HtmlBuilder appendClosingTfoot() {
        this.appendClosingTag("tfoot");
        return this;
    }

    public HtmlBuilder appendOpeningTr() {
        this.appendOpeningTag("tr");
        return this;
    }

    public HtmlBuilder appendOpeningTrWithClass(String string) {
        this.appendOpeningTagWithClass("tr", string);
        return this;
    }

    public HtmlBuilder appendClosingTr() {
        this.appendClosingTag("tr");
        return this;
    }

    public HtmlBuilder appendOpeningTh() {
        this.appendOpeningTag("th");
        return this;
    }

    public HtmlBuilder appendOpeningLeftAlignedTh() {
        this.appendOpeningTagWithParameters("th", "align=\"left\"");
        return this;
    }

    public HtmlBuilder appendClosingTh() {
        this.appendClosingTag("th");
        return this;
    }

    public HtmlBuilder appendTh(String string) {
        this.appendInTag("th", string);
        return this;
    }

    public HtmlBuilder appendTh(String string, String string2) {
        this.appendInTagWithClass("th", string, string2);
        return this;
    }

    public HtmlBuilder appendLeftAlignedTh(String string) {
        this.appendInTagWithParameters("th", string, "align=\"left\"");
        return this;
    }

    public HtmlBuilder appendLeftAlignedThWithClass(String string, String string2) {
        this.appendInTagWithParameters("th", string, "class=\"" + string2 + "\"", "align=\"left\"");
        return this;
    }

    public HtmlBuilder appendRightAlignedTh(String string) {
        this.appendInTagWithParameters("th", string, "align=\"right\"");
        return this;
    }

    public HtmlBuilder appendOpeningTd() {
        this.appendOpeningTag("td");
        return this;
    }

    public HtmlBuilder appendClosingTd() {
        this.appendClosingTag("td");
        return this;
    }

    public HtmlBuilder appendTd(String string) {
        this.appendInTag("td", string);
        return this;
    }

    public HtmlBuilder appendTd(String string, String string2) {
        this.appendInTagWithClass("td", string, string2);
        return this;
    }

    public HtmlBuilder appendRightAlignedTd(String string) {
        this.appendInTagWithParameters("td", string, "align=\"right\"");
        return this;
    }

    public HtmlBuilder appendTd(int n) {
        this.appendTd(Integer.toString(n));
        return this;
    }

    public HtmlBuilder appendHeaderRow(List<String> list) {
        this.appendOpeningTr();
        for (String string : list) {
            this.appendTh(string);
        }
        this.appendClosingTr();
        return this;
    }

    public HtmlBuilder appendHeaderRow(String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        return this.appendHeaderRow(list);
    }

    public HtmlBuilder appendLeftAlignedHeaderRow(List<String> list) {
        this.appendOpeningTr();
        for (String string : list) {
            this.appendLeftAlignedTh(string);
        }
        this.appendClosingTr();
        return this;
    }

    public HtmlBuilder appendLeftAlignedHeaderRow(String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        return this.appendLeftAlignedHeaderRow(list);
    }

    public HtmlBuilder appendDataRow(List<String> list) {
        this.appendOpeningTr();
        for (String string : list) {
            this.appendTd(string);
        }
        this.appendClosingTr();
        return this;
    }

    public HtmlBuilder appendDataRow(String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        return this.appendDataRow(list);
    }

    public HtmlBuilder appendOpeningQuote() {
        this.appendOpeningTag("blockquote");
        return this;
    }

    public HtmlBuilder appendClosingQuote() {
        this.appendClosingTag("blockquote");
        return this;
    }

    public HtmlBuilder appendOpeningBlockquote() {
        return this.appendOpeningQuote();
    }

    public HtmlBuilder appendClosingBlockquote() {
        return this.appendClosingQuote();
    }

    public HtmlBuilder appendH1(String string) {
        ++this.numberOfH1;
        return this.appendHeader(HtmlHeaderType.H1, string);
    }

    public HtmlBuilder appendH2(String string) {
        ++this.numberOfH2;
        return this.appendHeader(HtmlHeaderType.H2, string);
    }

    public HtmlBuilder appendH3(String string) {
        ++this.numberOfH3;
        return this.appendHeader(HtmlHeaderType.H3, string);
    }

    public HtmlBuilder appendH4(String string) {
        ++this.numberOfH4;
        return this.appendHeader(HtmlHeaderType.H4, string);
    }

    public HtmlBuilder appendH5(String string) {
        ++this.numberOfH5;
        return this.appendHeader(HtmlHeaderType.H5, string);
    }

    public HtmlBuilder appendH6(String string) {
        ++this.numberOfH6;
        return this.appendHeader(HtmlHeaderType.H6, string);
    }

    private HtmlBuilder appendHeader(HtmlHeaderType htmlHeaderType, String string) {
        this.appendTopLinkIfNeccessary(htmlHeaderType);
        String string2 = this.generateHeaderId(htmlHeaderType);
        this.appendHeaderAndInsertLineBreakIfNotFirstContent(htmlHeaderType, string, string2);
        String string3 = htmlHeaderType.getHtmlTagName();
        if (this.createContentWithNames) {
            String string4 = "<a name=\"" + string2 + "\"/>";
            String string5 = string4 + string;
            this.appendInTag(string3, string5);
        } else {
            this.appendInTagWithId(string3, string, string2);
        }
        return this;
    }

    protected final void appendHeaderAndInsertLineBreakIfNotFirstContent(HtmlHeaderType htmlHeaderType, String string, String string2) {
        this.headers.add(new HtmlHeader(htmlHeaderType, string, string2));
        if (this.length() != this.getLengthAtLastIncrease()) {
            this.appendLineBreak();
        }
    }

    protected final void appendTopLinkIfNeccessary(HtmlHeaderType htmlHeaderType) {
        if (htmlHeaderType == HtmlHeaderType.H1 && this.numberOfH1 > 1 && this.showTopLink) {
            this.appendToTopLink();
        } else if (htmlHeaderType == HtmlHeaderType.H2 && this.numberOfH2 > 1 && this.showTopLink && this.appendTopLinksToH2) {
            this.appendToTopLink();
        }
    }

    public HtmlBuilder appendToTopLink() {
        this.appendLink("#top", "Zum Seitenanfang");
        return this;
    }

    protected final String generateHeaderId(HtmlHeaderType htmlHeaderType) {
        String string;
        if (htmlHeaderType == HtmlHeaderType.H1) {
            string = "id" + this.numberOfH1;
        } else if (htmlHeaderType == HtmlHeaderType.H2) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2;
        } else if (htmlHeaderType == HtmlHeaderType.H3) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3;
        } else if (htmlHeaderType == HtmlHeaderType.H4) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3 + "_" + this.numberOfH4;
        } else if (htmlHeaderType == HtmlHeaderType.H5) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3 + "_" + this.numberOfH4 + "_" + this.numberOfH5;
        } else if (htmlHeaderType == HtmlHeaderType.H6) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3 + "_" + this.numberOfH4 + "_" + this.numberOfH5 + "_" + this.numberOfH6;
        } else {
            throw new RuntimeException("Unknown header type '" + htmlHeaderType + "'!");
        }
        return string;
    }

    public HtmlBuilder appendLink(String string, String string2) {
        this.appendInTagWithParameters("a", string2, "href=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendLinkWithClass(String string, String string2, String string3) {
        this.appendInTagWithParameters("a", string2, "class=\"" + string3 + "\"", "href=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendLinkWithClassAndScript(String string, String string2, String string3, String string4) {
        this.appendInTagWithParameters("a", string2, "class=\"" + string3 + "\"", "href=\"" + string + "\"", "onclick=\"" + string4 + "\"");
        return this;
    }

    public HtmlBuilder appendLinkWithoutUrlWithClassAndScript(String string, String string2, String string3) {
        this.appendInTagWithParameters("a", string, "class=\"" + string2 + "\"", "onclick=\"" + string3 + "\"");
        return this;
    }

    private HtmlBuilder appendLinkWithoutIndentation(String string, String string2) {
        this.appendInTagWithParametersWithoutIndentation("a", string2, "href=\"" + string + "\"");
        this.appendSpaces();
        this.appendHtmlLineBreak();
        return this;
    }

    public HtmlBuilder appendP(String string) {
        this.appendInTag("p", string);
        return this;
    }

    public HtmlBuilder appendPWithClass(String string, String string2) {
        this.appendInTagWithClass("p", string, string2);
        return this;
    }

    public HtmlBuilder appendOpeningP() {
        this.appendOpeningTag("p");
        return this;
    }

    public HtmlBuilder appendOpeningP(String string) {
        this.appendOpeningTagWithClass("p", string);
        return this;
    }

    public HtmlBuilder appendClosingP() {
        this.appendClosingTag("p");
        return this;
    }

    public HtmlBuilder appendPTT(String string) {
        this.appendInTagWithParameters("p", string, "class=\"monospace\"");
        return this;
    }

    @Override
    public HtmlBuilder appendInTag(String string, String string2) {
        super.appendInTag(string, string2);
        return this;
    }

    protected HtmlBuilder appendInTagWithClass(String string, String string2, String string3) {
        this.appendInTagWithParameters(string, string2, "class=\"" + string3 + "\"");
        return this;
    }

    protected HtmlBuilder appendInTagWithId(String string, String string2, String string3) {
        this.appendInTagWithParameters(string, string2, "id=\"" + string3 + "\"");
        return this;
    }

    protected HtmlBuilder appendInTagWithName(String string, String string2, String string3) {
        this.appendInTagWithParameters(string, string2, "name=\"" + string3 + "\"");
        return this;
    }

    protected HtmlBuilder appendInTagWithParameters(String string, String string2, String ... stringArray) {
        this.appendSpaces();
        this.appendInTagWithParametersWithoutIndentation(string, string2, stringArray);
        return this;
    }

    private HtmlBuilder appendInTagWithParametersWithoutIndentation(String string, String string2, String ... stringArray) {
        this.append("<");
        this.append(string);
        for (String string3 : stringArray) {
            this.append(" ").append(string3);
        }
        this.append(">");
        this.append(string2);
        this.append("</");
        this.append(string);
        this.append(">");
        this.appendLineBreak();
        return this;
    }

    public HtmlBuilder appendInTagWithParametersWithoutText(String string, String ... stringArray) {
        this.appendSpaces();
        this.append("<");
        this.append(string);
        for (String string2 : stringArray) {
            this.append(" ").append(string2);
        }
        this.append("/>");
        this.appendLineBreak();
        return this;
    }

    public HtmlBuilder appendInTagWithoutText(String string) {
        this.appendSpaces();
        this.append("<");
        this.append(string);
        this.append(" />");
        this.appendLineBreak();
        return this;
    }

    public HtmlBuilder appendFoot() {
        this.appendLineBreak();
        if (this.hasContents) {
            this.appendToTopLink();
        }
        this.appendClosingTag("body");
        this.appendClosingTag("html");
        return this;
    }

    public HtmlBuilder appendSeparatoringLine() {
        this.appendP("");
        this.appendP("");
        this.appendLine();
        this.appendP("");
        return this;
    }

    public HtmlBuilder appendLine() {
        this.appendInTagWithoutText("hr");
        return this;
    }

    public HtmlBuilder append(StringBuilder stringBuilder) {
        this.appendMultipleLines(stringBuilder.toString());
        return this;
    }

    public HtmlBuilder append(HtmlBuilder htmlBuilder) {
        this.appendMultipleLines(htmlBuilder.toString());
        return this;
    }

    public HtmlBuilder appendPre(String string) {
        this.appendInTag("pre", string);
        return this;
    }

    public HtmlBuilder appendOpeningPre() {
        this.appendOpeningTag("pre");
        return this;
    }

    public HtmlBuilder appendClosingPre() {
        this.appendClosingTag("pre");
        return this;
    }

    public HtmlBuilder insertContent() {
        boolean bl = false;
        return this.insertContent(bl);
    }

    public HtmlBuilder insertContentWithTopLinkAnker() {
        boolean bl = true;
        return this.insertContent(bl);
    }

    private HtmlBuilder insertContent(boolean bl) {
        String string = "<body>";
        int n = this.indexOf(string);
        if (n == -1) {
            throw new RuntimeException("Kein Body-Tag im Html gefunden!");
        }
        int n2 = n + string.length();
        String string2 = bl ? this.buildContents(bl) : this.buildContents();
        this.insert(n2, string2);
        this.hasContents = true;
        return this;
    }

    public HtmlBuilder insertContentAtEnd() {
        String string = "</body>";
        int n = this.indexOf(string);
        if (n == -1) {
            throw new RuntimeException("Kein schlie\u00dfendes Body-Tag im Html gefunden!");
        }
        this.insert(n, this.buildContents() + "    ");
        this.hasContents = true;
        return this;
    }

    private String buildContents() {
        boolean bl = false;
        return this.buildContents(bl);
    }

    private String buildContents(boolean bl) {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        Object object = "Inhaltsverzeichnis";
        if (bl) {
            object = this.createTopLinkAnker() + (String)object;
        }
        htmlBuilder.createHtmlPartInBody().appendLineBreak().appendInTag("h1", (String)object);
        for (HtmlHeader htmlHeader : this.headers) {
            htmlBuilder.appendIndented(htmlHeader.getContentIndentation()).appendLinkWithoutIndentation("#" + htmlHeader.getId(), htmlHeader.getText());
        }
        return htmlBuilder.toString();
    }

    public HtmlBuilder appendVerticalSpace() {
        this.appendInTag("p", "&nbsp;");
        return this;
    }

    public HtmlBuilder appendOpeningForm(String string, String string2) {
        boolean bl = false;
        return this.appendOpeningFormInternal(string, string2, bl);
    }

    public HtmlBuilder appendOpeningFormOpeningInNewTab(String string, String string2) {
        boolean bl = true;
        return this.appendOpeningFormInternal(string, string2, bl);
    }

    private HtmlBuilder appendOpeningFormInternal(String string, String string2, boolean bl) {
        List<String> list = CollectionsHelper.buildListFrom("name=\"" + string + "\"", "action=\"" + string2 + "\"", "accept-charset=\"UTF-8\"", "method=\"post\"");
        if (bl) {
            list.add("target=\"_blank\"");
        }
        this.appendOpeningTagWithParameters("form", (List)list);
        return this;
    }

    public HtmlBuilder appendOpenNamelessForm(String string, String string2) {
        this.appendOpeningTagWithParameters("form", "class=\"" + string2 + "\"", "action=\"" + string + "\"", "accept-charset=\"UTF-8\"", "method=\"post\"");
        return this;
    }

    public HtmlBuilder appendOpenUpdateForm(String string, String string2) {
        this.appendOpeningTagWithParameters("form", "class=\"" + string2 + "\"", "action=\"" + string + "\"", "accept-charset=\"UTF-8\"", "method=\"post\"", "enctype=\"multipart/form-data\"");
        return this;
    }

    public HtmlBuilder appendClosingForm() {
        this.appendClosingTag("form");
        return this;
    }

    public HtmlBuilder appendOpeningFieldset(String string) {
        this.appendOpeningTag("fieldset");
        this.appendInTag("legend", string);
        return this;
    }

    public HtmlBuilder appendClosingFieldset() {
        this.appendClosingTag("fieldset");
        return this;
    }

    public HtmlBuilder appendButtonWithType(String string, String string2) {
        this.appendInTagWithParameters("button", string2, "type=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendButtonWithTypeAndAdditionalParams(String string, String string2, String ... stringArray) {
        String[] stringArray2 = CollectionsHelper.appendInfrontOfArray("type=\"" + string + "\"", stringArray);
        this.appendInTagWithParameters("button", string2, stringArray2);
        return this;
    }

    public HtmlBuilder appendLabel(String string, String string2) {
        this.appendInTagWithParameters("label", string2, "for=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendLabelWithClass(String string, String string2, String string3) {
        this.appendInTagWithParameters("label", string2, "class=\"" + string3 + "\"", "for=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendInput(String string) {
        this.appendInTagWithParametersWithoutText("input", "id=\"" + string + "\"", "name=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendInputWithClass(String string, String string2) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"");
        return this;
    }

    public HtmlBuilder appendInputWithValue(String string, String string2) {
        this.appendInTagWithParametersWithoutText("input", "id=\"" + string + "\"", "name=\"" + string + "\"", "value=\"" + string2 + "\"");
        return this;
    }

    public HtmlBuilder appendInputWithClassAndValue(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "value=\"" + string3 + "\"");
        return this;
    }

    public HtmlBuilder appendRequiredInputWithClassAndValue(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "value=\"" + string3 + "\"", "required");
        return this;
    }

    public HtmlBuilder appendInputWithClassAndPlaceholder(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "placeholder=\"" + string3 + "\"");
        return this;
    }

    public HtmlBuilder appendRequiredInputWithClassAndPlaceholder(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "placeholder=\"" + string3 + "\"", "required");
        return this;
    }

    public HtmlBuilder appendRequiredInputWithClassPlaceholderAndPattern(String string, String string2, String string3, String string4) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "placeholder=\"" + string3 + "\"", "pattern=\"" + string4 + "\"", "required");
        return this;
    }

    public HtmlBuilder appendPasswordInputWithClassPlaceholderAndMinLength(String string, String string2, String string3, int n) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "type=\"password\"", "placeholder=\"" + string3 + "\"", "minlength=\"" + n + "\"");
        return this;
    }

    public HtmlBuilder appendRequiredPasswordInputWithClassPlaceholderAndMinLength(String string, String string2, String string3, int n) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "type=\"password\"", "placeholder=\"" + string3 + "\"", "minlength=\"" + n + "\"", "required");
        return this;
    }

    public HtmlBuilder appendEmailInputWithClassPlaceholder(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "type=\"email\"", "placeholder=\"" + string3 + "\"");
        return this;
    }

    public HtmlBuilder appendRequiredEmailInputWithClassAndPlaceholder(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "type=\"email\"", "placeholder=\"" + string3 + "\"", "required");
        return this;
    }

    public HtmlBuilder appendRequiredEmailInputWithClassAndValue(String string, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "class=\"" + string2 + "\"", "id=\"" + string + "\"", "name=\"" + string + "\"", "type=\"email\"", "value=\"" + string3 + "\"", "required");
        return this;
    }

    public HtmlBuilder appendInputCheckbox(String string, boolean bl) {
        String[] stringArray = new String[]{"id=\"" + string + "\"", "type=\"checkbox\"", "name=\"" + string + "\""};
        if (bl) {
            stringArray = CollectionsHelper.appendAtEndOfArray(stringArray, "checked");
        }
        this.appendInTagWithParametersWithoutText("input", stringArray);
        return this;
    }

    public HtmlBuilder appendInputCheckboxWithOnClickScript(String string, boolean bl, String string2) {
        String[] stringArray = new String[]{"id=\"" + string + "\"", "type=\"checkbox\"", "name=\"" + string + "\"", "onclick=\"javascript: " + string2 + "\""};
        if (bl) {
            stringArray = CollectionsHelper.appendAtEndOfArray(stringArray, "checked");
        }
        this.appendInTagWithParametersWithoutText("input", stringArray);
        return this;
    }

    public HtmlBuilder appendInputRadioButton(String string, String string2, boolean bl) {
        String[] stringArray = new String[]{"id=\"" + string + "\"", "type=\"radio\"", "name=\"" + string2 + "\"", "value=\"" + string + "\""};
        if (bl) {
            stringArray = CollectionsHelper.appendAtEndOfArray(stringArray, "checked");
        }
        this.appendInTagWithParametersWithoutText("input", stringArray);
        return this;
    }

    public HtmlBuilder appendLabelAndSpinner(String string, String string2, int n, int n2, int n3, String string3, String string4, String string5) {
        this.appendOpeningP();
        this.appendLabelWithClass(string, string2, string4);
        this.appendSpinner(string, n, n2, n3, string3, string5);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendSpinner(String string, int n, int n2, int n3, String string2, String string3) {
        this.appendInTagWithParametersWithoutText("input", "id=\"" + string + "\"", "type=\"number\"", "name=\"" + string + "\"", "min=\"" + n + "\"", "max=\"" + n2 + "\"", "step=\"" + n3 + "\"", "value=\"" + string2 + "\"", "class=\"" + string3 + "\"");
        return this;
    }

    public HtmlBuilder appendHiddenField(String string, String string2) {
        this.appendInTagWithParametersWithoutText("input", "type=\"hidden\"", "name=\"" + string + "\"", "value=\"" + string2 + "\"");
        return this;
    }

    public HtmlBuilder appendReallyClearFieldsOfFormButton(String string, String string2) {
        return this.appendReallyClearFieldsOfFormButton(string, string2, new ArrayList<String>());
    }

    public HtmlBuilder appendReallyClearFieldsOfFormButton(String string, String string2, String ... stringArray) {
        return this.appendReallyClearFieldsOfFormButton(string, string2, CollectionsHelper.stringArrayToList(stringArray));
    }

    public HtmlBuilder appendReallyClearFieldsOfFormButton(String string, String string2, List<String> list) {
        List<String> list2 = this.generateReallyClearFieldsScriptStart();
        list2.addAll(this.generateReallyClearFieldsScriptPart(list));
        list2.addAll(this.generateReallyClearFieldsScriptEnd());
        this.appendMultipleLines((List)list2);
        this.appendButtonWithTypeAndAdditionalParams("button", "Felder leeren", "name=\"" + string + "\"", "onClick=\"clearAllFieldsInFirstForm(" + string2 + ")\"");
        return this;
    }

    private List<String> generateReallyClearFieldsScriptStart() {
        return CollectionsHelper.buildListFrom("<script>", "    function clearAllFieldsInFirstForm(form) {", "        for (i = 0; i < form.elements.length; ++i) {");
    }

    private List<String> generateReallyClearFieldsScriptPart(List<String> list) {
        List<String> list2 = CollectionsHelper.buildListFrom("            if (form.elements[i].type == 'text'", "                    || form.elements[i].type == 'textarea') {");
        if (list.isEmpty()) {
            list2.add("                form.elements[i].value = '';");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("form.elements[i].id != '" + list.get(0) + "'");
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder.append(Text.LINE_BREAK).append("                                && ").append("form.elements[i].id != '" + list.get(i) + "'");
            }
            String string = stringBuilder.toString();
            list2.add("                if (" + string + ") {");
            list2.add("                    form.elements[i].value = '';");
            list2.add("                }");
        }
        list2.add("            }");
        return list2;
    }

    private List<String> generateReallyClearFieldsScriptEnd() {
        return CollectionsHelper.buildListFrom("        }", "    }", "</script>");
    }

    public HtmlBuilder appendReallyClearFieldsAndCheckbuttonsOfFormButton(String string, String string2, List<String> list, List<String> list2) {
        List<String> list3 = this.generateReallyClearFieldsScriptStart();
        list3.addAll(this.generateReallyClearFieldsScriptPart(list2));
        list3.addAll(this.generateReallyClearCheckboxesScriptPart(list));
        list3.addAll(this.generateReallyClearFieldsScriptEnd());
        this.appendMultipleLines((List)list3);
        this.appendButtonWithTypeAndAdditionalParams("button", "Felder leeren", "name=\"" + string + "\"", "onClick=\"clearAllFieldsInFirstForm(" + string2 + ")\"");
        return this;
    }

    private List<String> generateReallyClearCheckboxesScriptPart(List<String> list) {
        if (list.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> list2 = CollectionsHelper.buildListFrom("            if (form.elements[i].type == 'checkbox') {");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form.elements[i].id == '" + list.get(0) + "'");
        for (int i = 1; i < list.size(); ++i) {
            stringBuilder.append(Text.LINE_BREAK).append("                                || ").append("form.elements[i].id == '" + list.get(i) + "'");
        }
        String string = stringBuilder.toString();
        list2.add("                if (" + string + ") {");
        list2.add("                    form.elements[i].checked = false;");
        list2.add("                }");
        list2.add("            }");
        return list2;
    }

    public HtmlBuilder appendLabelAndInput(String string, String string2) {
        this.appendOpeningP();
        this.appendLabel(string, string2);
        this.appendInput(string);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendLabelAndInputWithValue(String string, String string2, String string3) {
        this.appendOpeningP();
        this.appendLabel(string, string2);
        this.appendInputWithValue(string, string3);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendLabelAndCheckBox(String string, String string2, boolean bl, String string3) {
        this.appendOpeningP();
        this.appendLabelWithClass(string, string2, string3);
        this.appendInputCheckbox(string, bl);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendLabelAndCheckBoxWithOnClickScript(String string, String string2, boolean bl, String string3, String string4) {
        this.appendOpeningP();
        this.appendLabelWithClass(string, string2, string4);
        this.appendInputCheckboxWithOnClickScript(string, bl, string3);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendLabelAndRadioButton(String string, String string2, String string3, boolean bl, String string4) {
        this.appendOpeningP();
        this.appendLabelWithClass(string, string3, string4);
        this.appendInputRadioButton(string, string2, bl);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendFormButtons(String string) {
        this.appendOpeningP();
        this.appendButtonWithType("reset", "Eingaben zur\u00fccksetzen");
        this.appendButtonWithType("submit", string);
        this.appendClosingP();
        return this;
    }

    public HtmlBuilder appendFocusSettingJavaScript(String string) {
        this.appendMultipleLines("<script>", "    document.getElementById(\"" + string + "\").focus();", "</script>");
        return this;
    }

    public HtmlBuilder appendPasswordVerificationJavaScript(String string, String string2) {
        this.appendMultipleLines("<script>", "    var password1 = document.getElementById('" + string + "');", "    var password2 = document.getElementById('" + string2 + "');", "    var checkPasswordValidity = function () {", "        if (password1.value != password2.value) {", "            password2.setCustomValidity('Passw\u00f6rter m\u00fcssen \u00fcbereinstimmen!');", "        }", "        else {", "            password2.setCustomValidity('');", "        }", "    };", "    password1.addEventListener('change', checkPasswordValidity);", "    password2.addEventListener('change', checkPasswordValidity);", "</script>");
        return this;
    }

    public HtmlBuilder appendSendPostJavaScript() {
        this.appendMultipleLines("<script>", "    function post(path, params, method) {", "        method = method || \"POST\"; // Set method to post by default if not specified.", "", "        var form = document.createElement(\"form\");", "        form.setAttribute(\"method\", method);", "        form.setAttribute(\"action\", path);", "        /*", "         * Es geht hier auch", "         *     form.setAttribute(\"target\", \"_blank\");", "         * um die neue Seite in einem eigenen Tab anzuzeigen.", "         */", "", "        for (var key in params) {", "            if (params.hasOwnProperty(key)) {", "                var hiddenField = document.createElement(\"input\");", "                hiddenField.setAttribute(\"type\", \"hidden\");", "                hiddenField.setAttribute(\"name\", key);", "                hiddenField.setAttribute(\"value\", params[key]);", "", "                form.appendChild(hiddenField);", "            }", "        }", "", "        document.body.appendChild(form);", "        form.submit();", "    }", "</script>");
        return this;
    }

    public HtmlBuilder appendTableSortingJavaScript(String string) {
        this.appendMultipleLines("<script>", "    \"use strict\";", "    var tableSort = function (tab) {", "            var titel = tab.getElementsByTagName(\"thead\")[0]", "                    .getElementsByTagName(\"tr\")[0].getElementsByTagName(\"th\");", "            var tbdy = tab.getElementsByTagName(\"tbody\")[0];", "            var tz = tbdy.rows;", "            var nzeilen = tz.length;", "            if (nzeilen == 0) {", "                return;", "            }", "            var nspalten = tz[0].cells.length;", "            var arr = new Array(nzeilen);", "            var sortiert = -1;", "            var sorttype = new Array(nspalten);", "            var sortbuttonStyle = document.createElement('style'); // Stylesheet f\u00fcr Button im TH", "            sortbuttonStyle.innerText =", "                '.sortbutton { width:100%; height:100%; border: none; background-color: transparent; font: inherit; color: inherit; text-align: inherit; padding: 0; cursor: pointer; } .sortbutton::-moz-focus-inner { margin: -1px; border-width: 1px; padding: 0; }';", "            document.head.appendChild(sortbuttonStyle);", "            var initTableHead = function (sp) { // Kopfzeile vorbereiten", "                var b = document.createElement(\"button\");", "                b.type = \"button\";", "                b.className = \"sortbutton\";", "                b.innerHTML = titel[sp].innerHTML;", "                b.addEventListener(\"click\", function () {", "                    tsort(sp);", "                }, false);", "                titel[sp].innerHTML = \"\";", "                titel[sp].appendChild(b);", "            }", "            var getData = function (ele, s) {", "                    var val = ele.textContent; // Nicht im IE8", "                    if (!isNaN(val) && val.search(/[0-9]/) != -1) return val;", "                    var n = val.replace(\",\", \".\");", "                    if (!isNaN(n) && n.search(/[0-9]/) != -1) return n;", "                    sorttype[s] = \"s\"; // String", "                    return val;", "                } // getData", "            var vglFkt_s = function (a, b) {", "                    var as = a[sortiert],", "                        bs = b[sortiert];", "                    if (as > bs) {", "                        return 1;", "                    }", "                    else {", "                        return -1;", "                    }", "                } // vglFkt_s", "            var vglFkt_n = function (a, b) {", "                    return parseFloat(a[sortiert]) - parseFloat(b[sortiert]);", "                } // vglFkt_n", "            var tsort = function (sp) {", "                    if (sp == sortiert) {", "                        // Tabelle ist schon nach dieser Spalte sortiert, also", "                        // nur Reihenfolge umdrehen:", "                        arr.reverse();", "                    }", "                    else { // Sortieren", "                        sortiert = sp;", "                        if (sorttype[sp] == \"n\") {", "                            arr.sort(vglFkt_n);", "                        }", "                        else {", "                            arr.sort(vglFkt_s);", "                        }", "                    }", "                    for (var z = 0; z < nzeilen; z++) {", "                        tbdy.appendChild(arr[z][nspalten]); // Sortierte Daten zur\u00fcckschreiben", "                    }", "                } // tsort", "            // Kopfzeile vorbereiten", "            for (var i = 0; i < titel.length; i++) {", "                initTableHead(i);", "            }", "            // Array mit Info, wie Spalte zu sortieren ist, vorbelegen", "            for (var s = 0; s < nspalten; s++) {", "                sorttype[s] = \"n\";", "            }", "            // Tabelleninhalt in ein Array kopieren", "            for (var z = 0; z < nzeilen; z++) {", "                var zelle = tz[z].getElementsByTagName(\"td\"); // cells;", "                arr[z] = new Array(nspalten + 1);", "                arr[z][nspalten] = tz[z];", "                for (var s = 0; s < nspalten; s++) {", "                    var zi = getData(zelle[s], s);", "                    arr[z][s] = zi;", "                    // zelle[s].innerHTML += \"<br>\"+zi+\"<br>\"+sorttype[s]; // zum Debuggen", "                }", "            }", "        } // tableSort", "    var initTableSort = function () {", "            var sort_Table = document.querySelectorAll(\"table#" + string + "\");", "            for (var i = 0; i < sort_Table.length; i++) {", "                new tableSort(sort_Table[i]);", "            }", "        } // initTable", "    if (window.addEventListener) {", "        window.addEventListener(\"DOMContentLoaded\", initTableSort, false); // nicht im IE8", "    }", "</script>");
        return this;
    }

    public HtmlBuilder appendTableSortingJavaScriptWithRowBackgroundColorAdjustment(String string, String string2, String string3, String string4) {
        this.appendMultipleLines("<script>", "    \"use strict\";", "    var tableSort = function (tab) {", "            var titel = tab.getElementsByTagName(\"thead\")[0]", "                    .getElementsByTagName(\"tr\")[0].getElementsByTagName(\"th\");", "", "            var hupIndex = -1;", "            for (var t = 0; t < titel.length; t++) {", "                var tinner = titel[t];", "                var tinnerX = tinner.innerHTML;", "                if (0 == tinnerX.localeCompare(\"" + string2 + "\")) {", "                    hupIndex = t;", "                }", "            }", "", "            var tbdy = tab.getElementsByTagName(\"tbody\")[0];", "            var tz = tbdy.rows;", "            var nzeilen = tz.length;", "            if (nzeilen == 0) {", "                return;", "            }", "            var nspalten = tz[0].cells.length;", "            var arr = new Array(nzeilen);", "            var sortiert = -1;", "            var sorttype = new Array(nspalten);", "            var sortbuttonStyle = document.createElement('style'); // Stylesheet f\u00fcr Button im TH", "            sortbuttonStyle.innerText =", "                '.sortbutton { width:100%; height:100%; border: none; background-color: transparent; font: inherit; color: inherit; text-align: inherit; padding: 0; cursor: pointer; } .sortbutton::-moz-focus-inner { margin: -1px; border-width: 1px; padding: 0; }';", "            document.head.appendChild(sortbuttonStyle);", "            var initTableHead = function (sp) { // Kopfzeile vorbereiten", "                var b = document.createElement(\"button\");", "                b.type = \"button\";", "                b.className = \"sortbutton\";", "                b.innerHTML = titel[sp].innerHTML;", "                b.addEventListener(\"click\", function () {", "                    tsort(sp);", "                }, false);", "                titel[sp].innerHTML = \"\";", "                titel[sp].appendChild(b);", "            }", "            var getData = function (ele, s) {", "                    var val = ele.textContent; // Nicht im IE8", "                    if (!isNaN(val) && val.search(/[0-9]/) != -1) return val;", "                    var n = val.replace(\",\", \".\");", "                    if (!isNaN(n) && n.search(/[0-9]/) != -1) return n;", "                    sorttype[s] = \"s\"; // String", "                    return val;", "                } // getData", "            var vglFkt_s = function (a, b) {", "                    var as = a[sortiert],", "                        bs = b[sortiert];", "                    if (as > bs) {", "                        return 1;", "                    }", "                    else {", "                        return -1;", "                    }", "                } // vglFkt_s", "            var vglFkt_n = function (a, b) {", "                    return parseFloat(a[sortiert]) - parseFloat(b[sortiert]);", "                } // vglFkt_n", "            var tsort = function (sp) {", "                    if (sp == sortiert) {", "                        // Tabelle ist schon nach dieser Spalte sortiert, also", "                        // nur Reihenfolge umdrehen:", "                        arr.reverse();", "                    }", "                    else { // Sortieren", "                        sortiert = sp;", "                        if (sorttype[sp] == \"n\") {", "                            arr.sort(vglFkt_n);", "                        }", "                        else {", "                            arr.sort(vglFkt_s);", "                        }", "                    }", "                    for (var z = 0; z < nzeilen; z++) {", "                        tbdy.appendChild(arr[z][nspalten]); // Sortierte Daten zur\u00fcckschreiben", "                    }", "", "                    if (-1 < hupIndex) {", "                        var oldHup = \"\";", "                        var rowClass = \"" + string3 + "\";", "                        for (var z = 0; z < nzeilen; z++) {", "                            var row = tz[z];", "                            var hupCell = row.cells[hupIndex];", "                            var hup = hupCell.innerHTML;", "", "                            var classList = row.classList;", "                            if (classList.contains(\"" + string4 + "\")) {", "                                classList.remove(\"" + string4 + "\");", "                            }", "                            if (classList.contains(\"" + string3 + "\")) {", "                                classList.remove(\"" + string3 + "\");", "                            }", "", "                            //console.log(\"z=\", z, \", hup=\", hup, \", oldHup=\", oldHup, \", diff=\", hup.localeCompare(oldHup));", "                            if (0 != hup.localeCompare(oldHup)) {", "                                if (0 == rowClass.localeCompare(\"" + string3 + "\")) {", "                                    rowClass = \"" + string4 + "\";", "                                }", "                                else {", "                                    rowClass = \"" + string3 + "\";", "                                }", "                            }", "                            classList.add(rowClass);", "                            oldHup = hup;", "                        }", "                    }", "", "                } // tsort", "            // Kopfzeile vorbereiten", "            for (var i = 0; i < titel.length; i++) {", "                initTableHead(i);", "            }", "            // Array mit Info, wie Spalte zu sortieren ist, vorbelegen", "            for (var s = 0; s < nspalten; s++) {", "                sorttype[s] = \"n\";", "            }", "            // Tabelleninhalt in ein Array kopieren", "            for (var z = 0; z < nzeilen; z++) {", "                var zelle = tz[z].getElementsByTagName(\"td\"); // cells;", "                arr[z] = new Array(nspalten + 1);", "                arr[z][nspalten] = tz[z];", "                for (var s = 0; s < nspalten; s++) {", "                    var zi = getData(zelle[s], s);", "                    arr[z][s] = zi;", "                    // zelle[s].innerHTML += \"<br>\"+zi+\"<br>\"+sorttype[s]; // zum Debuggen", "                }", "            }", "        } // tableSort", "    var initTableSort = function () {", "            var sort_Table = document.querySelectorAll(\"table#" + string + "\");", "            for (var i = 0; i < sort_Table.length; i++) {", "                new tableSort(sort_Table[i]);", "            }", "        } // initTable", "    if (window.addEventListener) {", "        window.addEventListener(\"DOMContentLoaded\", initTableSort, false); // nicht im IE8", "    }", "</script>");
        return this;
    }

    @Override
    public HtmlBuilder appendOpeningTag(String string) {
        super.appendOpeningTag(string);
        return this;
    }

    public HtmlBuilder appendOpeningTagWithClass(String string, String string2) {
        this.appendLn("<" + string + " class=\"" + string2 + "\">");
        this.increaseIndentationLevel();
        return this;
    }

    public HtmlBuilder appendOpeningTagWithId(String string, String string2) {
        this.appendLn("<" + string + " id=\"" + string2 + "\">");
        this.increaseIndentationLevel();
        return this;
    }

    public HtmlBuilder appendOpeningTagWithIdAndClass(String string, String string2, String string3) {
        this.appendLn("<" + string + " id=\"" + string2 + "\" class=\"" + string3 + "\">");
        this.increaseIndentationLevel();
        return this;
    }

    @Override
    public HtmlBuilder appendOpeningTagWithParameters(String string, String ... stringArray) {
        super.appendOpeningTagWithParameters(string, stringArray);
        return this;
    }

    @Override
    public HtmlBuilder appendOpeningTagWithParameters(String string, List<String> list) {
        super.appendOpeningTagWithParameters(string, list);
        return this;
    }

    @Override
    public HtmlBuilder appendClosingTag(String string) {
        super.appendClosingTag(string);
        return this;
    }

    public HtmlBuilder appendSpanWithClass(String string, String string2) {
        this.appendInTagWithClass("span", string, string2);
        return this;
    }

    public HtmlBuilder appendSpanWithId(String string, String string2) {
        this.appendInTagWithId("span", string, string2);
        return this;
    }

    public HtmlBuilder appendOpeningSpan() {
        this.appendOpeningTag("span");
        return this;
    }

    public HtmlBuilder appendOpeningSpanWithId(String string) {
        this.appendOpeningTagWithId("span", string);
        return this;
    }

    public HtmlBuilder appendOpeningSpanWithClass(String string) {
        this.appendOpeningTagWithClass("span", string);
        return this;
    }

    public HtmlBuilder appendOpeningSpanWithIdAndClass(String string, String string2) {
        this.appendOpeningTagWithIdAndClass("span", string, string2);
        return this;
    }

    public HtmlBuilder appendClosingSpan() {
        this.appendClosingTag("span");
        return this;
    }

    public HtmlBuilder appendOpeningHeader() {
        this.appendOpeningTag("header");
        return this;
    }

    public HtmlBuilder appendClosingHeader() {
        this.appendClosingTag("header");
        return this;
    }

    public HtmlBuilder appendOpeningMain() {
        this.appendOpeningTag("main");
        return this;
    }

    public HtmlBuilder appendClosingMain() {
        this.appendClosingTag("main");
        return this;
    }

    public HtmlBuilder appendOpeningFooter() {
        this.appendOpeningTag("footer");
        return this;
    }

    public HtmlBuilder appendClosingFooter() {
        this.appendClosingTag("footer");
        return this;
    }

    public HtmlBuilder appendFrameWithSource(String string) {
        String string2 = string.replace("'", "\"");
        this.appendIndented("<");
        this.append("iframe");
        this.append(" ").append("srcdoc='");
        this.appendLineBreak();
        this.increaseIndentationLevel();
        this.increaseIndentationLevel();
        this.appendMultipleLines(string2);
        this.decreaseIndentationLevel();
        this.appendIndented("' ").append("sandbox=\"\"");
        this.append(">");
        this.appendLineBreak();
        this.appendClosingTag("iframe");
        return this;
    }

    public HtmlBuilder appendFrameWithSource(String string, String string2) {
        String string3 = string2.replace("'", "\"");
        this.appendIndented("<");
        this.append("iframe");
        this.append(" ").append("class=\"").append(string).append("\"");
        this.append(" ").append("srcdoc='");
        this.appendLineBreak();
        this.increaseIndentationLevel();
        this.increaseIndentationLevel();
        this.appendMultipleLines(string3);
        this.decreaseIndentationLevel();
        this.appendIndented("' ").append("sandbox=\"\"");
        this.append(">");
        this.appendLineBreak();
        this.appendClosingTag("iframe");
        return this;
    }

    public HtmlBuilder appendOnRowClickJavaScript() {
        this.appendMultipleLines("<script>", "    function onRowClick(tableId, callback) {", "        var table = document.getElementById(tableId);", "        var rows = table.getElementsByTagName(\"tr\");", "        for (var index = 0; index < rows.length; index++) {", "            var rowTable = function (row) {", "                return function () {", "                    callback(row);", "                };", "            };", "            table.rows[index].onclick = rowTable(table.rows[index]);", "        }", "    };", "</script>");
        return this;
    }

    public HtmlBuilder appendSwitchMaximumHitsFieldJavaScript() {
        this.appendMultipleLines("<script>", "    function switch_maximum_hits_field(idMaxHits, idCheckBox) {", "        inputField = document.getElementById(idMaxHits);", "        checkbox = document.getElementById(idCheckBox);", "        if (checkbox.checked) {", "            inputField.disabled = true;", "        }", "        else {", "            inputField.disabled = false;", "        }", "    }", "</script>");
        return this;
    }

    public HtmlBuilder createAnchor(String string) {
        this.appendMultipleLines("<a name=\"" + string + "\"/>");
        return this;
    }

    public HtmlBuilder appendTopLinksToH2() {
        this.appendTopLinksToH2 = true;
        return this;
    }

    public HtmlBuilder appendTopAnker() {
        String string = "<p>" + this.createTopLinkAnker() + "</p>";
        this.appendIndented(string);
        return this;
    }

    private String createTopLinkAnker() {
        return "<a name=\"top\"/>";
    }
}

