/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.zzzunused.text.html.generation;

import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.basics.text.html.generation.HtmlHeader;
import de.duehl.basics.text.html.generation.HtmlHeaderType;
import java.util.ArrayList;
import java.util.List;

public class ManualIndentationHtmlBuilder {
    protected final StringBuilder builder = new StringBuilder();
    private int numberOfH1 = 0;
    private int numberOfH2 = 0;
    private int numberOfH3 = 0;
    private int numberOfH4 = 0;
    private int numberOfH5 = 0;
    private int numberOfH6 = 0;
    private List<HtmlHeader> headers = new ArrayList<HtmlHeader>();
    private boolean hasContents = false;

    public ManualIndentationHtmlBuilder clear() {
        this.builder.setLength(0);
        return this;
    }

    public ManualIndentationHtmlBuilder appendHeadWithOwnCss(String string) {
        boolean bl = false;
        this.appendHeadWithOwnCssInternal(string, bl);
        return this;
    }

    public ManualIndentationHtmlBuilder appendHeadWithOwnCssUtf8(String string) {
        boolean bl = true;
        this.appendHeadWithOwnCssInternal(string, bl);
        return this;
    }

    private ManualIndentationHtmlBuilder appendHeadWithOwnCssInternal(String string, boolean bl) {
        this.appendUpperHeadPart(string);
        if (bl) {
            this.appendMetaUtf8();
        }
        this.appendOwnCssToHead();
        this.appendLowerHeadPart();
        return this;
    }

    public ManualIndentationHtmlBuilder appendHeadWithFormatCssInSameDirectory(String string) {
        boolean bl = false;
        this.appendHeadWithFormatCssInSameDirectoryInternal(string, bl);
        return this;
    }

    public ManualIndentationHtmlBuilder appendHeadWithFormatCssInSameDirectoryUtf8(String string) {
        boolean bl = true;
        this.appendHeadWithFormatCssInSameDirectoryInternal(string, bl);
        return this;
    }

    private ManualIndentationHtmlBuilder appendHeadWithFormatCssInSameDirectoryInternal(String string, boolean bl) {
        this.appendUpperHeadPart(string);
        if (bl) {
            this.appendMetaUtf8();
        }
        this.appendFormatInSameDirectoryCssToHead();
        this.appendLowerHeadPart();
        return this;
    }

    public ManualIndentationHtmlBuilder appendHeadWithFormatCssInUpperDirectory(String string) {
        boolean bl = false;
        this.appendHeadWithFormatCssInUpperDirectoryInternal(string, bl);
        return this;
    }

    public ManualIndentationHtmlBuilder appendHeadWithFormatCssInUpperDirectoryUtf8(String string) {
        boolean bl = true;
        this.appendHeadWithFormatCssInUpperDirectoryInternal(string, bl);
        return this;
    }

    private ManualIndentationHtmlBuilder appendHeadWithFormatCssInUpperDirectoryInternal(String string, boolean bl) {
        this.appendUpperHeadPart(string);
        if (bl) {
            this.appendMetaUtf8();
        }
        this.appendFormatInUpperDirectoryCssToHead();
        this.appendLowerHeadPart();
        return this;
    }

    private ManualIndentationHtmlBuilder appendUpperHeadPart(String string) {
        this.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" ");
        this.appendLn("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        this.appendLineBreak();
        this.appendLn("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"de\" lang=\"de\">");
        this.appendLn("<head>");
        this.appendLn("    <title>" + string + "</title>");
        return this;
    }

    public ManualIndentationHtmlBuilder appendHtml5HeadWithTitle(String string) {
        this.appendUpperHeadPartHtml5(string);
        this.appendLowerHeadPart();
        return this;
    }

    public ManualIndentationHtmlBuilder appendHtml5HeadWithTitleAndCssFilename(String string, String string2) {
        this.appendUpperHeadPartHtml5(string);
        this.appendMetaCssFilename(string2);
        this.appendLowerHeadPart();
        return this;
    }

    public ManualIndentationHtmlBuilder appendHtml5HeadWithTitleCssFilenameAndJavaScript(String string, String string2, String string3) {
        this.appendUpperHeadPartHtml5(string);
        this.appendMetaCssFilename(string2);
        this.append(string3);
        this.appendLowerHeadPart();
        return this;
    }

    public ManualIndentationHtmlBuilder appendHtml5HeadWithTitleMultipleCssFilenameAndJavaScript(String string, List<String> list, String string2) {
        this.appendUpperHeadPartHtml5(string);
        for (String string3 : list) {
            this.appendMetaCssFilename(string3);
        }
        this.append(string2);
        this.appendLowerHeadPart();
        return this;
    }

    public ManualIndentationHtmlBuilder appendHtml5HeadWithTitleJavaScriptAndMultipleCssFilenames(String string, String string2, String ... stringArray) {
        this.appendUpperHeadPartHtml5(string);
        for (String string3 : stringArray) {
            this.appendMetaCssFilename(string3);
        }
        this.append(string2);
        this.appendLowerHeadPart();
        return this;
    }

    private ManualIndentationHtmlBuilder appendUpperHeadPartHtml5(String string) {
        this.appendLn("<!DOCTYPE html>");
        this.appendLn("<html>");
        this.appendLn("<head>");
        this.appendLn("    <title>" + string + "</title>");
        return this;
    }

    private ManualIndentationHtmlBuilder appendMetaUtf8() {
        this.appendLn("        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        return this;
    }

    private ManualIndentationHtmlBuilder appendMetaCssFilename(String string) {
        this.appendLn("        <link href=\"" + string + "\" rel=\"stylesheet\" type=\"text/css\" />");
        return this;
    }

    private ManualIndentationHtmlBuilder appendLowerHeadPart() {
        this.appendLn("</head>");
        this.appendLineBreak();
        this.appendLineBreak();
        this.appendLn("<body>");
        return this;
    }

    private ManualIndentationHtmlBuilder appendOwnCssToHead() {
        this.appendLn("    <style>");
        this.appendLn("        body {");
        this.appendLn("               background-color:#E6E6FF;");
        this.appendLn("               color:#000096;");
        this.appendLn("               font-family:Verdana, sans-serif;");
        this.appendLn("               font-size:14pt;");
        this.appendLn("               margin-left:3%;");
        this.appendLn("               margin-right:3%;");
        this.appendLn("               color:#000096;");
        this.appendLn("             }");
        this.appendLn("        p    {");
        this.appendLn("               font-size:1em;");
        this.appendLn("               font-family:Verdana, sans-serif;");
        this.appendLn("               color:#000096;");
        this.appendLn("             }");
        this.appendLn("        h1   {");
        this.appendLn("               text-align: left;");
        this.appendLn("               font-size: 36pt;");
        this.appendLn("               font-weight: bold;");
        this.appendLn("               color:#000096;");
        this.appendLn("             }");
        this.appendLn("        h2   {");
        this.appendLn("               text-align: left;");
        this.appendLn("               font-size: 24pt;");
        this.appendLn("               font-weight: bold;");
        this.appendLn("               color:#000096;");
        this.appendLn("               margin-bottom:8;");
        this.appendLn("               margin-top:15;");
        this.appendLn("             }");
        this.appendLn("        h3   {");
        this.appendLn("               font-size: 20pt;");
        this.appendLn("               color:#000096;");
        this.appendLn("               margin-bottom:0;");
        this.appendLn("             }");
        this.appendLn("        h4   {");
        this.appendLn("               font-size: 18pt;");
        this.appendLn("               color:#000096;");
        this.appendLn("               margin-bottom:0;");
        this.appendLn("             }");
        this.appendLn("        h5   {");
        this.appendLn("               font-size: 16pt;");
        this.appendLn("               color:#000096;");
        this.appendLn("               margin-bottom:0;");
        this.appendLn("             }");
        this.appendLn("        h6   {");
        this.appendLn("               font-size: 15pt;");
        this.appendLn("               color:#000096;");
        this.appendLn("               margin-bottom:0;");
        this.appendLn("             }");
        this.appendLn("        .monospace { font-family: monospace; }");
        this.appendLn("    </style>");
        this.appendLineBreak();
        return this;
    }

    private ManualIndentationHtmlBuilder appendFormatInSameDirectoryCssToHead() {
        this.appendLn("    <link href=\"format.css\" rel=\"stylesheet\" type=\"text/css\" />");
        return this;
    }

    private ManualIndentationHtmlBuilder appendFormatInUpperDirectoryCssToHead() {
        this.appendLn("    <link href=\"./format.css\" rel=\"stylesheet\" type=\"text/css\" />");
        return this;
    }

    public ManualIndentationHtmlBuilder append(String string) {
        this.builder.append(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendLn(String string) {
        this.append(string);
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendLn(int n, String string) {
        this.appendSpaces(n);
        return this.appendLn(string);
    }

    public ManualIndentationHtmlBuilder append(int n) {
        this.builder.append(Integer.toString(n));
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningDiv() {
        this.append("<div>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningDiv(int n) {
        this.appendSpaces(n);
        this.appendOpeningDiv();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningDiv(String string) {
        this.append("<div class=\"" + string + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningDiv(int n, String string) {
        this.appendSpaces(n);
        this.appendOpeningDiv(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingDiv() {
        this.append("</div>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingDiv(int n) {
        this.appendSpaces(n);
        this.appendClosingDiv();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningOl() {
        this.append("<ol>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningOl(int n) {
        this.appendSpaces(n);
        this.appendOpeningOl();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningOlStart(int n) {
        this.append("<ol start=\"" + n + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningOlStart(int n, int n2) {
        this.appendSpaces(n);
        this.appendOpeningOlStart(n2);
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingOl() {
        this.append("</ol>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingOl(int n) {
        this.appendSpaces(n);
        this.appendClosingOl();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningUl() {
        this.append("<ul>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningUl(int n) {
        this.appendSpaces(n);
        this.appendOpeningUl();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingUl() {
        this.append("</ul>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingUl(int n) {
        this.appendSpaces(n);
        this.appendClosingUl();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningLi(int n) {
        this.appendSpaces(n);
        this.appendOpeningLi();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningLi() {
        this.append("<li>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingLi(int n) {
        this.appendSpaces(n);
        this.appendClosingLi();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingLi() {
        this.append("</li>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendLi(String string) {
        this.append("<li>");
        this.append(string);
        this.appendLn("</li>");
        return this;
    }

    public ManualIndentationHtmlBuilder appendLi(int n, String string) {
        this.appendSpaces(n);
        this.appendLi(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendLi(int n, int n2) {
        this.appendLi(n, Integer.toString(n2));
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTable(int n) {
        this.appendSpaces(n);
        this.appendOpeningTable();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTable() {
        this.append("<table>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTableWithBorder(int n) {
        this.append("<table border=\"" + n + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTableWithBorderWidth(int n, int n2) {
        this.appendSpaces(n);
        this.appendOpeningTableWithBorder(n2);
        return this;
    }

    private ManualIndentationHtmlBuilder appendOpeningTableWithClass(String string) {
        this.append("<table class=\"" + string + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTableWithClass(int n, String string) {
        this.appendSpaces(n);
        this.appendOpeningTableWithClass(string);
        return this;
    }

    private ManualIndentationHtmlBuilder appendOpeningTableWithId(String string) {
        this.append("<table id=\"" + string + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTableWithId(int n, String string) {
        this.appendSpaces(n);
        this.appendOpeningTableWithId(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTableWithBorderWidth(int n) {
        this.append("<table border=\"" + n + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTable(int n) {
        this.appendSpaces(n);
        this.appendClosingTable();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTable() {
        this.append("</table>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningThead() {
        this.append("<thead>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningThead(int n) {
        this.appendSpaces(n);
        this.appendOpeningThead();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingThead() {
        this.append("</thead>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingThead(int n) {
        this.appendSpaces(n);
        this.appendClosingThead();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTbody() {
        this.append("<tbody>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTbody(int n) {
        this.appendSpaces(n);
        this.appendOpeningTbody();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTbody(int n, String string) {
        this.appendSpaces(n);
        this.appendOpeningTbody(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTbody(String string) {
        this.append("<tbody style=\"" + string + "\">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTbody() {
        this.append("</tbody>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTbody(int n) {
        this.appendSpaces(n);
        this.appendClosingTbody();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTfoot() {
        this.append("<tfoot>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTfoot(int n) {
        this.appendSpaces(n);
        this.appendOpeningTfoot();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTfoot() {
        this.append("</tfoot>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTfoot(int n) {
        this.appendSpaces(n);
        this.appendClosingTfoot();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTr(int n) {
        this.appendSpaces(n);
        this.appendOpeningTr();
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningTr() {
        this.append("<tr>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTr(int n) {
        this.appendSpaces(n);
        this.appendClosingTr();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingTr() {
        this.append("</tr>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendTh(int n, String string) {
        this.appendSpaces(n);
        this.appendInTag("th", string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendTh(int n, String string, String string2) {
        this.appendSpaces(n);
        this.appendInTag("th", string, string2);
        return this;
    }

    public ManualIndentationHtmlBuilder appendLeftAlignedTh(int n, String string) {
        this.appendSpaces(n);
        this.append("<th align=\"left\">");
        this.append(string);
        this.append("</th>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendLeftAlignedThWithClass(int n, String string, String string2) {
        this.appendSpaces(n);
        this.append("<th class=\"" + string2 + "\" align=\"left\">");
        this.append(string);
        this.append("</th>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendRightAlignedTh(int n, String string) {
        this.appendSpaces(n);
        this.append("<th align=\"right\">");
        this.append(string);
        this.append("</th>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendTd(int n, String string, String string2) {
        this.appendSpaces(n);
        this.appendInTag("td", string, string2);
        return this;
    }

    public ManualIndentationHtmlBuilder appendTd(int n, String string) {
        this.appendSpaces(n);
        this.appendInTag("td", string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendRightAlignedTd(int n, String string) {
        this.appendSpaces(n);
        this.append("<td align=\"right\">");
        this.append(string);
        this.append("</td>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendTd(int n, int n2) {
        this.appendTd(n, Integer.toString(n2));
        return this;
    }

    public ManualIndentationHtmlBuilder appendOpeningQuote(int n) {
        this.appendSpaces(n);
        this.append("<blockquote>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendClosingQuote(int n) {
        this.appendSpaces(n);
        this.append("</blockquote>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendSpaces(int n) {
        this.append(Text.multipleString(" ", n));
        return this;
    }

    public ManualIndentationHtmlBuilder appendH1(String string) {
        return this.appendH1(0, string);
    }

    public ManualIndentationHtmlBuilder appendH1(int n, String string) {
        ++this.numberOfH1;
        return this.appendHeader(n, HtmlHeaderType.H1, string);
    }

    public ManualIndentationHtmlBuilder appendH2(String string) {
        return this.appendH2(0, string);
    }

    public ManualIndentationHtmlBuilder appendH2(int n, String string) {
        ++this.numberOfH2;
        return this.appendHeader(n, HtmlHeaderType.H2, string);
    }

    public ManualIndentationHtmlBuilder appendH3(String string) {
        return this.appendH3(0, string);
    }

    public ManualIndentationHtmlBuilder appendH3(int n, String string) {
        ++this.numberOfH3;
        return this.appendHeader(n, HtmlHeaderType.H3, string);
    }

    public ManualIndentationHtmlBuilder appendH4(String string) {
        return this.appendH4(0, string);
    }

    public ManualIndentationHtmlBuilder appendH4(int n, String string) {
        ++this.numberOfH4;
        return this.appendHeader(n, HtmlHeaderType.H4, string);
    }

    public ManualIndentationHtmlBuilder appendH5(String string) {
        return this.appendH5(0, string);
    }

    public ManualIndentationHtmlBuilder appendH5(int n, String string) {
        ++this.numberOfH5;
        return this.appendHeader(n, HtmlHeaderType.H5, string);
    }

    public ManualIndentationHtmlBuilder appendH6(String string) {
        return this.appendH6(0, string);
    }

    public ManualIndentationHtmlBuilder appendH6(int n, String string) {
        ++this.numberOfH6;
        return this.appendHeader(n, HtmlHeaderType.H6, string);
    }

    private ManualIndentationHtmlBuilder appendHeader(int n, HtmlHeaderType htmlHeaderType, String string) {
        if (htmlHeaderType == HtmlHeaderType.H1 && this.numberOfH1 > 1) {
            this.appendToTopLink();
        }
        String string2 = this.generateHeaderId(htmlHeaderType);
        this.headers.add(new HtmlHeader(htmlHeaderType, string, string2));
        this.appendLineBreak();
        this.appendInTagWithParameters(n, htmlHeaderType.getHtmlTagName(), string, "id=\"" + string2 + "\"");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendToTopLink() {
        this.append("    <a href=\"#top\">Zum Seitenanfang</a>").appendLineBreak();
        return this;
    }

    private String generateHeaderId(HtmlHeaderType htmlHeaderType) {
        String string;
        if (htmlHeaderType == HtmlHeaderType.H1) {
            string = "id" + this.numberOfH1;
        } else if (htmlHeaderType == HtmlHeaderType.H2) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2;
        } else if (htmlHeaderType == HtmlHeaderType.H3) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3;
        } else if (htmlHeaderType == HtmlHeaderType.H4) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3 + "_" + this.numberOfH4;
        } else if (htmlHeaderType == HtmlHeaderType.H5) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3 + "_" + this.numberOfH4 + "_" + this.numberOfH5;
        } else if (htmlHeaderType == HtmlHeaderType.H6) {
            string = "id" + this.numberOfH1 + "_" + this.numberOfH2 + "_" + this.numberOfH3 + "_" + this.numberOfH4 + "_" + this.numberOfH5 + "_" + this.numberOfH6;
        } else {
            throw new RuntimeException("Unknown header type '" + htmlHeaderType + "'!");
        }
        return string;
    }

    public ManualIndentationHtmlBuilder appendP(String string) {
        this.appendInTag("p", string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendP(int n, String string) {
        this.appendSpaces(n);
        this.appendP(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendPTT(String string) {
        this.appendInTagWithParameters("p", string, "class=\"monospace\"");
        return this;
    }

    public ManualIndentationHtmlBuilder appendPTT(int n, String string) {
        this.appendSpaces(n);
        this.appendPTT(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendSmallP(int n, String string) {
        this.appendSpaces(n);
        this.appendSmallP(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendSmallP(String string) {
        this.append("<p style=\"font-size:x-small\">");
        this.append(string);
        this.append("</p>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendPGreen(String string) {
        this.appendP(HtmlTool.green(string));
        return this;
    }

    public ManualIndentationHtmlBuilder appendPGreen(int n, String string) {
        this.appendSpaces(n);
        this.appendPGreen(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendPRed(String string) {
        this.appendP(HtmlTool.red(string));
        return this;
    }

    public ManualIndentationHtmlBuilder appendPRed(int n, String string) {
        this.appendSpaces(n);
        this.appendPRed(string);
        return this;
    }

    public ManualIndentationHtmlBuilder appendPOrange(String string) {
        this.appendP(HtmlTool.orange(string));
        return this;
    }

    public ManualIndentationHtmlBuilder appendPOrange(int n, String string) {
        this.appendSpaces(n);
        this.appendPOrange(string);
        return this;
    }

    public void appendLink(int n, String string, String string2) {
        this.appendSpaces(n);
        this.appendInTagWithParameters("a", string2, "href=\"" + string + "\"");
        this.appendLineBreak();
    }

    public ManualIndentationHtmlBuilder appendInTag(String string, String string2) {
        this.append("<");
        this.append(string);
        this.append(">");
        this.append(string2);
        this.append("</");
        this.append(string);
        this.append(">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendInTag(String string, String string2, String string3) {
        this.append("<");
        this.append(string);
        this.append(" class=\"");
        this.append(string3);
        this.append("\"");
        this.append(">");
        this.append(string2);
        this.append("</");
        this.append(string);
        this.append(">");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendInTagWithParameters(String string, String string2, String ... stringArray) {
        this.append("<");
        this.append(string);
        for (String string3 : stringArray) {
            this.append(" ").append(string3);
        }
        this.append(">");
        this.append(string2);
        this.append("</");
        this.append(string);
        this.append(">");
        return this;
    }

    public ManualIndentationHtmlBuilder appendInTagWithParameters(int n, String string, String string2, String ... stringArray) {
        this.appendSpaces(n);
        return this.appendInTagWithParameters(string, string2, stringArray);
    }

    public ManualIndentationHtmlBuilder appendFoot() {
        this.appendLineBreak();
        if (this.hasContents) {
            this.appendToTopLink();
        }
        this.append("</body>");
        this.appendLineBreak();
        this.append("</html>");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendLineBreak() {
        this.append(Text.LINE_BREAK);
        return this;
    }

    public ManualIndentationHtmlBuilder appendHtmlLineBreak() {
        this.append("<br />");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder appendSeparatoringLine() {
        this.appendP("");
        this.appendP("");
        this.appendLine();
        this.appendP("");
        return this;
    }

    public ManualIndentationHtmlBuilder appendLine() {
        this.append("<hr />");
        this.appendLineBreak();
        return this;
    }

    public ManualIndentationHtmlBuilder append(StringBuilder stringBuilder) {
        this.builder.append((CharSequence)stringBuilder);
        return this;
    }

    public ManualIndentationHtmlBuilder append(ManualIndentationHtmlBuilder manualIndentationHtmlBuilder) {
        this.builder.append(manualIndentationHtmlBuilder.toString());
        return this;
    }

    public int length() {
        return this.builder.length();
    }

    public void appendPre(String string) {
        this.appendInTag("pre", string);
    }

    public ManualIndentationHtmlBuilder insertContent() {
        String string = "<body>";
        int n = this.builder.indexOf(string);
        if (n == -1) {
            throw new RuntimeException("Kein Body-Tag im Html gefunden!");
        }
        int n2 = n + string.length();
        this.builder.insert(n2, this.buildContents());
        this.hasContents = true;
        return this;
    }

    public ManualIndentationHtmlBuilder insertContentAtEnd() {
        String string = "</body>";
        int n = this.builder.indexOf(string);
        if (n == -1) {
            throw new RuntimeException("Kein Body-Tag im Html gefunden!");
        }
        this.builder.insert(n, this.buildContents() + Text.LINE_BREAK);
        this.hasContents = true;
        return this;
    }

    private String buildContents() {
        ManualIndentationHtmlBuilder manualIndentationHtmlBuilder = new ManualIndentationHtmlBuilder();
        manualIndentationHtmlBuilder.appendLineBreak().append("    ").appendInTag("h1", "Inhalt");
        for (HtmlHeader htmlHeader : this.headers) {
            manualIndentationHtmlBuilder.append("    ").append(htmlHeader.getContentIndentation()).append("<a href=\"#" + htmlHeader.getId() + "\">" + htmlHeader.getText() + "</a>").appendHtmlLineBreak();
        }
        return manualIndentationHtmlBuilder.toString();
    }

    public String toString() {
        return this.builder.toString();
    }
}

