/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons.painted;

import de.duehl.swing.ui.buttons.ButtonHelper;
import de.duehl.swing.ui.geometry.PixelLine;
import de.duehl.swing.ui.geometry.PixelPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;

public abstract class PaintedButton
extends JButton {
    private static final long serialVersionUID = -1L;
    private Color backgroundColor;
    private boolean horizontal;
    protected Graphics2D graphics2;
    private boolean forceSquare;
    private final UnFlatValues unFlatValues;
    private Color symbolColor;
    private boolean changeColorOnMouseOver;
    private boolean shiftOnMouseOver;

    public PaintedButton() {
        this(Color.BLACK);
    }

    public PaintedButton(Color color) {
        this.symbolColor = color;
        this.backgroundColor = null;
        this.horizontal = true;
        this.forceSquare = false;
        this.changeColorOnMouseOver = true;
        this.shiftOnMouseOver = true;
        this.setPreferredSize(ButtonHelper.BUTTON_DIMENSION);
        this.setFocusable(false);
        this.unFlatValues = new UnFlatValues(this.isContentAreaFilled(), this.getBorder(), this.isBorderPainted());
        this.showFlat();
        this.addMouseListener(ButtonHelper.BUTTON_MOUSE_LISTENER);
        this.setRolloverEnabled(true);
    }

    public void removeStandardMouseListener() {
        this.removeMouseListener(ButtonHelper.BUTTON_MOUSE_LISTENER);
    }

    public final Color getSymbolColor() {
        return this.symbolColor;
    }

    public final void setSymbolColor(Color color) {
        this.symbolColor = color;
        this.repaint();
    }

    public final void ignoreMouseOver() {
        this.changeColorOnMouseOver = false;
    }

    public final boolean isChangeColorOnMouseOver() {
        return this.changeColorOnMouseOver;
    }

    public boolean isShiftOnMouseOver() {
        return this.shiftOnMouseOver;
    }

    public void noShiftOnMouseOver() {
        this.shiftOnMouseOver = false;
    }

    public void showFlat() {
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(false);
    }

    public void showNonFlat() {
        this.setContentAreaFilled(this.unFlatValues.isContentAreaFilled());
        this.setBorder(this.unFlatValues.getBorder());
        this.setBorderPainted(this.unFlatValues.isBorderPainted());
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public boolean isForceSquare() {
        return this.forceSquare;
    }

    public void setForceSquare(boolean bl) {
        this.forceSquare = bl;
    }

    public void forceSquare() {
        this.setForceSquare(true);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.graphics2 = (Graphics2D)graphics.create();
        this.shiftIfButtoninIsPressed();
        this.setStroke();
        this.paintBackground();
        this.setSymbolColorInGraphics();
        this.paintSymbol();
        this.graphics2.dispose();
    }

    protected void setStroke() {
        this.graphics2.setStroke(new BasicStroke(2.0f));
    }

    private void shiftIfButtoninIsPressed() {
        if (this.shiftOnMouseOver && this.getModel().isPressed()) {
            this.graphics2.translate(1, 1);
        }
    }

    private void paintBackground() {
        if (null != this.backgroundColor) {
            this.graphics2.setColor(this.backgroundColor);
            this.graphics2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    private void paintSymbol() {
        if (this.forceSquare) {
            if (this.horizontal) {
                this.paintHorizontalSymbolSquare();
            } else {
                this.paintVerticalSymbolSquare();
            }
        } else if (this.horizontal) {
            this.paintHorizontalSymbolRectangle();
        } else {
            this.paintVerticalSymbolRectangle();
        }
    }

    protected void setSymbolColorInGraphics() {
        this.graphics2.setColor(this.symbolColor);
        if (this.changeColorOnMouseOver && this.getModel().isRollover()) {
            this.graphics2.setColor(ButtonHelper.antiColor(this.symbolColor));
        }
    }

    protected abstract void paintHorizontalSymbolRectangle();

    protected abstract void paintVerticalSymbolRectangle();

    protected abstract void paintHorizontalSymbolSquare();

    protected abstract void paintVerticalSymbolSquare();

    protected final void paintPointLengthRectangle(int n, int n2, int n3, int n4) {
        this.graphics2.fillRect(n, n2, n3, n4);
    }

    protected final void paintTwoPointRectangle(PixelPoint pixelPoint, PixelPoint pixelPoint2) {
        this.paintTwoPointRectangle(pixelPoint.getX(), pixelPoint.getY(), pixelPoint2.getX(), pixelPoint2.getY());
    }

    protected final void paintUnfilledRectangle(PixelPoint pixelPoint, PixelPoint pixelPoint2) {
        this.graphics2.drawRect(pixelPoint.getX(), pixelPoint.getY(), pixelPoint2.getX() - pixelPoint.getX(), pixelPoint2.getY() - pixelPoint.getY());
    }

    protected final void paintTwoPointRectangle(int n, int n2, int n3, int n4) {
        if (n > n3 || n2 > n4) {
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3 - n;
        int n8 = n4 - n2;
        this.graphics2.fillRect(n5, n6, n7, n8);
    }

    protected final void paintCircle(PixelPoint pixelPoint, int n) {
        this.paintCircle(pixelPoint.getX(), pixelPoint.getY(), n);
    }

    protected final void paintCircle(int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = 2 * n3;
        int n7 = 2 * n3;
        this.paintOval(n4, n5, n6, n7);
    }

    protected final void paintHollowCircle(PixelPoint pixelPoint, int n) {
        this.paintHollowCircle(pixelPoint.getX(), pixelPoint.getY(), n);
    }

    protected final void paintHollowCircle(int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = 2 * n3;
        int n7 = 2 * n3;
        this.paintHollowOval(n4, n5, n6, n7);
    }

    protected final void paintOval(int n, int n2, int n3, int n4) {
        this.graphics2.fillOval(n, n2, n3, n4);
    }

    protected final void paintHollowOval(int n, int n2, int n3, int n4) {
        this.graphics2.drawOval(n, n2, n3, n4);
    }

    protected final Polygon createPolygon(int[] nArray, int[] nArray2, int n) {
        return new Polygon(nArray, nArray2, n);
    }

    protected final Polygon createPolygon(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n != nArray2.length) {
            throw new RuntimeException("xpoints und ypoints haben unterschiedliche L\u00e4ngen!\n\txPoints: " + n + "\n\tyPoints: " + nArray2.length);
        }
        return this.createPolygon(nArray, nArray2, n);
    }

    protected final Polygon createPolygon(List<PixelPoint> list) {
        int n = list.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (PixelPoint pixelPoint : list) {
            nArray[n2] = pixelPoint.getX();
            nArray2[n2] = pixelPoint.getY();
            ++n2;
        }
        return this.createPolygon(nArray, nArray2, n);
    }

    protected final Polygon createPolygon(PixelPoint ... pixelPointArray) {
        return this.createPolygon(Arrays.asList(pixelPointArray));
    }

    protected final void paintPolygon(Polygon polygon) {
        this.graphics2.fillPolygon(polygon);
    }

    protected final void paintPolygon(int[] nArray, int[] nArray2, int n) {
        this.paintPolygon(this.createPolygon(nArray, nArray2, n));
    }

    protected final void paintPolygon(int[] nArray, int[] nArray2) {
        this.paintPolygon(this.createPolygon(nArray, nArray2));
    }

    protected final void paintPolygon(List<PixelPoint> list) {
        this.paintPolygon(this.createPolygon(list));
    }

    protected final void paintPolygon(PixelPoint ... pixelPointArray) {
        this.paintPolygon(Arrays.asList(pixelPointArray));
    }

    protected final void paintHollowPolygon(Polygon polygon) {
        this.graphics2.drawPolygon(polygon);
    }

    protected final void paintHollowPolygon(int[] nArray, int[] nArray2, int n) {
        this.paintHollowPolygon(this.createPolygon(nArray, nArray2, n));
    }

    protected final void paintHollowPolygon(int[] nArray, int[] nArray2) {
        this.paintHollowPolygon(this.createPolygon(nArray, nArray2));
    }

    protected final void paintHollowPolygon(List<PixelPoint> list) {
        this.paintHollowPolygon(this.createPolygon(list));
    }

    protected final void paintHollowPolygon(PixelPoint ... pixelPointArray) {
        this.paintHollowPolygon(Arrays.asList(pixelPointArray));
    }

    protected final void paintLine(PixelPoint pixelPoint, PixelPoint pixelPoint2) {
        this.graphics2.drawLine(pixelPoint.getX(), pixelPoint.getY(), pixelPoint2.getX(), pixelPoint2.getY());
    }

    protected final void paintLine(PixelLine pixelLine) {
        this.paintLine(pixelLine.getStart(), pixelLine.getEnd());
    }

    public class UnFlatValues {
        private final boolean contentAreaFilled;
        private final Border border;
        private final boolean borderPainted;

        public UnFlatValues(boolean bl, Border border, boolean bl2) {
            this.contentAreaFilled = bl;
            this.border = border;
            this.borderPainted = bl2;
        }

        public boolean isContentAreaFilled() {
            return this.contentAreaFilled;
        }

        public Border getBorder() {
            return this.border;
        }

        public boolean isBorderPainted() {
            return this.borderPainted;
        }
    }
}

