/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.progress;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.progress.ColoredProgressBar;
import de.duehl.swing.ui.elements.watch.StopWatchLabel;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class ColoredProgressPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color AT_WORK_COLOR = new Color(220, 142, 0);
    private static final Color DONE_COLOR = new Color(100, 200, 100);
    private String progressTitle;
    private String countPrefix;
    private String timerPrefix;
    private String actualElementPrefix;
    private String actualElementPrefixBeforeStart;
    private String actualElementWhenDone;
    private JProgressBar progressBar;
    private JLabel infoLabel;
    private StopWatchLabel stopWatchLabel;
    private JLabel countLabel;
    private boolean showWatch;

    public ColoredProgressPanel(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, true);
    }

    public ColoredProgressPanel(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.progressTitle = string;
        this.countPrefix = string2;
        this.timerPrefix = string3;
        this.actualElementPrefix = string4;
        this.actualElementPrefixBeforeStart = string5;
        this.actualElementWhenDone = string6;
        this.showWatch = bl;
        this.setLayout(new BorderLayout());
        this.add(this.createProgressBar(), "North");
        this.add(this.createProgressbarInformations(), "Center");
    }

    private Component createProgressBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JLabel jLabel = new JLabel(this.progressTitle);
        GuiTools.biggerFont(jLabel, 5);
        jPanel.add((Component)jLabel, "North");
        ColoredProgressBar coloredProgressBar = new ColoredProgressBar(0, 100);
        coloredProgressBar.setValue(0);
        coloredProgressBar.setStringPainted(false);
        this.progressBar = coloredProgressBar;
        jPanel.add((Component)coloredProgressBar, "Center");
        return jPanel;
    }

    private Component createProgressbarInformations() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        JLabel jLabel = new JLabel(this.actualElementPrefixBeforeStart);
        GuiTools.biggerFont(jLabel, 5);
        jPanel.add(jLabel);
        this.infoLabel = jLabel;
        this.countLabel = new JLabel(this.countPrefix + "0");
        GuiTools.biggerFont(this.countLabel, 5);
        jPanel.add(this.countLabel);
        this.countLabel.setBorder(new EmptyBorder(15, 0, 15, 0));
        if (this.showWatch) {
            this.stopWatchLabel = new StopWatchLabel(this.timerPrefix, "");
            GuiTools.biggerFont(this.stopWatchLabel, 5);
            jPanel.add(this.stopWatchLabel);
        } else {
            this.stopWatchLabel = null;
        }
        return jPanel;
    }

    public void updateProgress(int n, int n2, String string) {
        this.progressBar.setValue(n2);
        this.countLabel.setText(this.countPrefix + NumberString.taupu(n2) + " / " + NumberString.taupu(n));
        if (!string.isEmpty()) {
            this.infoLabel.setText(this.actualElementPrefix + FileHelper.getBareName(string));
        }
        if (n2 == 0) {
            this.progressBar.setForeground(AT_WORK_COLOR);
            this.progressBar.setMaximum(n);
            this.progressBar.setStringPainted(true);
        } else if (n2 == n) {
            this.progressBar.setForeground(DONE_COLOR);
            this.infoLabel.setText(this.actualElementWhenDone);
            if (this.showWatch) {
                this.stopWatchLabel.stop();
            }
        }
        this.repaint();
    }

    public void stopStopWatch() {
        if (this.showWatch) {
            this.stopWatchLabel.stop();
        }
    }

    public String getRuntime() {
        if (this.showWatch) {
            return this.stopWatchLabel.getTime();
        }
        return "not available";
    }

    public void startStopWatch() {
        if (this.showWatch) {
            this.stopWatchLabel.start();
        }
    }
}

