/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.layout.card;

import de.duehl.swing.ui.layout.card.CardDebug;
import de.duehl.swing.ui.layout.card.CardGui;
import de.duehl.swing.ui.layout.card.CardLogic;
import de.duehl.swing.ui.layout.card.CardResult;
import de.duehl.swing.ui.layout.card.CardSwitcher;
import de.duehl.swing.ui.layout.card.Cards;
import java.awt.Component;

public class Card {
    private static final long NO_TIME_YET = Long.MIN_VALUE;
    private final String name;
    private final CardGui gui;
    private final CardLogic logic;
    private final int stepNumber;
    private final String nameForGui;
    private long timeUsedInSeconds;
    private String timeUsedHumanReadable;

    public Card(String string, CardGui cardGui, CardLogic cardLogic, int n, String string2) {
        this.name = string;
        this.gui = cardGui;
        this.logic = cardLogic;
        this.stepNumber = n;
        this.nameForGui = string2;
        this.timeUsedInSeconds = Long.MIN_VALUE;
        this.timeUsedHumanReadable = "";
        cardLogic.setGui(cardGui);
        cardLogic.setCard(this);
        cardGui.setLogic(cardLogic);
    }

    public final void setCards(Cards cards) {
        this.logic.setCards(cards);
    }

    String getName() {
        return this.name;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public String getNameForGui() {
        return this.nameForGui;
    }

    public boolean isTimeAccessible() {
        return this.timeUsedInSeconds != Long.MIN_VALUE && !this.timeUsedHumanReadable.isEmpty();
    }

    public long getTimeUsedInSeconds() {
        return this.timeUsedInSeconds;
    }

    public void setTimeUsedInSeconds(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Laufzeit " + l + " ist unzul\u00e4ssig!");
        }
        this.timeUsedInSeconds = l;
    }

    public String getTimeUsedHumanReadable() {
        return this.timeUsedHumanReadable;
    }

    public void setTimeUsedHumanReadable(String string) {
        if (!string.matches("\\d{2,}:\\d{2}:\\d{2}")) {
            throw new IllegalArgumentException("Laufzeit '" + string + "' ist unzul\u00e4ssig!");
        }
        this.timeUsedHumanReadable = string;
    }

    Component createCardGui(CardSwitcher cardSwitcher) {
        return this.gui.createGui(cardSwitcher);
    }

    void runWhenShown(Card card) {
        CardDebug.say("called");
        CardLogic cardLogic = card.logic;
        CardResult cardResult = cardLogic.getResult();
        this.logic.setResultFromPreviousCard(cardResult);
        this.logic.runWhenShown();
    }

    void cleanUp() {
        this.gui.cleanUp();
    }

    public void quit() {
        CardDebug.say("called");
        this.logic.quit();
        this.cleanUp();
    }

    public String toString() {
        return "Card [name=" + this.name + ", stepNumber=" + this.stepNumber + ", nameForGui=" + this.nameForGui + ", timeUsedInSeconds=" + this.timeUsedInSeconds + ", timeUsedHumanReadable=" + this.timeUsedHumanReadable + "]";
    }

    public CardLogic getLogic() {
        return this.logic;
    }
}

