/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.startup.logic.StartupLoader;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Step04ReadInternalVocableData
extends StartupStep {
    private Map<String, InternalAdditionalVocableData> key2InternalDataMap;
    private List<String> allKeysFromReadInternalData;

    public Step04ReadInternalVocableData(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch) {
        super(string, options, splashScreenable, stopWatch);
    }

    @Override
    protected void runInternalStep() {
        Object object;
        this.appendMessage("Lese interne benutzerabh\u00e4ngige Daten zu allen Vokabeln ...");
        FileHelper.createDirectoryIfNotExists(StartupLoader.INTERNAL_DATA_DIRECTORY);
        List<String> list = FileHelper.findFilesInMainDirectoryNio2WithExtensions(StartupLoader.INTERNAL_DATA_DIRECTORY, ".ivd");
        this.appendMessage(NumberString.taupu(list.size()) + " interne Datens\u00e4tze gefunden.");
        this.appendMessage("Lese interne Datens\u00e4tze ein ...");
        ArrayList<InternalAdditionalVocableData> arrayList = new ArrayList<InternalAdditionalVocableData>();
        for (String object2 : list) {
            object = InternalAdditionalVocableData.load(object2);
            arrayList.add((InternalAdditionalVocableData)object);
        }
        this.appendMessage(NumberString.taupu(arrayList.size()) + " interne Datens\u00e4tze eingelesen.");
        this.key2InternalDataMap = new HashMap<String, InternalAdditionalVocableData>();
        this.allKeysFromReadInternalData = new ArrayList<String>();
        for (InternalAdditionalVocableData internalAdditionalVocableData : arrayList) {
            object = internalAdditionalVocableData.getKey();
            if (this.key2InternalDataMap.containsKey(object) || this.allKeysFromReadInternalData.contains(object)) {
                throw new RuntimeException("Der Schl\u00fcssel '" + (String)object + "' kommt mehrfach vor!");
            }
            this.key2InternalDataMap.put((String)object, internalAdditionalVocableData);
            this.allKeysFromReadInternalData.add((String)object);
        }
        this.appendMessage("Verzeichnis mit " + NumberString.taupu(this.key2InternalDataMap.size()) + " Verweisen von Schl\u00fcssel auf interne Datens\u00e4tze aufgebaut.");
    }

    public Map<String, InternalAdditionalVocableData> getKey2InternalDataMap() {
        return this.key2InternalDataMap;
    }

    public List<String> getAllKeysFromReadInternalData() {
        return this.allKeysFromReadInternalData;
    }
}

