/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class KanaAndKanjiMenuCreation
implements SingleMenuCreation {
    private final VocabularyTrainerGui gui;

    public KanaAndKanjiMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Kana und Kanji");
        jMenu.setMnemonic('k');
        jMenu.add(this.createShowHiraganaMenuItem());
        jMenu.add(this.createShowKatakanaMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowHiraganaInBrowserMenuItem());
        jMenu.add(this.createShowKatakanaInBrowserMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowHiraganaTableMenuItem());
        jMenu.add(this.createShowKatakanaTableMenuItem());
        jMenu.add(this.createCreateHiraganaTestFromKanjiMenuItem());
        jMenu.add(this.createCreateKatakanaTestFromKanjiMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowKanjiTableMenuItem());
        jMenu.add(this.createCreateKanjiTestFromGermanMeaningMenuItem());
        jMenu.add(this.createCreateKanjiTestFromKanjiMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createManageKanjiSetsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createSearchKanjiByOnLesungMenuItem());
        jMenu.add(this.createSearchKanjiByKunLesungMenuItem());
        jMenu.add(this.createSearchKanjiByAnyLesungMenuItem());
        jMenu.add(this.createSearchKanjiByGermanMeaningMenuItem());
        jMenu.add(this.createSearchKanjiByAnyMenuItem());
        return jMenu;
    }

    private JMenuItem createShowHiraganaMenuItem() {
        return new MyMenuItem("Hiragana anzeigen ...").mnemonic('h').actionListener(actionEvent -> this.gui.showHiragana());
    }

    private JMenuItem createShowKatakanaMenuItem() {
        return new MyMenuItem("Katakana anzeigen ...").mnemonic('n').actionListener(actionEvent -> this.gui.showKatakana());
    }

    private JMenuItem createShowHiraganaInBrowserMenuItem() {
        return new MyMenuItem("Hiragana im Browser anzeigen ...").mnemonic('h').actionListener(actionEvent -> this.gui.showHiraganaInBrowser());
    }

    private JMenuItem createShowKatakanaInBrowserMenuItem() {
        return new MyMenuItem("Katakana im Browser anzeigen ...").mnemonic('b').actionListener(actionEvent -> this.gui.showKatakanaInBrowser());
    }

    private JMenuItem createShowHiraganaTableMenuItem() {
        return new MyMenuItem("Hiragana-Tabelle anzeigen ...").actionListener(actionEvent -> this.gui.showHiraganaTable());
    }

    private JMenuItem createShowKatakanaTableMenuItem() {
        return new MyMenuItem("Katakana-Tabelle anzeigen ...").actionListener(actionEvent -> this.gui.showKatakanaTable());
    }

    private JMenuItem createCreateHiraganaTestFromKanjiMenuItem() {
        return new MyMenuItem("Hiragana abfragen ...").mnemonic('h').actionListener(actionEvent -> this.gui.createHiraganaTest());
    }

    private JMenuItem createCreateKatakanaTestFromKanjiMenuItem() {
        return new MyMenuItem("Katakana abfragen ...").mnemonic('k').actionListener(actionEvent -> this.gui.createKatakanaTest());
    }

    private JMenuItem createShowKanjiTableMenuItem() {
        return new MyMenuItem("Kanji-Tabelle anzeigen ...").mnemonic('t').accelerator(75, 128).actionListener(actionEvent -> this.gui.showKanjiTable());
    }

    private JMenuItem createCreateKanjiTestFromGermanMeaningMenuItem() {
        return new MyMenuItem("Kanji Abfrageliste von der deutschen Bedeutung aus erstellen ...").mnemonic('a').actionListener(actionEvent -> this.gui.createKanjiTestFromGermanMeaning());
    }

    private JMenuItem createCreateKanjiTestFromKanjiMenuItem() {
        return new MyMenuItem("Kanji abfragen (ausgehend vom Zeichen hier im Programm) ...").mnemonic('f').accelerator(75, 640).actionListener(actionEvent -> this.gui.createKanjiTestFromKanji());
    }

    private JMenuItem createManageKanjiSetsMenuItem() {
        return new MyMenuItem("Kanji-Mengen bearbeiten ...").mnemonic('m').accelerator(77, 640).actionListener(actionEvent -> this.gui.manageKanjiSets());
    }

    private JMenuItem createSearchKanjiByOnLesungMenuItem() {
        return new MyMenuItem("\u00dcber On-Lesung nach Kanji suchen ...").actionListener(actionEvent -> this.gui.searchKanjiByOnLesung());
    }

    private JMenuItem createSearchKanjiByKunLesungMenuItem() {
        return new MyMenuItem("\u00dcber Kun-Lesung nach Kanji suchen ...").actionListener(actionEvent -> this.gui.searchKanjiByKunLesung());
    }

    private JMenuItem createSearchKanjiByAnyLesungMenuItem() {
        return new MyMenuItem("\u00dcber eine beliebige Lesung nach Kanji suchen ...").actionListener(actionEvent -> this.gui.searchKanjiByAnyLesung());
    }

    private JMenuItem createSearchKanjiByGermanMeaningMenuItem() {
        return new MyMenuItem("\u00dcber eine deutsche Bedeutung nach Kanji suchen ...").actionListener(actionEvent -> this.gui.searchKanjiByGermanMeaning());
    }

    private JMenuItem createSearchKanjiByAnyMenuItem() {
        return new MyMenuItem("Nach beliebigem Inhalt nach Kanji suchen ...").mnemonic('s').accelerator(75, 192).actionListener(actionEvent -> this.gui.searchKanjiByAny());
    }
}

