/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs.bar;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.move.VerticalMoveButtons;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MovableGrammarBaseFormBar
implements VerticalMoveButtonsUser {
    private final MovingGui<MovableGrammarBaseFormBar> movingGui;
    private final Vocable baseFormVocable;
    private final int index;
    private final JPanel panel;
    private final VerticalMoveButtons moveButtons;

    public MovableGrammarBaseFormBar(MovingGui<MovableGrammarBaseFormBar> movingGui, Vocable vocable, int n) {
        this.movingGui = movingGui;
        this.index = n;
        this.baseFormVocable = vocable;
        this.panel = new JPanel();
        this.moveButtons = new VerticalMoveButtons(this);
        this.fillPanel();
    }

    private void fillPanel() {
        this.panel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.panel);
        this.panel.add(this.createLabel(), "Center");
        this.panel.add((Component)this.moveButtons.getPanel(), "East");
    }

    private Component createLabel() {
        String string = this.baseFormVocable.getKanjiKanaRomajiWithJapaneseBraces();
        JLabel jLabel = new JLabel(string);
        GuiTools.biggerFont(jLabel, 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    @Override
    public boolean canMoveButtonsUserMoveUp() {
        return this.movingGui.canBarMoveUp(this);
    }

    @Override
    public boolean canMoveButtonsUserMoveDown() {
        return this.movingGui.canBarMoveDown(this);
    }

    @Override
    public void moveMoveButtonsUserToFirst() {
        this.movingGui.moveBarToFirst(this);
    }

    @Override
    public void moveMoveButtonsUserUp() {
        this.movingGui.moveBarUp(this);
    }

    @Override
    public void moveMoveButtonsUserDown() {
        this.movingGui.moveBarDown(this);
    }

    @Override
    public void moveMoveButtonsUserToLast() {
        this.movingGui.moveBarToLast(this);
    }

    public Vocable getBaseFormVocable() {
        return this.baseFormVocable;
    }

    public Component getPanel() {
        return this.panel;
    }

    public int getIndex() {
        return this.index;
    }

    public void setUpAndDownButtonColorsAndEnabled() {
        this.moveButtons.setUpAndDownButtonColorsAndEnabled();
    }
}

