/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.ownlists;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.html.download.binary.SimpleBinaryFileDownloader;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.progress.MultipleProgressDialog;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.ownlists.groups.OwnListGroup;
import de.duehl.vocabulary.japanese.ui.components.data.OwnListsPartActualizer;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.update.OwnListInterestSelectionAndDownloadDialog;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.groupfile.GroupFileIo;
import de.duehl.vocabulary.japanese.website.update.ownlists.groupfile.data.GroupFileEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionAndInterestIo;
import de.duehl.zipwithzip4j.unzip.UnzipWithZip4J2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class GroupsDownloader {
    private static final boolean DEBUG = false;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final List<NewestOwnListVersionListEntry> newestOwnListVersionEntries;
    private final List<OwnListInterestAndVersionEntry> interestAndVersionEntries;
    private final List<String> newerOrUnseenGroupNames;
    private List<String> groupNamesInterestedIn;
    private List<String> groupNamesToDownload;
    private String ownListImportExportDirectory;
    private boolean ownListImportExportDirectorySelected;
    private Map<String, String> zipBareFilenamesByGroupName;
    private Map<String, String> localZipFilenamesByGroupName;
    private Map<String, String> localUnzippedDirnamesByGroupName;
    private Map<String, Integer> versionByGroupName;
    private String groupName;
    private MultipleProgressDialog progressDialog;
    private Map<String, String> listNameByBareListFilenameMap;
    private List<String> ownListFilenamesInArchive;

    public GroupsDownloader(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, List<NewestOwnListVersionListEntry> list, List<OwnListInterestAndVersionEntry> list2, List<String> list3) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.newestOwnListVersionEntries = list;
        this.interestAndVersionEntries = list2;
        this.newerOrUnseenGroupNames = list3;
    }

    public void download() {
        boolean bl = this.showOwnListInterestSelectionAndDownloadDialog();
        if (bl) {
            this.workWithUsersSelection();
        }
    }

    private boolean showOwnListInterestSelectionAndDownloadDialog() {
        OwnListInterestSelectionAndDownloadDialog ownListInterestSelectionAndDownloadDialog = new OwnListInterestSelectionAndDownloadDialog(this.newestOwnListVersionEntries, this.interestAndVersionEntries, this.newerOrUnseenGroupNames, this.uiObjects.getGuiLocation(), this.uiObjects.getProgramImage());
        ownListInterestSelectionAndDownloadDialog.setVisible(true);
        if (ownListInterestSelectionAndDownloadDialog.isApplied()) {
            this.groupNamesInterestedIn = ownListInterestSelectionAndDownloadDialog.getGroupNamesInterestedIn();
            this.groupNamesToDownload = ownListInterestSelectionAndDownloadDialog.getGroupNamesToDownload();
            return true;
        }
        return false;
    }

    private void workWithUsersSelection() {
        if (this.groupNamesToDownload.isEmpty()) {
            GuiTools.informUser(this.uiObjects.getWindowAsComponent(), "Hinweis", "Es wurden keine Gruppen zum Herunterladen, Auspacken und importieren ausgew\u00e4hlt.");
            this.storeInteresstedGroupsWithoutAnyDownload();
        } else {
            this.reallyWorkWithUsersSelection();
        }
    }

    private void reallyWorkWithUsersSelection() {
        LongTimeProcessInformer longTimeProcessInformer = this.uiObjects.getInformer();
        longTimeProcessInformer.startLongTimeProcess("Download etc. l\u00e4uft");
        new Thread(() -> this.workWithUsersSelectionInOwnThread()).start();
    }

    private void workWithUsersSelectionInOwnThread() {
        try {
            this.tryToWorkWithUsersSelectionInOwnThread();
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(() -> this.showError(exception));
        }
    }

    private void tryToWorkWithUsersSelectionInOwnThread() {
        this.updateNewerOwnListVersionAndInterestEntriesWithGuiSelection();
        this.storeInterestAndVersionFile();
        this.determineOwnListImportExportDirectory();
        if (this.ownListImportExportDirectorySelected) {
            this.createVersionByGroupNameMap();
            this.determineZipNames();
            this.downloadWantedGroups();
            this.unzipWantedGroups();
            boolean bl = this.checkUnzipIsOk();
            if (bl) {
                this.importWantedGroups();
            }
            this.removeTemporarilyFiles();
        }
        SwingUtilities.invokeLater(() -> this.actualizeInEdt());
    }

    private void updateNewerOwnListVersionAndInterestEntriesWithGuiSelection() {
        for (OwnListInterestAndVersionEntry ownListInterestAndVersionEntry : this.interestAndVersionEntries) {
            String string = ownListInterestAndVersionEntry.getGroupName();
            boolean bl = this.groupNamesInterestedIn.contains(string);
            ownListInterestAndVersionEntry.setInterested(bl);
        }
    }

    private void storeInterestAndVersionFile() {
        OwnListVersionAndInterestIo.storeInterestAndVersionFile(this.interestAndVersionEntries);
    }

    private void determineOwnListImportExportDirectory() {
        Options options = this.dataStructures.getOptions();
        this.ownListImportExportDirectory = options.getLastUsedOwnListImportExportDirectory();
        boolean bl = GuiTools.askUser(this.uiObjects.getWindowAsComponent(), "Verzeichnis zum Herunterladen, entpacken und Importieren der Gruppen", "Das Verzeichnis zum Herunterladen, entpacken und Importieren der Gruppen ist auf\n" + this.ownListImportExportDirectory + "\neingestellt. Ist das In Ordnung?\nAnderenfalls kann ein anderes Verzeichnis gew\u00e4hlt werden.");
        if (bl) {
            this.ownListImportExportDirectorySelected = true;
        } else {
            String string = GuiTools.openDirectory(this.ownListImportExportDirectory, "Verzeichnis zum Herunterladen, entpacken und Importieren der Gruppen w\u00e4hlen", this.uiObjects.getWindowAsComponent());
            if (!(string = string.strip()).isEmpty() && FileHelper.isDirectory(string)) {
                this.ownListImportExportDirectory = string;
                options.setLastUsedOwnListImportExportDirectory(this.ownListImportExportDirectory);
                this.ownListImportExportDirectorySelected = true;
            } else {
                this.ownListImportExportDirectorySelected = false;
            }
        }
    }

    private void createVersionByGroupNameMap() {
        this.versionByGroupName = new HashMap<String, Integer>();
        for (NewestOwnListVersionListEntry newestOwnListVersionListEntry : this.newestOwnListVersionEntries) {
            this.versionByGroupName.put(newestOwnListVersionListEntry.getGroupName(), newestOwnListVersionListEntry.getVersion());
        }
    }

    private void determineZipNames() {
        this.zipBareFilenamesByGroupName = new HashMap<String, String>();
        for (String string : this.groupNamesToDownload) {
            int n = this.versionByGroupName.get(string);
            String string2 = OwnListGroup.createGroupBareFilename(string, n);
            this.zipBareFilenamesByGroupName.put(string, string2);
        }
    }

    private void downloadWantedGroups() {
        this.localZipFilenamesByGroupName = new HashMap<String, String>();
        for (String string : this.groupNamesToDownload) {
            String string2 = this.zipBareFilenamesByGroupName.get(string);
            String string3 = "https://www.duehl.de/vokabel_trainer_japanisch/" + string2;
            String string4 = FileHelper.concatPathes(this.ownListImportExportDirectory, string2);
            SimpleBinaryFileDownloader.downloadBinaryFile(string3, string4);
            this.localZipFilenamesByGroupName.put(string, string4);
        }
    }

    private void unzipWantedGroups() {
        this.localUnzippedDirnamesByGroupName = new HashMap<String, String>();
        for (String string : this.groupNamesToDownload) {
            String string2 = this.localZipFilenamesByGroupName.get(string);
            int n = this.versionByGroupName.get(string);
            String string3 = FileHelper.concatPathes(this.ownListImportExportDirectory, OwnListGroup.createGroupBareFilenameWithoutExtension(string, n));
            if (FileHelper.isDirectory(string3)) {
                FileHelper.deleteTree(string3);
            }
            UnzipWithZip4J2 unzipWithZip4J2 = new UnzipWithZip4J2(string2, this.ownListImportExportDirectory);
            unzipWithZip4J2.unzip();
            this.localUnzippedDirnamesByGroupName.put(string, string3);
        }
    }

    private boolean checkUnzipIsOk() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : this.groupNamesToDownload) {
            if (this.localUnzippedDirnamesByGroupName.containsKey(object2)) continue;
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        String string = "Achtung";
        String string2 = "Kein ausgepacktes Gruppenverzeichnis " + NumberString.germanPlural(arrayList.size(), "zu den Gruppen", "zur Gruppe") + " " + Text.joinWithCommaAndBlank(arrayList) + " vorhanden.\n\nDaher wird nichts importiert.";
        GuiTools.informUser(this.uiObjects.getWindowAsComponent(), string, string2);
        return false;
    }

    private void importWantedGroups() {
        this.createProgressDialog();
        Iterator<String> iterator = this.groupNamesToDownload.iterator();
        while (iterator.hasNext()) {
            String string;
            this.groupName = string = iterator.next();
            this.importWantedGroup();
        }
    }

    private void createProgressDialog() {
        String string = "Fortschritt beim Import der " + NumberString.germanPlural(this.groupNamesToDownload.size(), "Gruppen", "Gruppe") + " '" + Text.join("', '", this.groupNamesToDownload) + "'";
        this.progressDialog = new MultipleProgressDialog(string, this.uiObjects.getGuiLocation(), this.uiObjects.getProgramImage());
        for (String string2 : this.groupNamesToDownload) {
            this.progressDialog.addProgress(string2).setProgressTitle(string2, "Fortschritt beim Import der Gruppe '" + string2 + "':").setCountPrefix(string2, "Anzahl importierter eigener Listen der Gruppe '" + string2 + "': ").setTimerPrefix(string2, "Laufzeit: ").setActualElementPrefix(string2, "Importiere: ").setActualElementPrefixBeforeStart(string2, "Noch nichts importiert.").setActualElementWhenDone(string2, "Alle eigener Listen der Gruppe '" + string2 + "'wurden importiert.").createProgressPanel(string2);
        }
        this.progressDialog.createUi();
    }

    private void importWantedGroup() {
        List<String> list = this.getAllFilenamesInArchive();
        List<String> list2 = FileHelper.getFilesWithGivenBareFilename(list, "group.grp");
        if (list2.size() != 1) {
            this.informUserAboutGroupFileFailure(this.groupName);
            this.progressDialog.closeUi(this.groupName);
            return;
        }
        this.createListNameByBareListFilenameMap(list2.get(0));
        this.ownListFilenamesInArchive = FileHelper.getFilesWithGivenExtension(list, ".owl");
        if (this.ownListFilenamesInArchive.size() != this.listNameByBareListFilenameMap.size()) {
            this.informUserAboutOwnListFilesInArchiveNotLikeInGroupFileFailure(this.groupName);
            this.progressDialog.closeUi(this.groupName);
            return;
        }
        this.initProgressGui();
        this.removeOldOwnListsOfGroup();
        this.importOwnListFilenamesInArchive();
        this.progressDialog.closeUi(this.groupName);
    }

    private List<String> getAllFilenamesInArchive() {
        if (!this.localUnzippedDirnamesByGroupName.containsKey(this.groupName)) {
            throw new RuntimeException("Zu einer Gruppe ist kein Verzeichnis bekannt:\n\tgroupName = '" + this.groupName + "'\n");
        }
        String string = this.localUnzippedDirnamesByGroupName.get(this.groupName);
        if (!FileHelper.isDirectory(string)) {
            throw new RuntimeException("Das Verzeichnis zu einer Gruppe existiert nicht:\n\tgroupName = '" + this.groupName + "'\n\tunzipDirectory = '" + string + "'\n");
        }
        List<String> list = FileHelper.findAllFilesInMainDirectoryNio2(string);
        return list;
    }

    private void createListNameByBareListFilenameMap(String string) {
        List<GroupFileEntry> list = GroupFileIo.readGroupFile(string);
        this.listNameByBareListFilenameMap = GroupFileIo.createListNameByBareListFilenameMap(list);
    }

    private void initProgressGui() {
        this.progressDialog.initNumberOfTasksToDo(this.groupName, this.ownListFilenamesInArchive.size());
    }

    private void informUserAboutGroupFileFailure(String string) {
        String string2 = "Achtung";
        String string3 = "Im Ausgepackten Archiv der Gruppe " + string + " konnte keine Gruppendatei gefunden werden\noder es gab ein Problem beim Einlesen der Gruppendatei.\n\nDaher werden keine Listen aus dieser Gruppe importiert.";
        GuiTools.informUser(this.uiObjects.getWindowAsComponent(), string2, string3);
    }

    private void informUserAboutOwnListFilesInArchiveNotLikeInGroupFileFailure(String string) {
        String string2 = "Achtung";
        String string3 = "Im Ausgepackten Archiv der Gruppe " + string + " weichen die enthaltenen\neigenen Listen von denen in der Gruppendatei ab\n\nDaher werden keine Listen aus dieser Gruppe importiert.";
        GuiTools.informUser(this.uiObjects.getWindowAsComponent(), string2, string3);
    }

    private void removeOldOwnListsOfGroup() {
        Text.say("Entferne ggf. vorhandene, alte Listen der Gruppe '" + this.groupName + "' ...");
        OwnLists ownLists = this.dataStructures.getOwnLists();
        OwnListGroup ownListGroup = OwnListGroup.createByGroupName(this.groupName);
        String string = ownListGroup.getNameStart();
        ownLists.deleteOwnListsOfGroup(string);
    }

    private void importOwnList(String string, String string2) {
        Text.say("Importiere: " + string + " unter dem Namen '" + string2 + ".");
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.importOwnListFromGroup(string, string2);
    }

    private void importOwnListFilenamesInArchive() {
        this.progressDialog.startingWithTask(this.groupName);
        for (String string : this.ownListFilenamesInArchive) {
            String string2 = FileHelper.getBareName(string);
            this.progressDialog.aboutToExceuteOneTaskSoon(this.groupName, string2);
            String string3 = this.listNameByBareListFilenameMap.get(string2);
            this.importOwnList(string, string3);
            this.progressDialog.oneTaskDone(this.groupName, string2);
        }
    }

    private void removeTemporarilyFiles() {
        this.removeZipFiles();
        this.removeUnpackedArchiveDirectories();
    }

    private void removeZipFiles() {
        for (String string : this.groupNamesToDownload) {
            String string2 = this.localZipFilenamesByGroupName.get(string);
            this.deleteFile(string2);
        }
    }

    private void removeUnpackedArchiveDirectories() {
        for (String string : this.groupNamesToDownload) {
            String string2 = this.localUnzippedDirnamesByGroupName.get(string);
            FileHelper.deleteTreeIgnoreErrors(string2);
        }
    }

    private void deleteFile(String string) {
        try {
            FileHelper.deleteFileIfExistent(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private void actualizeInEdt() {
        if (this.ownListImportExportDirectorySelected) {
            this.actualizeOwnListsInGui();
        }
        LongTimeProcessInformer longTimeProcessInformer = this.uiObjects.getInformer();
        longTimeProcessInformer.endLongTimeProcess();
    }

    private void actualizeOwnListsInGui() {
        OwnListsPartActualizer ownListsPartActualizer = this.uiObjects.getOwnListsPartActualizer();
        ownListsPartActualizer.actualizeOwnListsPart();
    }

    private void showError(Exception exception) {
        ErrorHandler errorHandler = this.uiObjects.getErrorHandler();
        errorHandler.error("Es trat ein Fehler beim Importieren der ausgew\u00e4hlten " + NumberString.germanPlural(this.groupNamesToDownload.size(), "Gruppen", "Gruppe") + " auf:\n" + exception.getMessage(), exception);
    }

    private void storeInteresstedGroupsWithoutAnyDownload() {
        new Thread(() -> this.storeInteresstedGroupsWithoutAnyDownloadInOwnThread()).start();
    }

    private void storeInteresstedGroupsWithoutAnyDownloadInOwnThread() {
        this.updateNewerOwnListVersionAndInterestEntriesWithGuiSelection();
        this.storeInterestAndVersionFile();
    }
}

