package de.duehl.basics.autodetect.ent.multiple;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.autodetect.ent.EntWorker;

/**
 * Diese Klasse ist die abstrakte Basis einer Klasse, die im Text (ent) alle bekannten Begriffe
 * einer Art findet  und diese in einer Liste sammelt. Dabei werden die Begriffe in ent durch
 * Platzhalter ersetzt und Kommentare zur Auffindung der Begriffe gesammelt.
 *
 * @version 1.01     2022-05-06
 * @author Christian Dühl
 */

abstract public class MultipleEntityReplacer extends EntWorker {

    /**
     * Kürzel das vorn vor der Position im Entitätenplatzhalter steht, z.B. 'func' in <<func:3>>.
     */
    protected final String replacementFrontPart;

    /** Die Liste der hier ermittelten Dinge, wie z.B. die Funktionen der Personen. */
    protected final List<String> valueList;

    /**
     * Konstruktor.
     *
     * @param ent
     *            Ursprünglich der rohe Text, dieser wird/wurde bei der Analyse aber verändert und
     *            Teile durch die Entitäten wie <<street:2>> ersetzt.
     * @param replacementFrontPart
     *            Kürzel das vorn vor der Position im Entitätenplatzhalter steht, z.B. 'func' in
     *            <<func:3>>.
     */
    public MultipleEntityReplacer(String ent, String replacementFrontPart) {
        super(ent);
        this.ent = ent;
        this.replacementFrontPart = replacementFrontPart;
        valueList = new ArrayList<>();
    }

    /** Sucht, sammelt und ersetzt in ent. */
    public abstract void replace();

    /** Getter für die Liste der hier ermittelten Dinge, wie z.B. die Funktionen der Personen. */
    public final List<String> getList() {
        return valueList;
    }

}
