package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Pattern;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse stellt die Methode zum Parsen eines Datums mit zweistelliger Jahreszahl aus einem
 * String dar.
 *
 * Erkannt werden:
 *     - 11.02.18
 *     - 11. 02.    18
 *     - 11.2.18
 *     - 1.1.18
 *
 * Aber nicht: 11.02.67, daraus wird 11.02.2067.
 *
 * @version 1.01     2018-11-16
 * @author Christian Dühl
 */

public class DateParseMethodTwoDigitYear extends DateParseMethod {

    private final static Pattern PATTERN = Pattern.compile(
            "(\\d{1,2})\\.\\s*(\\d{1,2})\\.\\s*(\\d{2})");

    public DateParseMethodTwoDigitYear(String dateToParse) {
        super(dateToParse, PATTERN);
    }

    @Override
    protected ImmutualDate createDateFromMatcher() {
        int day   = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int year  = Integer.parseInt(matcher.group(3));
        year += 2000;

        return new ImmutualDate(day, month, year);
    }

}
