package de.duehl.basics.io;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.text.Text;

/**
 * Diese Klasse stellt die abstrakte Basis einer Datei dar, die kontinuierlich in eine Datei
 * schreibt und nach jedem Schreiben die Datei schließt.
 * Zu Beginn wird die Datei leer angelegt.
 *
 * @version 1.01     2017-03-24
 * @author Christian Dühl
 */

public abstract class ContinuousFileAppender {

    /** Name der Datei, in die geschrieben wird. */
    private final String filename;

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der Datei, in die geschrieben wird.
     */
    protected ContinuousFileAppender(String filename) {
        this.filename = filename;
        FileHelper.createEmptyFile(filename);
    }

    /** Schreibt eine Zeile in die Datei. */
    protected void writeln(String line) {
        FileHelper.appendLineToFile(line, filename);
    }

    /** Schreibt eine leere Zeile in die Datei. */
    protected void writeln() {
        FileHelper.appendLineToFile("", filename);
    }

    /** Schreibt eine Trennlinie mit einer Leerzeile darüber und darunter. */
    protected void bar() {
        writeln();
        writeln(Text.multipleString("-", 80));
        writeln();
    }

}
