package de.duehl.basics.io;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt ein Suchergebnis dar.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public class FilePatternSearchResult extends FileSearchResult {

    /** Match der Fundstelle. */
    private final String match;

    /**
     * Konstruktor.
     *
     * @param file
     *            Name der Datei (mit Pfad).
     * @param lineNumber
     *            Zeilennummer der Fundstelle.
     * @param searchedLine
     *            Zeile mit der Fundstelle.
     * @param match
     *            Match der Fundstelle.
     */
    public FilePatternSearchResult(final String file, final int lineNumber,
            final String searchedLine, final String match) {
        super(file, lineNumber, searchedLine);
        this.match = match;
    }

    /** Getter für den Match der Fundstelle. */
    public String getMatch() {
        return match;
    }

    /** Stringrepräsentation. */
    @Override
    public String toString() {
        return "FilePatternSearchResult [getFile()=" + getFile()
                + ", getLineNumber()=" + getLineNumber()
                + ", getSearchedLine()=" + getSearchedLine() + ", match="
                + match + "]";
    }

}
