package de.duehl.basics.io;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.io.exceptions.IORuntimeException;

public interface Reader {

    /**
     * Liest die nächste Zeile aus der Datei ein.
     *
     * @return Die nächste Zeile oder null, falls das Ende der Datei erreicht wurde.
     * @throws IORuntimeException
     *             Falls die Zeile nicht eingelesen werden konnte.
     */
    String readNextLine();

    /** Liefert die aktuelle Zeilennummer zurück. */
    int getLineNumber();

    /**
     * Schließt den Reader.
     *
     * @throws IORuntimeException
     *             Wenn es beim Schließen zu Problemen kam.
     */
    void close();

    /**
     * Gibt den Dateiinhalt (falls schon gelesen wurde: ab der momentanen Stelle) als Liste von
     * Strings zurück.
     *
     * @return Liste mit dem Dateiinhalt als Strings.
     */
    List<String> readFileToListOfStrings();

    /**
     * Gibt den Dateiinhalt (falls schon gelesen wurde: ab der momentanen Stelle) als Liste von
     * Listen von tabgetrennten Werten zurück.
     *
     * @return Liste mit dem Dateiinhalt als Strings.
     */
    List<List<String>> readFileToListOfFieldLines();

    /**
     * Gibt den Dateiinhalt (falls schon gelesen wurde: ab der momentanen
     * Stelle) als einen String zurück.
     *
     * @return String mit dem Dateiinhalt.
     */
    String readFileToString();

    /** Liest eine tabgetrennte Zeile ein. */
    List<String> readFieldsLine();

    /** Getter für den Namen der Eingabedatei. */
    String getFileName();

}
