package de.duehl.basics.io.textfile.dictionary.io.writer;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.textfile.dictionary.Dictionary;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse schreibt ein Wörterbuch in eine externe Textdatei im Format des DictionaryFiles.
 *
 * Das Format sieht wie folgt aus:
 *
 * Englisches Wort
 *     Deutsches Wort 1
 *     Deutsches Wort 2
 *     Deutsches Wort 3
 *     Deutsches Wort 4
 *
 * @version 1.01     2024-05-17
 * @author Christian Dühl
 */

public class DictionaryToNormalTextFileWriter {

    /**
     * Schreibt das übergebene Wörterbuch unter dem übergebenen Dateinamen und unter Verwendung der
     * übergebenen Kodierung.
     *
     * @param filename
     *            Name der zu schreibenden Datei.
     * @param charset
     *            Kodierung der zu schreibenden Datei.
     * @param dictionary
     *            Das zu schreibende Wörterbuch.
     */
    public static void writeDictionary(String filename, Charset charset, Dictionary dictionary) {
        String contents = "# Automatisch erzeugtes Wörterbuch\n"
                + "\n"
                + dictionary.createDescription();
        FileHelper.writeTextToFile(contents, filename, charset);
    }

}
