package de.duehl.basics.io.zip.sevenzip;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;

/**
 * Diese Klasse probiert verschieden Pfade aus, an denen sie das 7zip-Executable sucht und gibt
 * das gefundene zurück.
 *
 * @version 1.01     2024-11-26
 * @author Christian Dühl
 */

public class SevenZipPathDeterminer {

    /** Die Liste mit den möglichen Pfade zur ausführbaren 7zip-Datei. */
    public static final List<String> CD_PATH_TO_7_ZIP_CANDIDATES = CollectionsHelper.buildListFrom(
            "d:\\Meine_Programme\\7-Zip\\7z.exe", // zu Hause Win 10
            "c:\\meine_programme\\7-Zip\\7z.exe"  // Laptop Win 11
            );

    /**
     * Ermittelt den Pfad für 7zip. Konnte 7zip nicht gefunden werden, wir der leere String
     * zurückgegeben.
     */
    public static String determine7zipPath() {
        for (String candidate : CD_PATH_TO_7_ZIP_CANDIDATES) {
            if (FileHelper.isFile(candidate)) {
                return candidate;
            }
        }
        return "";
    }

}
