package de.duehl.basics.text.handling;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;

/**
 * Diese Klasse bietet Methoden rund um die Behandlung von Booleans.
 *
 * @version 1.01     2021-03-02
 * @author Christian Dühl
 */

public class BooleanHandling {

    private static final String JA = "ja";
    private static final String NEIN = "nein";

    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private static final String WAHR = "wahr";
    private static final String FALSCH = "falsch";

    private static final List<String> TRUE_VALUES = CollectionsHelper.buildListFrom(
            JA, TRUE, WAHR);
    private static final List<String> FALSE_VALUES = CollectionsHelper.buildListFrom(
            NEIN, FALSE, FALSCH);

    /** Gibt für einen boolschen Wert den String "ja" oder "nein" zurück. */
    public static String booleanToString(boolean bool) {
        return bool ? JA : NEIN;
    }

    /** Gibt für einen boolschen Wert den String "true" oder "false" zurück. */
    public static String booleanToTrueFalseString(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    /** Gibt für einen boolschen Wert den String "wahr" oder "falsch" zurück. */
    public static String booleanToWahrFalschString(boolean bool) {
        return bool ? WAHR : FALSCH;
    }

    /** Gibt für einen String "ja" bzw. "true" oder "nein" bzw. "false" boolschen Wert zurück. */
    public static boolean stringToBoolean(String booleanString) {
        for (String trueValue : TRUE_VALUES) {
            if (booleanString.equalsIgnoreCase(trueValue)) {
                return true;
            }
        }
        for (String falseValue : FALSE_VALUES) {
            if (booleanString.equalsIgnoreCase(falseValue)) {
                return false;
            }
        }

        throw new IllegalArgumentException("Der Wert des Strings der einen Booleanwert "
                + "darstellen soll '" + booleanString + "' ist unbekannt.");
    }

}
