package de.duehl.basics.autodetect.tools;

/*
 * Copyright 2023 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class EntityHelperTest {

    @Test
    public void repairHigherPositions001() {
        String ent = ", <<vn:8>> <<nn:9>>, <<vn:9>> <<nn:10>>, <<vn:10>> <<nn:11>>";
        String entityRegex = "<<nn:(\\d+)>>";
        int startingPosition = 8;
        String actual = EntityHelper.repairHigherPositions(ent, entityRegex, startingPosition);
        String expected = ", <<vn:8>> <<nn:8>>, <<vn:9>> <<nn:9>>, <<vn:10>> <<nn:10>>";
        assertEquals(expected, actual);
    }

    @Test
    public void repairHigherPositions002() {
        String ent = ""
                + ", <<gender:2>> <<vn:3>> <<nn:1>>"
                + ", <<gender:3>> <<vn:10>> <<nn:5>>"
                + ", <<gender:4>> <<vn:7>> <<nn:2>>"
                + ", <<gender:5>> <<vn:8>> <<nn:3>>"
                + ", <<gender:6>> <<vn:9>> <<nn:4>>";
        String entityRegex = "<<vn:(\\d+)>>";
        int startingPosition = 2;
        String actual = EntityHelper.repairHigherPositions(ent, entityRegex, startingPosition);
        String expected = ""
                + ", <<gender:2>> <<vn:2>> <<nn:1>>"
                + ", <<gender:3>> <<vn:9>> <<nn:5>>"
                + ", <<gender:4>> <<vn:6>> <<nn:2>>"
                + ", <<gender:5>> <<vn:7>> <<nn:3>>"
                + ", <<gender:6>> <<vn:8>> <<nn:4>>";
        assertEquals(expected, actual);
    }

    @Test
    public void extractReplacementFrontPartFromEntityRegex() {
        String entityRegex = "<<street:(\\d+)>>";
        String actual = EntityHelper.extractReplacementFrontPartFromEntityRegex(entityRegex);
        String expected = "street";
        assertEquals(expected, actual);
    }

}
