package de.duehl.basics.start;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.zip.UnzipWith7Zip;

public class Testing7ZipUnzipping2 {

    public static void main(String[] args) {
        String dir = "c:/temp/zipping_test3";

        String zipFilename =
                FileHelper.concatPathes(dir, "de.duehl.vocabulary.japanese_0.02.51_gesamt.zip");

        String sourcesDir = FileHelper.concatPathes(dir, "de.duehl.vocabulary.japanese_0.02.51");
        FileHelper.createDirectoryIfNotExists(sourcesDir);

        UnzipWith7Zip unzip = new UnzipWith7Zip();
        unzip.unzip(zipFilename, sourcesDir);
    }

}
