package de.duehl.swing.ui.buttons.painted;

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Schalten zum ersten Eintrag dar.
 * Eine quadratische Ansicht wird nicht unterstützt.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class FirstButton extends PaintedButton {

    private static final long serialVersionUID = -1441507523499749679L;

    /** Konstruktor mit schwarzer Farbe. */
    public FirstButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public FirstButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintVerticalSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintVerticalSymbol();
    }

    /**
     * Zeichnet das Symbol in horizontaler Anordnung. isForceSquare() wird ignoriert.
     *
     *  8--7                   1
     *  |  |                 .   6
     *  |  |              .    .
     *  |  |           .    .
     *  |  |       .     .
     *  |  |    2      5
     *  |  |       .     .
     *  |  |           .    .
     *  |  |              .    .
     *  |  |                 .   4
     * 10--9                   3
     */
    private void paintHorizontalSymbol() {
        int delta = 6;  // Abstand von den Buttonkanten.
        int off = 4;    // Breite rechts.
        int xOff = 3;   // Abstand zwischen der linken oberen Delta-Ecke und Punkt 1.
        int yOff = 3;   // Abstand zwischen der linken oberen Delta-Ecke und Punkt 6.
        int middleOff = 7;   // Abstand zwischen Punkt 5 und Punkt 2
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;

        int hightCenter = getHeight() / 2;

        paintPolygon(
                new PixelPoint(right - xOff,            upper       ), //  1
                new PixelPoint(left + off,              hightCenter ), //  2
                new PixelPoint(right - xOff,            lower       ), //  3
                new PixelPoint(right,                   lower - yOff), //  4
                new PixelPoint(left + off + middleOff,  hightCenter ), //  5
                new PixelPoint(right,                   upper + yOff)  //  6
                );

        paintPolygon(
                new PixelPoint(left,        upper), //  7
                new PixelPoint(left + off,  upper), //  8
                new PixelPoint(left + off,  lower), //  9
                new PixelPoint(left,        lower)  // 10
                );
    }

    /**
     * Zeichnet das Symbol in vertikaler Anordnung. isForceSquare() wird ignoriert.
     *
     *  8------------------------9
     *  |                        |
     *  7-----------------------10
     *
     *              2
     *           .     .
     *        .     5     .
     *     .     .     .     .
     *   1   .            .    3
     *     6                 4
     */
    private void paintVerticalSymbol() {
        int delta = 6;  // Abstand von den Buttonkanten.
        int off = 4;    // Breite rechts.
        int xOff = 3;   // Abstand zwischen der linken oberen Delta-Ecke und Punkt 1.
        int yOff = 3;   // Abstand zwischen der linken oberen Delta-Ecke und Punkt 6.
        int middleOff = 7;   // Abstand zwischen Punkt 5 und Punkt 2
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;

        int widthCenter = getWidth() / 2;

        paintPolygon(
                new PixelPoint(left,          lower - yOff           ), //  1
                new PixelPoint(widthCenter,   upper + off            ), //  2
                new PixelPoint(right,         lower - yOff           ), //  3
                new PixelPoint(right - xOff,  lower                  ), //  4
                new PixelPoint(widthCenter,   upper + off + middleOff), //  5
                new PixelPoint(left + xOff,   lower                  )  //  6
                );

        paintPolygon(
                new PixelPoint(left,   upper      ), //  7
                new PixelPoint(left,   upper + off), //  8
                new PixelPoint(right,  upper + off), //  9
                new PixelPoint(right,  upper      )  // 10
                );
    }

}
