package de.duehl.swing.ui.components.selections.datetime.spinnermodels;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import javax.swing.SpinnerListModel;

/**
 * Diese Klasse stellt das Modell für einen Spinner dar, bei dem man nah dem letzten Wert zum
 * ersten und vor dem ersten Wert zum letzten kommt.
 *
 * @version 1.01     2017-03-17
 * @author Christian Dühl
 */

public class CyclingSpinnerListModel<T> extends SpinnerListModel {

    private static final long serialVersionUID = 1L;

    T firstValue, lastValue;

    public CyclingSpinnerListModel(List<T> values) {
        super(values);
        firstValue = values.get(0);
        lastValue = values.get(values.size() - 1);
    }

    @Override
    public Object getNextValue() {
        Object value = super.getNextValue();
        if (value == null) {
            value = firstValue;
        }
        return value;
    }

    @Override
    public Object getPreviousValue() {
        Object value = super.getPreviousValue();
        if (value == null) {
            value = lastValue;
        }
        return value;
    }

    @SuppressWarnings("unchecked")
    public T getSelectedValue() {
        return (T) getValue();
    }

}
